/*****
 *
 *    functions for password interactions:
 *    @ encryption and especially the graphical password. The functions
 *    @ are loaded via ajax and included via new Function( thisContent ) 
 *    @ © Dr. Dirk Fischer, use-Optimierung, Köln.
 *    @ Possibly other copyrights reported at the place (as Streamable SHA-3). 
 * 
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU Affero General Public License as
 *    published by the Free Software Foundation, either version 3 of the
 *    License, or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 *****/
!function(e,t){var n={apiPath:useLib.conf.useLibPath+"api/useLibSecureAPI.php",identPath:useLib.conf.useLibPath+"api/useLibIdentAPI.php",corsAPI:"api/useLibCorsAPI.html",SHA3:"SHA3_512",transferLowSize:512,externalAuth:!1,hashAuth:!1,encryptAuth:!1,savedateAuth:!0,email:!1,transferBase:"b_2cZt1BvLelSYYOWLah4eeERafYgCLbT83Gx6cfsbDR92Nud4-aqw",encryptSalt:!1,originalPW:!1,base64crypt:!1,onePadLength:5e4,passwordQuality:80,filePasswordQuality:0,pseudoCrypt:"just4web",wikiEnsemble:!1},i={en:{PWdialogAPI:"Login",PWdialogNEW:"Confirm",PWdialogENC:"Encryt",PWdialogDEC:"Decrypt",hPasswordAPI:["Input of your access data required (Login)","To use the service ++your access authorization++ must be checked. For this purpose your e-mail address and a ++highly encrypted++ version of your password are required. A new password is securely confirmed in two steps.","Your email address ++belongs++ to your account and is ++fixed in the system++. The password has to be changed during ++registration++ or in case of ++forgetting++ to be confirmed. For this purpose a check code is send to the email address to confirm the password and the address itself over this second contact way to confirm."],hPasswordNEW:["Confirm the new password?","The control link was clicked, which confirms the password and email address through a second contact channel.\n;;If the new password was not requested by yourself, the email can be ignored."],hPasswordSTO:["Encrypted local storage content!","Previously security-related access data ++personalized++ were encrypted with the password. Also to simplify the input, only the password must be entered. The encryption applies to the following e-mail address:"],hPasswordENC:["Save form file encrypted","The HTML file can be protected with all its contents against access by third parties by means of password encryption. There is ++no possibility to change the file password later++ or to request a replacement password. Without this password the text can never be made readable again. Therefore, a ++mnemonic++ should be entered. This appears with every password request.\n\nIt is also possible to enter ++no password++. If the pseudo password: ++"+n.pseudoCrypt+"++;;\nis entered, the content will be stored encrypted and compressed, but automatically decrypted when loaded."],hPasswordDEC:["Verification of access required!","The file has been protected against access by third parties by means of encryption. Only with the correct password it is possible to display the encrypted file content and data!"],l0Password:["Your email address","Your e-mail address is used for ++identification++ and as a ++contact++ for password confirmation. The link to the confirmation form will be sent to this address."],l1Password:["Your password","Your password is your secret. Therefore it cannot be known to ++third parties++. Therefore, it is also protected by many security measures and ++highly encrypted++ already during the input.","Just enter your password continuously (any characters), the cursor will jump automatically. If you fill in the fields separately, they are automatically joined. By clicking on the ++eye symbol++: the password can be edited as plain text."+(useLib.conf.puzzlePassword?"Especially secure: the innovative puzzle password with a click on the back symbol.":"")],lnewPW:["Use as __new__ password.","In case of ++registration++ a new password must __always__ be assigned. Also if the password was ++forgotten++, the checkmark must be set!;;\n\n++Attention++: An ++email++ will be sent directly! Please check the corresponding e-mail box. The old password will remain until confirm the new one here."],l0Mnemonic:["Password repeat","When entering the password for the first time, it must be repeated, because an incorrect entry will make the content unreadable."],l1Mnemonic:["Password mnemonic","Any text can be entered as a note. This can be used variably, especially in project work."],confirmPersonal:["Encrypted ++local storage++ (optional)","If this option is used, only the administration password needs to be entered from the next login onwards. Other fields, including the e-mail address %%, are encrypted stored locally in the HTML file of the APP.\n\nIn addition, this HTML file can be made the only allowed login option. For this purpose, the file receives a kind of branding (personalized transfer salt), which is also stored. However, the application must then __always__ be used by opening this HTML file.\n\nShould the application be stored personalized locally?","as well as entered values for %% etc.","create own secret (transfer salt)."],newStore:"++Attention:++ The values previously ++personalized++ encrypted with the password must be entered again belonging to the e-mail address: %%. This file must be saved encrypted with the new password, and the new password must then be confirmed again.",confirmNewident:"= Request new identification?\n\nFor further processing, the HTML file may be created with a different identification and encryption. For this purpose it should be saved under a different name: %%",confirmEmail:"=The e-mail for password or account confirmation was sent successfully!",errorEmail:"=The e-mail for password or account confirmation couldn't unfortunately be send!",confirmWiki:"= The read permission for this file is given!\n\nDecryption is being performed, which may take a moment in certain cases.",errorWiki:"= Unfortunately, there is no read permission for this file with the transmitted access data!",passwordError:"= No security codes in this file that fit to email address and password!",errorDecrypt:"= Faulty decryption\n\nData were received, but they could not be decrypted.",errorDrag:"= No password transfer, because not yet entered!",noAuthorization:"= Access permission failed!\n\nUnfortunately, the verification of your permission to access the contents of this file was not successful.",olderSavings:"= older savings\n\n"},de:{PWdialogAPI:"Anmelden",PWdialogNEW:"Bestätigen",PWdialogENC:"Entschlüsseln",PWdialogDEC:"Verschlüsseln",hPasswordAPI:["Eingabe Ihrer Zugangsdaten erforderlich (Login)!","Für die Nutzung des Services muss ++Ihre Zugriffsberechtigung++ geprüft werden. Dazu dienen Ihre E-Mail-Adresse und eine ++hochverschlüsselte++ Version Ihres Passworts. Ein neues Passwort wird in zwei Schritten abgesichert bestätigt.","Ihre E-Mail-Adresse ist in Ihrem Konto ++beim System++ fest ++hinterlegt++. Das Passwort muss bei der ++Registrierung++ oder im Falle des ++Vergessens++ bestätigt werden. Hierzu wird an die E-Mail-Adresse ein Kontrolllink versendet, der das Passwort und die Adresse über diesem zweiten Kontaktweg bestätigt (Zwei-Faktor-Authentifizierung)."],hPasswordNEW:["Das neue Passwort bestätigen?","Der Kontrolllink wurde angeklickt, der das Passwort und die E-Mail-Adresse über einen zweiten Kontaktweg bestätigt.;;\nWenn das neue Passwort nicht selber angefordert wurde, kann die E-Mail ignoriert werden."],hPasswordSTO:["Verschlüsselte lokale Speicherung!","Zuvor wurden mittels des Passworts sicherheitsrelevante Zugangsdaten ++personalisiert++ verschlüsselt. Auch zur Erleichterung der Eingabe muss nur das dafür verwendete Passwort eingeben werden. Die Verschlüsselung gilt für die folgende E-Mail-Adresse: "],hPasswordENC:["Datei verschlüsselt speichern","Die HTML-Datei kann mit allen Inhalten gegen Zugriff durch Dritte mittels Passwort durch Verschlüsselung geschützt werden. Es gibt ++keine Möglichkeit das Dateipasswort später zu ändern++ oder ein Ersatzpasswort anzufordern. Ohne dieses Passwort kann der Text nie mehr lesbar gemacht werden. Es sollte daher eine ++Merkhilfe++ eingetragen werden. Diese erscheint bei jeder Passwortabfrage.\n\nEs kann auch ++kein Dateipasswort++ eingeben werden. Wenn das Pseudo-Passwort: ++"+n.pseudoCrypt+"++;;\neingegeben wird, werden die Inhalte zwar verschlüsselt und komprimiert gespeichert, aber beim Laden automatisch entschlüsselt."],hPasswordDEC:["Dateipasswort zur Entschlüsselung erforderlich!","Die HTML-Datei mit allen Inhalten wurde gegen Zugriff durch fremde Dritte mittels Verschlüsselung geschützt. Nur mit dem richtigen Passwortes ist es möglich, die verschlüsselten Dateiinhalte und -daten anzuzeigen!"],l0Password:["Ihre E-Mail-Adresse","Ihre E-Mail-Adresse dient der ++Identifikation++ und als als ++Kontakt++ zur Passwortbestätigung. Der einmaliger Prüfcode wird an diese Adresse gesendet."],l1Password:["Passwort","Das Passwort ist ein Geheimnis. Es darf daher fremden ++Dritten++ nicht bekannt sein. Deshalb wird es auch durch viele Sicherheitsmassnahmen geschützt und bereits während der Eingabe ++höchstwertig verschlüsselt++.","Geben Sie das Passwort einfach fortlaufend ein (beliebige Zeichen), der Cursor springt automatisch weiter. Füllen Sie die Felder getrennt aus, werden diese automatisch vereinigt. Bei Klick aufs ++Auge-Symbol++ kann das Passwort in Klarschrift bearbeitet werden. "+(useLib.conf.puzzlePassword?"Besonders sicher: das innovative Puzzle-Passwort mit Klick auf das hintere Symbol.":"")],lnewPW:["Als __neues__ Passwort verwenden.","Bei der ++Registrierung++ muss __immer__ ein neues Passwort vergeben werden. Auch wenn das Passwort ++vergessens++ wurde, muss der Haken gesetzt werden!;;\n++Achtung++: Eine ++E-Mail++ mit einem ++Kontrolllink++ wird direkt versendet!! Bitte das entsprechende E-Mail-Postfach abfragen. Das alte Passwort bleibt erhalten, bis das neue hier bestätigt wurde."],l0Mnemonic:["Passwortwiederholung","Bei der ersten Eingabe muss das Passwort wiederholt werden, da eine Fehleingabe den Inhalt unlesbar macht"],l1Mnemonic:["Merkhilfe für Passwort","Es kann ein beliebiger Text als Hinweis eingegeben werden. Dies kann gerade in der Projektarbeit variabel eingesetzt werden."],confirmPersonal:["= Verschlüsselte lokale Speicherung (optional)\n\nWird diese Möglichkeit genutzt, muss ab dem nächsten ++Anmelden++ (Login) ++nur++ noch das ++Verwaltungspasswort++ eingegeben werden, da andere Felder u. a. die E-Mail-Adresse sowie eingetragene Werte für %% etc. ++personalisiert++ in der HTML-Datei der APP verschlüsselt ++lokal gespeichert++ werden.\n\n++Zusätzlich++ kann diese HTML-Datei zur ++einzigen++ erlaubten ++Anmeldemöglichkeit++ gemacht werden. Hierzu erhält die Datei eine Art ++Brandzeichen++ (personalisierter Transfer-Salt), welches mit gespeichert wird. Der Aufruf der Anwendung ++muss dann aber __immer__++ durch Öffnen ++dieser HTML-Datei++ erfolgen.\n\nSoll die Anwendung personalisiert lokal gespeichert werden?","eigenes Brandzeichen erzeugen (Transfer-Salt)."],newStore:"++Achtung:++ Die zuvor mittels des Passworts für die E-Mail-Adresse: %% ++personalisiert++ verschlüsselten Werte müssen erneut eingegeben, diese Datei mit dem neuen Passwort verschlüsselt gespeichert und das neue Passwort anschließend wieder bestätigt werden.",confirmNewident:"= Neue Identifikation anfordern?\n\nZur Weiterbearbeitung darf die HTML-App mit einer anderen Identifikation und Verschlüsselung angelegt werden. Dazu sollte sie unter einem anderen Namen gesichert werden: %%",confirmWiki:"= Die Leseberechtigung für diese Datei wurde erteilt!\n\nEs erfolgt die Entschlüsselung, was in bestimmten Fälle einen Augenblick dauern kann.",errorWiki:"= Es liegt leider keine Leseberechtigung für diese Datei mit den übermittelten Zugangsdaten vor!",passwordError:"= Zu E-Mail-Adresse und Passwort sind keine passenden Sicherheitskennungen in dieser Datei hinterlegt!",errorDecrypt:"= Fehlerhafte Entschlüsselung\n\nEs wurden zwar Datenempfangen, diese konnten aber nicht entschlüsselt werden.",errorDrag:"= Keine Passwortübergabe, da noch nicht eingegeben!",noAuthorization:"= Zugriffsberechtigung nicht erteilt!\n\nLeider war die Überprüfung Ihrer Zugriffsberechtigung auf die Inhalte dieser Datei nicht erfolgreich.",olderSavings:"= Vorherige Speicherungen\n\n"}},r=useLib.$,a=useLib.$LS,o=useLib.conf?useLib.conf.lang:"en",l=function(e,t){return e=btoa(e).replace(/\+/g,"-").replace(/\//g,"_").replace(/=/g,""),t?(e+"0000").slice(0,t):e},u=function(e){return atob(e.replace(/-/g,"+").replace(/_/g,"/"))},c=function(){return"SHA3_256"===n.SHA3?44:88},d=function(e){return Array.apply(null,Array(e)).map((function(){return"-abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_"[parseInt(64*Math.random())]})).join("")},h=function(e){for(var t=e.length-1;t>0;t--){var n=Math.floor(Math.random()*(t+1)),i=e[t];e[t]=e[n],e[n]=i}return e},g=function(e,t,i){i=i?256==i?"SHA3_256":"SHA3_512":n.SHA3;var r=useLib.SHA3.init(useLib.SHA3[t?"SHA3_256"==i?"SHAKE128":"SHAKE256":i]);return r.absorb(useLib.escapeUnicode(e)),r.squeeze(t)},p=function(e){return l(g(e),c())},f=function(e,t,i){for(var r=g(t,n.onePadLength,i),s="",a=0;a<e.length;a+=n.onePadLength)s+=o(e.substr(a,n.onePadLength),r);return s;function o(e,t){for(var n=0,i=e.length,r="";n<i;n++)r+=String.fromCharCode(255&(e.charCodeAt(n)^t[n]));return r}},w=function(e){var t=e.charCodeAt(0);return t=45==t?0:t<58?t-47:t<91?t-54:95==t?37:t-59,e.substr(t,23)},m=function(e,t){n.email=e.email,z.email=n.email,e.password=e.password||t,k=y("uLconfSecret",e.password),S.password=e.password,function(e){var t=k.transferSecret||z.transferSecret||n.transferBase;e&&t&&(S.ident=p(n.email+t),S.transfer=p(e+t),S.email=n.email,k.originalPW&&(S.transfer=k.originalPW),a("uLsecureSession",S,!0),useLib.$CN.remove(r(useLib.cssNS.secDragg),useLib.cssNS.locked))}(e.password),n.originalPW&&e.originalPW&&(k.originalPW=e.originalPW)},b=function(e,n,i){var s=function(){var e=r("uLsecureStore");e||((e=t.createElement("style")).id="uLsecureStore",e.type="text/css",e.charset="utf-8",e.innerHTML="\n",t.head.appendChild(e));return e}(),a="#"+e+':before{content:"';!1===n?n="":(n=JSON.stringify(n),n=a+(i?l(f(n,i)):"//"+l(n))+'";}\n'),a=new RegExp(a+'[^"]+";}\n'),s.innerHTML=a.test(s.innerHTML)?s.innerHTML.replace(a,n):s.innerHTML+n},y=function(e,t){var n=r("uLsecureStore");if(n){n=(n=!!(n=n.innerHTML.match(new RegExp("#"+e+':before{content:"([^"]+)')))&&n[1])?"//"==n.slice(0,2)?u(n.slice(2)):!t||f(u(n),t):{};try{n=JSON.parse(n)}catch(e){n={}}return n}return{}},P=function(){var e=location.pathname,n=t.createElement("a");e=e.slice(e.lastIndexOf("/")+1),n.href="data:text/plain;charset=utf-8,"+encodeURIComponent(useLib.ownHTML),n.download=e,t.body.appendChild(n),n.click(),setTimeout((function(){t.body.removeChild(n)}),0)},v=function(e,t,i,r=!1){r=r||S.transfer;for(var s,a,o,u={uL_path:e,uL_verb:t||"GET",uL_mail:n.email,uL_timestamp:Math.floor((new Date).getTime()/1e3),uL_json:i||null,uL_codes:k||{},uL_auth:w(r),uL_mist:""},c=h(Object.keys(u)),g=l(d(32),44),p="{",m=0;m<c.length;m++)p+='"'+c[m]+'":'+JSON.stringify(u[c[m]])+",";return i=useLib.escapeUnicode(p.slice(0,-1))+"}",i=(s=i,a=n.transferLowSize-(s.length-6)%n.transferLowSize,o=s.indexOf('"uL_mist":"')+11,a>0?s.slice(0,o)+d(a)+s.slice(o):s).slice(5,-1),l(f(i,r+g))+g},L=function(e,t,n,i){T(e,(function(e){(e=!!e&&e.replace(/\.php\?/,".json.css?"))&&useLib.loadJSONCSS(e,(function(e){delete useLib.extern[url],t&&t(e)}),12e3)}),n,i)},z=y("uLconfEmail"),S=a("uLsecureSession",null,!0)||{},k={},D=!1;function T(e,t,s,a,l=!1){var u=r("uLsecureStore"),h="DEC,ENC".indexOf(e)>-1;if(!D){if((h||e==n.externalAuth)&&S.filePassword)E(!0);else if(!h&&"NEW"!=e&&S.password&&S.ident)E(I());else{var g=i[o],f=[],w=n.originalPW,L=h||e==n.externalAuth?n.filePasswordQuality:n.passwordQuality,A=["span",{}].concat(useLib.getStruct.header(g["hPassword"+(h||"NEW"==e?e:u?"STO":"API")]),[u?["div",{style:"font-weight:bold;text-align:center;width"},n.email]:null,["form",{CN:useLib.cssNS.dialog,name:"askForPassword",autocomplete:"off"},["fieldset",{},h||u?null:useLib.getStruct.input("uLemail",g.l0Password,{type:"email",name:"conf.email",value:l||n.email||"",disabled:"NEW"==e?"disabled":null,required:!0}),useLib.getStruct.input("uLpassword",g.l1Password,{type:"password",name:"conf."+(h?"fileP":"p")+"assword",CN:"noTask",required:L>0,min:L})].concat(h?["DEC"==e?null:useLib.getStruct.input("uLRepeat",g.l0Mnemonic,{type:"passwordrepeat",name:"pwRepeat",CN:"noTask",min:0}),useLib.getStruct.input("uLmnemonic",g.l1Mnemonic,{type:"textarea",name:"conf.localMnemonic",S:"height:4.5em;",rows:3,value:S.localMnemonic})]:"NEW"!=e&&e!=n.externalAuth?[useLib.getStruct.radioCheck(1,0,g.lnewPW[0],"","conf.forgot","",!n.email,0,0,""),["div",{IH:useLib.WIKI.toHTML(g.lnewPW[1])}]]:null),h||u||"NEW"==e||!n.wikiEnsemble?null:function(e){var t=useLib.wikiSigns,n=[];e=e.replace(new RegExp("\n+"+t.inform,"gmi"),t.inform).split("\n");for(var i,r,s=0;s<e.length;s++)e[s][0]==t.header&&(e[s][1]==t.header?(code="",e[s]=a(e[s],2),r=(i=e[s+1].split(t.interface))[0].slice(1).trim(),(i=i[1]?JSON.parse('{"'+i[1].trim().replace(/=/g,'":').replace(/"\s+/g,'","')+"}"):{}).name="codes."+code,i.CN="noTask",i.type=r,n[n.length-1].push(useLib.getStruct.input("uLcS"+s,e[s],i,"100%")),s++):(e[s]=a(e[s],1),f.push(e[s][0]),n.push(["fieldset",{},["legend",{},e[s][0]],u(e[s][1],"inform"),u(e[s][2],"explain")])));return n.length>1?["span",{}].concat(n):n[0];function a(e,n){return(e=e.trim().slice(n).split(t.inform))[0]=l(e[0],2==n),e[1]&&(e[1]=l(e[1].slice(0,-t.informEnd.length))),e[3]&&(e[2]=l(e[3].slice(0,-t.explainEnd.length)),e.length=3),e}function l(e,n=!1){return e=e.split(t.append),n&&(code=e.slice(-1)[0].trim()),e["en"==o?1:0].trim()}function u(e,t){return e?["span",{CN:useLib.cssNS[t],IH:e}]:null}}(n.wikiEnsemble),useLib.getStruct.buttonRow()]]);D=!0,"ENC"==e&&(n.originalPW=!0),useLib.setModal("askForPassword","form","draggable sizable closable",A,g[e],"60em",(function(l){if(!1!==l)if(u)l.conf&&(l.conf.forgot?(useLib.DOM.removeNode(u),D=!1,useLib.setMsg("hint",g.newStore.replace(/%%/,n.email),0,6500),setTimeout((function(){T(e,t,s,a)}),6500)):(S.password=l.password,k=y("uLconfSecret",l.password),m(l.conf,l.conf.password),E(I())));else if(h)l.conf?(S.oriFilePW=k.originalPW,S.filePassword=l.conf.filePassword,S.localMnemonic=l.conf.localMnemonic):S.filePassword="",E(!0);else if(e==n.externalAuth)l.conf&&(S.email=l.conf.email,S.filePassword=l.conf.password,n.hashAuth||(S.oriFilePW=k.originalPW)),E(!!l.conf);else if(l.conf){if(m(l.conf,l.conf.password),l.codes)for(var v in l.codes)k[v]=l.codes[v];l.conf.forgot?f.length?(l.conf.email,(L=i[o].confirmPersonal.slice(0))[0]=useLib.WIKI.toHTML(L[0].replace(/%%/,f.length?f.join(", "):""))+'<div><input type="checkbox" id="_uL_cP_" onchange="useLib.security.conf.ownTransCode=!!this.checked;"><label style="padding-left:1.5em;" for="_uL_cP_">'+L.pop()+"</label></div>",useLib.confirm(L[0],(function(e){var t;!0===e&&(n.ownTransCode&&(e=d(c()),n.encryptSalt?k.transferSecret=e:z.transferSecret=e),b("uLconfEmail",z),k&&b("uLconfSecret",k,t),useLib.ownHTML=useLib.ownHTML.replace(/<style\s+id="uLsecureStore"[\s\S]+?<\/style>\n/,"").replace(/(\n?<\/head>)/,r("uLsecureStore").outerHTML+"$1"),P()),x()}))):x():"NEW"==e?(e=n.identPath+"?uL="+a+p(S.password+a),/.css?/.test(n.identPath)?useLib.loadJSONCSS(e,E):useLib.security.submitCORS(e,E,s,{},"WIKI",!0)):E(I())}var L;n.originalPW=w,D=!1})),h&&!u&&(r("uLmnemonic").parentNode.style.width="100%")}return!1}function I(){return n.apiPath+"?uL="+S.ident+v(e,s,a)}function E(n){e&&useLib.extern[e]&&delete useLib.extern[e],"function"==typeof t&&t(n)}function x(){var i=d(c()),r={ident:S.ident,MAC:S.transfer};a&&(r.uL_forward={uL_path:e,uL_verb:s,uL_json:a}),t(n.identPath+"?uL="+i+v("uLinitPW",s,r,p(S.password+i))+"&em="+btoa(n.email)+"&lg="+o)}}function A(e){return"uLSecConf="==(e=atob(e)).slice(0,10)&&(m(JSON.parse(e.slice(10)),!1),!0)}n.email=S.email||z.email||n.email||!1,S.password&&(k=y("uLconfSecret",S.password)),t.addEventListener("DOMContentLoaded",(function(){var e=location.href.match(/(&|\?)email=(.+)$/),t=location.href.match(/(&|\?)code=([^&]+)/);t?setTimeout((function(){T("NEW",null,"put",t[2],e[2])}),2e3):!n.email&&e&&(n.email=e[2])}),!1),useLib.security={version:"1.06",filePasswordQuality:n.filePasswordQuality,minPW:n.passwordQuality,getStoredEmail:function(){return n.email||""},getPasswordHash:function(e){return n.originalPW&&(k.originalPW=e),p(e)},apiPath:n.apiPath,getRandStr:d,str2hash:p,shuffleArray:h,encodeJson:v,decodeJson:function(e,t){t=t||k.transfer;var n={code:401,msg:"errorDecrypt"};try{return(e=JSON.parse('{"uL_'+f(u(e.slice(0,-44)),t+e.slice(-44))+"}")).uL_auth&&t.indexOf(e.uL_auth)>-1?e.uL_json:n}catch(e){return n}},submitJSONCSS:L,cryptWiki:function(e,t,r,u=!1){var h=e.indexOf('{"useAuth":'),g=h>-1&&JSON.parse(e.slice(h,e.indexOf('"}',h)+2)),w=u||-1==h;function m(e,t){var r=n.externalAuth+"?ident="+e+"&email="+(n.hashAuth?p(S.email):S.email)+"&password="+(n.hashAuth?S.filePassword:S.oriFilePW),s="NEWIDENT"==e?"PUT":"GET";function l(n){var r=200==n.code;"NEWIDENT"!=e&&useLib.setMsg(r?"success":"error",i[o][r?"confirmWiki":"errorWiki"],0,6500),n.msg&&useLib.alert(n.msg),r&&(n=JSON.parse(n.data)).decrytkey&&("NEWIDENT"==e?(n.msg&&useLib.alert(n.msg),m(n.decrytkey,t)):(S.writeright=n.readonly||-1,S.newident=n.newident||!1,S.decrytkey=n.decrytkey,a("uLsecureSession",S,!0),t(n.decrytkey,n.msg)))}/\.css($|\?)/.test(r)?n.encryptAuth?L(r,l,s,{}):useLib.loadJSONCSS(r,l,6500):useLib.security.submitCORS(r,l,s,{},"WIKI",n.encryptAuth)}function b(e,t,s=!1,a=""){t=t.match(new RegExp("[0-9A-Za-z-_]{"+c()+"}","g")),h>-1&&(e=e.slice(e.indexOf('"}',h)+2)),w?((!s||-1!=s&&n.savedateAuth)&&(!function(){n.saveDates||(n.saveDates=[]);s&&n.saveDates[0][1]==n.email?n.saveDates[0][0]=Date.now():n.saveDates.unshift([Date.now(),n.email||!1])}(),e=JSON.stringify(n.saveDates)+e),e=LZWplus.compress(e)):e=n.base64crypt?atob(e):e.replace(/\u240D/g,"\r").replace(/\u2400/g,"\0");for(var l=0;l<t.length;l++)e=f(e,(s?"":S.filePassword)+t[l]);!w||S.decrytkey&&!S.writeright?(e=LZWplus.decompress(e),function(){if("[["==e.slice(0,2)){var t=e.slice(0,e.indexOf("]]")+2);e=e.slice(t.length);for(var r=1,s=[(t=JSON.parse(t))[0]];r<t.length-1;r++)(t[r][1]&&t[r][1]!=t[r+1][1]||t[r][0].slice(0,10)!=t[r+1][0].slice(0,10))&&s.push(t[r]);r=0;for(var l=s.length?i[o].olderSavings:"";r<s.length;r++)l+=useLib.$D.toISO(s[r][0])+" "+useLib.$D.toTime(s[r][0])+(s[r][1]?" by "+s[r][1]:"")+"\n\n";setTimeout((function(){useLib.alert(a+"\n\n"+l)}),2e3),n.saveDates=s}}(),r(e)):r(JSON.stringify(g)+(n.base64crypt?btoa(e):e.replace(/\r/g,"␍").replace(/\0/g,"␀")),S.newident||!1)}S.decrytkey?b(s,S.decrytkey):(!u&&g||n.externalAuth?g.uLMnemonic&&(S.localMnemonic=g.uLMnemonic):g={useAuth:u?p(n.pseudoCrypt):l(d(c()),c()),uLMnemonic:S.localMnemonic||""},g.useAuth==p(n.pseudoCrypt)?b(e,g.useAuth,-1):T(n.externalAuth||(w?"ENC":"DEC"),(function(t){var s,a,l;t?""==S.filePassword?r(e):S.oriFilePW&&S.oriFilePW==n.pseudoCrypt?(g.useAuth=p(S.oriFilePW),b(e,g.useAuth,-1)):n.externalAuth?g&&S.newident?(s="confirmNewident",a=S.newident,l=function(t){m(!0===t?"NEWIDENT":g.useAuth,(function(t,n=""){b(e,t,!0,n)}))},s=i[o][s].replace(/%%/,a||n.email),useLib.confirm(s,l)):m(g?g.useAuth:"NEWIDENT",(function(t,n=""){b(e,t,!0,n)})):(g.uLMnemonic=S.localMnemonic,b(e,g.useAuth)):r(-1)})))},dragsecure:function(e){var t=useLib.$E;e.draggable=!0,e.dropable=!0,t(e,"dragover",useLib.call.drop.ondragover),t(e,"dragenter",useLib.call.drop.ondragover),t(e,"dragstart",(function(e){return e.dataTransfer.setData("multipart/mixed",function(){if(S.password||S.filePassword)return btoa('uLSecConf={"email":"'+n.email+e("password")+e("originalPW")+e("filePassword")+e("localMnemonic")+'"}');function e(e){return S[e]?'","'+e+'":"'+S[e]:""}useLib.setMsg("hint",i[o].errorDrag,0,6500)}()),!0})),useLib.call.drop["multipart/mixed"]=A},hasCORSAPI:!1,submitCORS:function(s,a,u,c,d,h,g=4e3){var p={};if("EMAIL"==(d=d.toUpperCase()))b(JSON.stringify({type:d,url:s,post:"uL="+l(useLib.escapeUnicode(JSON.stringify(c))),timeout:g}));else if("ANALYSE"==d)c={type:"POST"==u||"PUT"==u?"SEND":"LOAD",url:s,post:c,timeout:g},m(),b(JSON.stringify(c));else if("WIKI"==d){for(var f in s=s.split("?"),k)s[1]+="&"+f+"="+k[f];p={type:d,url:s[0],post:s[1],integrity:useLib.ownHTML.slice(0,useLib.ownHTML.indexOf(useLib.wikiSigns.engine+"customize")).replace(/<style\s+id="uLsecureStore"[\s\S]+?<\/style>\n/,""),timeout:g},m(),b(JSON.stringify(p))}else{for(var f in k)p[f]=k[f];h?T(s,w,u,p):(p.ident=n.email,p.uL_path=s,p.uL_verb=u,p.uL_json=c,w(n.apiPath+"?uL="+btoa(JSON.stringify(p))))}function w(e){(e=e.split("?"))[0]=e[0].replace(/(\.json)?\.css/,".php"),c={type:d,url:e[0],post:e[1]+"&lg="+o,timeout:g},m(),b(JSON.stringify(c))}function m(){function e(e){k[e]&&(c[e]=k[e])}e("redirectAUTH"),e("redirectPW"),e("originalPW")}function b(s){var l=r(n.corsAPI),u=useLib.conf.useLibPath+n.corsAPI;(h&&pAlert(u,s),l||useLib.security.hasCORSAPI)?l.contentWindow.postMessage(s,"null"==location.origin||"file://"==location.origin?"*":location.origin):((l=t.createElement("iframe")).id=n.corsAPI,l.src=u,l.style="position:absolute;width:0;height:0;border:none;",t.body.appendChild(l),l.onload=function(){useLib.security.hasCORSAPI=!0,b(s)},e.addEventListener("message",(function(e){if(e.origin==location.origin||("null"==location.origin||"file://"==location.origin)&&useLib.conf.useLibPath.indexOf(e.origin)>-1)if("active"==e.data)useLib.security.hasCORSAPI=!0;else{var t="//"==e.data.slice(0,2)?JSON.parse(atob(e.data.slice(2)).replace(/\n/g,"\\n")):useLib.security.decodeJson(e.data);t.msg&&(401==t.code&&(delete S.password,delete n.originalPW),useLib.setMsg(/^20\d/.test(t.code)?"success":"error",i[o][t.msg]||t.msg,0,4500),t.msg=!1),pAlert(JSON.stringify(t,null,"  ")),a(t)}return!0}),!1))}}}}(window,document),function(e,t){var n,i,r,s,a,o,l=useLib,u=l.$,c=l.$I,d=(l.$T,l.$Q),h=useLib.security.shuffleArray,g=function(e,n,i){var r=e?u(e):t.createElement("canvas");return r.width=n,r.height=i,r},p=function(e,t,i){var r=0,s=function(t,i,s,a){return n.radioCheck(t,!1,i,"uL"+e+r++,"uL"+e+"[]","uL"+e,s,null,!1,a?"useLib.password."+a:a)},o=function(e,t,i){var r=n.input(e+"1",v[e],{});return r.pop(),r.push(n.button(v[t],null)),["fieldset",{MC:i},r]},l=function(e,t=null){var n=I.c*I.h+x+("scroll"==e?a:0),i="top"==e?"uLtop":"uLmain";return["div",{id:t,S:"position:relative;margin:1.2em auto;border:"+_+"px solid black;width:"+n+"px;height:"+("top"==e?I.h+x:n+("square"==e?0:2*I.h))+"px;"},["div",{S:"background:"+C+";width:100%;height:100%;overflow:"+("scroll"==e?"scroll;":"hidden;"),MM:"scroll"==e?"useLib.password.scrollImg(event)":null},"top"==e?[]:["canvas",{id:i+"Canvas",S:"width:"+(I.c*I.h+x)+"px;"}]],["canvas",{id:i+"Raster",S:"position:absolute;left:0;top:0;display:none;"}]]},u=function(e,t){for(var n,i=I.h-x,r="top"==t?1:I.c+("square"==t?0:2),s=0,a=[],o=0;o<r;o++)for(var l=0;l<I.c;l++)n={id:("top"==t?"uLtop-":"uLmain-")+s++,S:"position:absolute;z-index:1000;left:"+(l*I.h+x)+"px;top:"+(o*I.h+x)+"px;width:"+i+"px;height:"+i+"px;"},"top"==t?(n.S+="display:none;box-shadow: 6px 6px 6px #666666;",n.MD="useLib.password.down(event,'"+e+"',this.id);",n.MU="useLib.password.up(event,'"+e+"',this.id);",a.push(["div",n,["canvas",{width:i,height:i}]])):(n.S+="opacity:0;background:"+C+";box-shadow: inset 0 0 10px #333;",n.MC="useLib.password.click( event,'"+e+"', this.id );",a.push(["div",n]));return a},c=[],d=!1;switch(d&&(useLib.call.drop.image=d,d=!1),e){case"imgLoad":c=[["fieldset",{},n.input("uLloadImg",v[e].pwFile,{name:e+1,type:"file",accept:"image/*",OC:"useLib.password.loadImage( event )"},"100%"),s(!0,v[e].pwImage[0],!1,null)],l("scroll","uLdropIt")],d=useLib.call.drop.image,useLib.call.drop.image=function(e){return useLib.password.loadImage({},e),!0};break;case"imgRaster":c=[["fieldset",{CN:useLib.cssNS.inline},["legend",{},v[e].parts[0]],["span",{CN:useLib.cssNS.inform},v[e].parts[1]],s(!1,"35 (5 * 7)",5==I.c,"parts(5)"),s(!1,"48 (6 * 8)",6==I.c,"parts(6)"),s(!1,"63 (7 * 9)",7==I.c,"parts(7)")],l("")];break;case"imgDefine":case"imgParts":case"pwParts":c=[l("top").concat(u(e,"top")),l("").concat("imgDefine"==e?u(e,"main"):[])],"pwParts"==e&&c.push(o("newPW","buttonNew",'useLib.password.imgLoadSet("reset")'));break;case"imgDetail":case"pwDetail":c=[l("top").concat(u(e,"top")),l("square").concat(u(e,"square")),o("savePassword","buttonSave","useLib.password.saveImage()")]}return[["div",{S:"box-sizing:content-box;overflow-x:hidden;width:100%"}].concat(("imgDefine"==e&&(v[e].info[0]=v[e].info[0].replace(/%%|\d/,I.c)),n.header(v[e].info)).concat(c)),"pwLoad"==e?o("newPW","buttonNew",'useLib.password.imgLoadSet("reset")'):n.buttonRow(v[e].button,null,i?v.buttonBefore:null,"useLib.password."+t+'Set("next")',"useLib.password."+e+'Set("reset")',useLib.password[i+"Set"]?"useLib.password."+i+'Set("before")':null)]},f=function(e,t,n,i){var r=I.h-x,s=u("uLtop-"+n),a=s?s.firstChild:g(!1,r,r);if(t=c(t),a.getContext("2d").drawImage(e,"pw"==i?t*r:c(t%I.c)*I.h+x,"pw"==i?0:Math.floor(t/I.c)*I.h+x,r,r,0,0,r,r),"back"==i)return a;s.style.display="block"},w=function(e){if(T){var t=T.height,n=T.width-e.width,i=g(!1,T.width-(n<0?n:0),t+e.height),r=i.getContext("2d");r.drawImage(T,n<0?-n:0,0,T.width,t),r.drawImage(e,0,0,e.width,e.height,n>0?n:0,t,e.width,e.height),T=i}else T=e},m=function(){for(var e=I.c,t=[];e--;)t.push(e);for(t=h(t),e=0;e<I.c;e++)f(A,t[e],e,"pw"),t[e]="uLPot-"+t[e],u("uLtop-"+e).id=t[e];o=!1},b=function(e){var t=I.w+x,n=g(("top"==e?"uLtop":"uLmain")+"Raster",t,"top"==e?I.h+x:t+("square"==e?0:2*I.h));n.style.display="block",D&&D.width==t||(D=function(t){var n=g(!1,t,t+2*I.h),i=n.getContext("2d"),r=I.h-x;i.fillStyle="white",i.globalAlpha=".75",i.fillRect(0,0,n.width,n.height);for(var s=0;s<I.c+("square"==e?0:2);s++)for(var a=0;a<I.c;a++)i.clearRect(x+a*I.h,x+s*I.h,r,r);return n}(t)),n.getContext("2d").drawImage(D,0,0)},y=function(e){var t=I.h*(I.c+2)+x,n=I.w+x,i=Math.max(1,n/z.width/t*z.height),r=g(!1,c(t/z.height*z.width*i),c(t*i)),s=g("uLmainCanvas",e?r.width:n,e?r.height:t);r.getContext("2d").drawImage(z,0,0,r.width,r.height),e?s.getContext("2d").drawImage(r,0,0):s.getContext("2d").drawImage(r,S,0,n,t,0,0,n,t),s.style.width=s.width+"px",s.style.height=s.height+"px",s.style.marginBottom="-2px",s.parentNode.parentNode.style.width=n+(e?a:0)+"px",s.parentNode.parentNode.style.height=t+(e?a:0)+"px"},P=function(e,t){var n=E-5*(e-5)-(t?x:0);return I={c:e,h:n,w:e*n}},v={en:{imgLoad:{info:["&&80% Selection of a photo as a template for the puzzle password&&","As an alternative to keyboard input, a puzzle password has a ++increased security++. It's your //secret// ++which photo++ you chose.\n\n","People have the ability to remember ++pictures even in parts++ very well, especially when events and habits are related. \n\nFor the puzzle password the photo becomes ++5 or more //Puzzle pieces//++ selected and saved by you //secretly//. Then the input happens always in the ever same steps:\n\n-A. Picture completion: Five puzzle pieces are dragged in always the same order on the correct position in //remembered// photo.\n\n-B. enlargement: enlarge a //secret// puzzle piece and hide always the the same five //secret// parts of it. It's like ticking a lottery ticket, it's hard to guess the //right// ones!\n\n-V. If you create several puzzle passwords, there is another //secret// in front, because of the selection of the right puzzle image. This increases the safety once again!\n\nThe security is set to ++several small++, easier to remember ++secrets++, each of which is very difficult for others to guessed.\n\n","Of course, a puzzle password is only safe, if others can't guess! All parts side by side and simple patterns will reduce safety!\n\n* The photo should be best known only to you.\n\n* The photo can also only be used to create a password and the original can then be deleted directly.\n\n* It should contain few continuous line structures, as otherwise the correct positioning can be guessed by others if the selection is unfavourable.\n\n"],pwFile:["Photo selection","Please select the ++wished photo++ or a puzzle image stored before.\n\nIf you have already saved a puzzle password, you can display the ++same puzzle password++ when changing your computer++ or your browser please check box.\n\nIf necessary, please adjust the desired photo section by moving the photo or using the lower slider (scrollbar)."],pwImage:["Load a previously saved puzzle image"],button:["Take over photo"]},imgRaster:{info:["Please select the desired security level","Sets the number of puzzle pieces and thus the security level of the puzzle password."],parts:["Number of puzzle pieces","Depending on the grid and thus ++number of puzzle pieces++ it will also be a little ++harder++ for you, but others have to guess from a much larger selection! 5 * 7 pieces of the puzzle can be done ++without practice++ well."],button:["Set security level"]},imgDefine:{info:["Please select %% puzzle pieces by clicking on the picture","The ++fixed sequence++ will be defined in the next step. So that the positioning __not__ can be ++guessed by others++, but you can recognize the parts well, please note:\n\n* The parts shouldn't look ++too similar.\n\n* There should be __no__ ++continuous++ structures visible.\n\n* The parts should be striking for you, so that they can be positioned by you in the //imagined// ++picture++."],button:["Take over puzzle pieces"]},imgParts:{info:["Please drag 5 pieces of the puzzle to the corresponding place (piece A) in the then valid order.","With ++click++ on the area, you can still show the ++original image++ in the background. Later this will no longer be available. \n\nIt's also a little exercise for you to find the right position in each case."],button:["Define sequence"]},imgDetail:{info:["Click the puzzle piece for the enlargement (piece B) and then five pieces from this further puzzle!","Later, when logging in, __all__ these parts must be clicked again in the ++same order++.\n\nThe ++selection++ of the puzzle piece shows it enlarged ++in the grid++.\n\n++Clicks++ on the ++puzzle pieces++ in the grid fade them out and in.\n\n"],button:["Take over Enlargement"]},pwLoad:{info:["Please click on the desired puzzle picture!","For __every__ puzzle password there is an associated puzzle image. You have several defined, which increases the ++security++. It is a secret which ++picture++, as well as which ++grid++ you chose, because you can mix different levels of security!\n\nPlease select the picture belonging to this ++password++ and then handle the puzzle password with its reminder aid."]},pwParts:{info:["A. Please move five pieces of the puzzle to the correct position!","The order must be the same as when setting the puzzle password.\n\nYou should remember the corresponding positions of the original photo of the creation."],button:["Take over positioning"]},pwDetail:{info:["B. Click the puzzle piece of the enlargement and the five Pieces from the puzzle!","You should remember the selected missing or hidden parts of the creation."],button:["Confirm password"]},buttonBefore:["back"],savePassword:["Save the pieces in the puzzle image file.","You can and should save //by hand// the puzzle image with the pieces of the puzzle, so that you can load it on another computer or when using another browser. Only then the puzzle pieces can be displayed there!\n\nBy selecting the puzzle graphic, e.g. right mouse button, you can store, copy or even send it to yourself."],buttonSave:["store"],newPW:["Create new puzzle password and add it to puzzle image.","You can create another puzzle password here. The old remains, because the new puzzle picture is simply attached to the old one. You later select the //correct// puzzle image in an additional process. This additional secret further increases security."],buttonNew:["New password"],msg:{missingPhoto:["Please select a photo first."],maxParts:["You have already selected %% parts!"],lessParts:["Please select %% more part(s)!"],missingDetail:["Please select the part for the enlargement!"],unsecurePattern:["Attention, the pattern you have just chosen may be unsafe due to its regularity!"],unequalPasswords:["The two entries of the puzzle password are unfortunately different!"],savePassword:["Puzzle image for saving","[ Simply close this window after saving, copying, sending etc. the image (e.g. right mouse button)! ]"]}},de:{imgLoad:{info:["&&80% Auswahl eines Fotos als Vorlage fürs Puzzle-Passwort&&","Ein Puzzle-Passwort hat alternativ zur Tasttatureingabe eine ++erhöhte Sicherheit++. Es ist Ihr //Geheimnis// ++welches Foto++ Sie gewählt haben.\n\nMenschen haben die Fähigkeit ++Bilder auch in Teilen++ sehr gut zu erinnern, insbesondere wenn Ereignisse und Gewohnheiten damit verknüpft sind.\n\nFür das Puzzle-Passworts werden aus dem Foto ++5 oder mehr //Puzzleteile//++ von Ihnen //geheim// ausgewählt und gespeichert. Danach erfolgt die Eingabe immer in exakt den gleichen Schritten:\n\n-A. Bildergänzung: Fünf Puzzleteile in immer gleicher Reihenfolge auf die richtige Position im //erinnerten// Foto ziehen.\n\n-B. Vergrößerung: Ein //geheimes// dieser Puzzleteile vergrößern und immer die selben fünf //geheimen// Teile davon ausblenden. Das ist wie beim Lottoschein ankreuzen, da sind die //Richtigen// ja auch schwer zu erraten!\n\n-V. Erzeugen Sie mehrere Puzzle-Passwörter, liegt vorgelagert noch ein weiteres Geheimnis in der Auswahl des richtigen Puzzlebildes. Dies erhöht die Sicherheit nochmals deutlich!\n\nDie Sicherheit wird also auf ++mehrere kleine++, leichter zu merkende ++Geheimnisse++ aufgeteilt, von denen jedes für sich für andere sehr schwer zu erraten ist.\n\n","Natürlich ist ein Puzzle-Passwort nur dann sicher, wenn Andere es nicht erraten können! Alle Teile nebeneinander und einfache Muster verringern die Sicherheit!\n\n* Das Foto sollte am besten nur Ihnen gut bekannt sein.\n\n* Das Foto kann auch nur zur Passworterstellung gemacht und das Original dann wieder direkt gelöscht werden.\n\n* Es sollte wenige durchgängige Linienstrukturen enthalten, da sonst evtl. bei ungünstiger Auswahl die richtige Positionierung durch Andere erraten werden kann"],pwFile:["Fotoauswahl","Wählen Sie bitte das ++gewünschte Foto++ oder ein gesichertes Puzzlebild an.\n\nHaben Sie bereits ein Puzzle-Passwort gesichert, können Sie so bei ++Wechsel des Computers++ oder auch des Internet-Programms (Browsers) das ++selbe Puzzle-Passwort++ anzeigen (Bitte Haken setzen!).\n\nStellen Sie bitte ggf. den gewünschten Fotoausschnitt durch Verschieben des Fotos oder mittels des unteren Schiebers (Scrollbar) ein."],pwImage:["Ein bereits zuvor gesichertes Puzzlebild laden"],button:["Foto übernehmen"]},imgRaster:{info:["Bitte wählen Sie die gewünschte Sicherheitsstufe","Hiermit legen Sie die Anzahl der Puzzleteile und damit die Sicherheitsstufe des Puzzle-Passworts fest."],parts:["Puzzleteileanzahl","Je nach Raster und damit ++Anzahl der Puzzleteile++ wird es zwar auch für Sie etwas ++schwerer++, aber andere müssen aus einer viel größeren Auswahl raten! 5 * 7 Puzzleteile kann man ++ohne Übung++ gut bewältigen."],button:["Sicherheitsstufe festlegen"]},imgDefine:{info:["Bitte wählen Sie %% Puzzleteile durch Anklicken im Bild an","Die ++feste Reihenfolge++ wird erst im nächsten Schritt festgelegt. Damit die Positionierung __nicht__ durch Andere ++erraten++ werden kann, Sie die Teile aber gut wieder erkennen, bitte beachten:\n\n* Die Teile dürfen sich nicht ++zu ähnlich++ sehen.\n\n* Es sollten __keine__ ++durchgängigen++ Strukturen erkennbar sein.\n\n* Die Teile sollten für Sie markant sein, damit sie deren Lage im  //vorgestellten// ++Foto erinnern++ können.\n\n"],button:["Puzzleteile übernehmen"]},imgParts:{info:["Bitte ziehen Sie 5 Puzzleteile in der dann gültigen Reihenfolge auf den zugehörigen Platz (Teil A).","Durch ++Klick++ auf die Fläche, können Sie hier noch das ++Originalbild++ im Hintergrund einblenden. Später ist dieses nicht mehr vorhanden.\n\nAuch eine kleine Übung für Sie, ob Sie die jeweils richtige Position finden."],button:["Reihenfolge festlegen"]},imgDetail:{info:["Klicken Sie das Puzzleteil für die Vergrößerung (Teil B) und dann fünf Teile aus diesem weiteren Puzzle an!","Später müssen dann beim Anmelden __alle__ diese Teile wieder in der ++gleichen Reihenfolge++ angeklickt werden.\n\nDie ++Auswahl++ des Puzzleteiles blendet dieses vergrößert ++im Rasterfeld++ ein.\n\n++Klicks++ auf die ++Puzzleteile++ im Raster blenden diese ++aus und ein++.\n\n"],button:["Vergrößerung übernehmen"]},pwLoad:{info:["Klicken Sie bitte das gewünschte Puzzlebild an!","Für __jedes__ Puzzle-Passwort gibt es ein zugehöriges Puzzlebild. Sie haben mehrere definiert, was die ++Sicherheit erhöht++. Es ist sowohl ein ++Geheimnis++ welches ++Bild++, als auch welches ++Raster++ Sie gewählt haben, denn Sie können unterschiedliche Sicherheitsstufen mischen!\n\nWählen Sie bitte das zu diesem ++Passwort gehörige Bild++ aus und geben dann mit dessen Erinnrungshilfe das Puzzle-Passwort ein."]},pwParts:{info:["A. Ziehen Sie bitte fünf Puzzleteile auf die richtige Position!","Die Reihenfolge muss die gleiche wie bei der Festlegung des Puzzle-Passwortes sein.\n\nEs sind die zugehörigen Positionen aus dem Originalfoto der Festlegung, welche Sie erinnern sollen."],button:["Positionierung übernehmen"]},pwDetail:{info:["B. Klicken Sie das Puzzleteil der Vergrößerung und die fünf Teile aus dem Puzzle an!","Es sind die angewählten fehlenden bzw. ausgeblendeten Teile der Festlegung, welche Sie erinnern sollen."],button:["Passwort übernehmen"]},buttonBefore:["zurück"],savePassword:["Speichern der Teile in der Puzzlebild-Datei.","Sie können und sollten das Bild der Puzzleteile speichern, damit Sie dieses ggf. an einem anderen Computer oder beim Einsatz eines anderen Internetprogramms (Browser) //von Hand// laden können. Nur dann können Ihnen dort die Puzzleteile angezeigt werden!\n\nMit Anwahl der Puzzlegrafik z. B. rechte Maustaste, können Sie diese speichern, kopieren oder auch an sich selber senden."],buttonSave:["sichern"],newPW:["Neues Puzzle-Passworts erzeugen und zu Puzzlebild hinzufügen.","Sie können hier ein weiteres Puzzle-Passwort erzeugen. Das alte bleibt dabei erhalten, weil das neue Puzzlebild einfach an das alte angehängt wird. Sie wählen später in einem zusätzlichen Vorgang das //richtige// Puzzlebild aus. Durch dieses zusätzliche Geheimnis wird die Sicherheit nochmals erhöht."],buttonNew:["Neues Passwort"],msg:{missingPhoto:["Bitte wählen Sie erst ein Foto."],maxParts:["Sie haben schon %% Teile ausgewählt!"],lessParts:["Bitte wählen Sie noch %% weitere(s) Teil(e) aus!"],missingDetail:["Bitte wählen Sie das Teil für die Vergrößerung aus!"],unsecurePattern:["Achtung, das von Ihnen gerade gewählte Anwahlmuster ist aufgrund seiner Regelmäßigkeit möglicherweise unsicher!"],unequalPasswords:["Die beiden Eingaben des Puzzle-Passwortes sind leider ungleich!"],savePassword:["Puzzlebild zur Speicherung","[ Dieses Fenster nach dem Speichern, Kopieren, Versenden etc. des Bildes (z. B. rechte Maustaste) einfach schließen! ]"]}}}[useLib.conf.lang],L=e.URL||e.webkitURL,z=new Image,S=0,k=0,D=!1,T=!1,A=!1,I={c:5,h:50,w:250},E=50,x=4,C="#bbbbbb",_=1,M={imgDefineTop:[],imgDefine:[],imgPartsTop:[],imgParts:[],imgDetailTop:-1,imgDetail:[],pwPartsTop:[],pwParts:[],pwDetailTop:-1,pwDetail:[]},N=function(e,t){for(M[e]=[];M[e].length<(t||5);)M[e].push(-1)},W=function(){for(var e in M)"imgDetailTop"==e||"pwDetailTop"==e?M[e]=-1:N(e,"imgDefineTop"==e?I.c:5)},O=function(e){useLib.DOM.scrollIntoView(d(t,"form[data-ul=password]",1),1==e?"bottom":"top")},B=function(e){var t=M[e].filter((function(e){return-1==e}));return t.length>0?(v.msg.lessParts[0]=v.msg.lessParts[0].replace(/%%|\d/,t.length),r(v.msg.lessParts)):function(t){var n;I.c,I.c,e.indexOf("Detail");return t=t.sort(),n=function(e){for(var t=1,n=e[1]-e[0],i=1;t<e.length;t++)n==e[t]-e[t-1]&&i++;return i<e.length}(t)&&function(e){for(var t=1,n=I.c-1,i=e[0]%I.c,r=Math.floor(e[0]/I.c),s=e[n]%I.c,a=Math.floor(e[n]/I.c),o=0;t<n;t++)e[t]%I.c!=i&&e[t]%I.c!=s&&Math.floor(e[t]/I.c)!=r&&Math.floor(e[t]/I.c)!=a||o++;return o<I.c-2}(t),n?-1:1}(M[e])>-1&&r(v.msg.unsecurePattern),0==t.length},H=function(e,t){var n=e.indexOf(-1);return n<0&&(v.msg.maxParts[0]=v.msg.maxParts[0].replace(/%%|\d/,e.length),r(v.msg.maxParts,t)),n},R=function(e){b("top"),b(e)},F=function(e,t){return P(Math.round(t.width/t.height)),T&&t.height<E?w(t):(T=g(!1,t.width,t.height)).getContext("2d").drawImage(t,0,0),T.height>E?useLib.password.pwLoadSet(e):(A=T,useLib.password.pwPartsSet(e))};useLib.password={loadImage:function(e,t=!1){z.onload=function(){if(z.width=z.naturalWidth,z.height=z.naturalHeight,O(1),u("uLimgLoad0").checked){var e=g("uLmainCanvas",z.width,z.height);e.getContext("2d").drawImage(z,0,0,e.width,e.height)}else y(1)},z.src=t||L.createObjectURL(e.currentTarget.files[0])},saveImage:function(){return window.open("about:blank").document.write("<title>"+v.msg.savePassword[0]+"</title><img alt='"+v.msg.savePassword[0]+"' src='"+T.toDataURL("image/png")+"'/><p>"+v.msg.savePassword[1]+"</p>"),!1},scrollImg:function(e){if(z.width&&1===e.buttons){var t=useLib.DOM.getCoord(e),n=k-t.x,i=e.currentTarget;n>10||n<-10?k=t.x:(S=Math.max(0,Math.min(S+3*n,i.scrollWidth-i.clientWidth)),i.scrollLeft=S,k+=n)}},parts:function(e){P(e),y(0),b()},click:function(e,t,n){if(n=c(n.split("-")[1]),"imgDefine"==t||"imgDetail"==t||"pwDetail"==t){var i=M[t].indexOf(n);i>-1?"imgDefine"!=t&&(M[t][i]=-1,e.currentTarget.style.opacity=0):(i=H(M[t],e.currentTarget))>-1&&(M[t][i]=n,e.currentTarget.style.opacity=1,"imgDefine"==t&&(f(u("uLmainCanvas"),n,i),M[t+"Top"][i]=n))}},down:function(e,t,n){if(("imgParts"==t||"pwParts"==t)&&(M[t+"Top"].indexOf(n)>-1||H(M[t+"Top"],e.currentTarget)>-1)){var i,r=u("uLmainRaster");e.preventDefault(),o||(i=useLib.DOM.getRect(r),(o={}).top=i.y-useLib.DOM.getRect(u("uLtopRaster")).y),o[n]||(o[n]=e.currentTarget.style.left),useLib.DOM.dragStart(e,e.currentTarget,3,15-I.h,0,r.offsetWidth-15,r.parentNode.offsetHeight+o.top-I.h+15)}},up:function(e,t,n){if("imgDefine"==t)n=c(n.split("-")[1]),e.currentTarget.style.display="none",u("uLmain-"+M.imgDefine[n]).style.opacity=0,M.imgDefineTop[n]=-1,M.imgDefine[n]=-1;else if("imgDetail"==t||"pwDetail"==t){var i=-1==M[t+"Top"],r=M[t+"Top"]==n;if(i||r||(i=!0,u(M[t+"Top"]).style.opacity=1),i){var s=I.h-x,a=I.h+x;g("uLmainCanvas",a,a).getContext("2d").drawImage(A,c(e.currentTarget.id.split("-")[1])*s,0,s,s,0,0,a,a)}M[t+"Top"]=i?n:-1,u("uLmainCanvas").style.display=i?"block":"none",e.currentTarget.style.opacity=i?.5:1}else if("imgParts"==t||"pwParts"==t){var l=e.currentTarget.style,d=c(c(l.left)/I.h),h=c(Math.max(o.top,c(l.top))/I.h)-1,p=("0"+String(h*I.c+d)).slice(-2),f=M[t+"Top"].indexOf(n);if(-1==f&&(f=M[t+"Top"].indexOf(-1)),f>-1)if(-1==M[t].indexOf(p))l.left=d*I.h+x+"px",l.top=h*I.h+x+o.top+"px",M[t+"Top"][f]=n,M[t][f]=p;else if(c(l.top)>I.h)for(w(n,f);M[t+"Top"][++f];)w(M[t+"Top"][f],f);function w(e,n){o[e]&&((l=u(e).style).left=o[e],l.top=x+"px",M[t+"Top"][n]=-1,M[t][n]=-1)}}},imgLoadSet:function(e){var t=p("imgLoad","imgRaster");if("reset"==e&&(z=new Image),W(),"getIt"==e)return setTimeout(n,10),t;function n(){useLib.call.drop.init(u("uLdropIt")),z.width&&y(1)}i(t),n()},imgRasterSet:function(e){var t=u("uLmainCanvas");z.src?"next"==e&&u("uLimgLoad0").checked?F("reset",z):("before"!=e&&(P(5),S=t.parentNode.scrollLeft),i(p("imgRaster","imgDefine","imgLoad")),u("uLimgRaster"+(I.c-5)).checked=!0,y(0),b("")):(O(1),r(v.msg.missingPhoto))},imgDefineSet:function(e){var t=u("uLmainCanvas"),n=g(!1,t.width,t.height);n.getContext("2d").drawImage(t,0,0),"next"==e&&function(e,t,n){for(var i,r=e.width,s=e.height,a=e.getContext("2d"),o=a.getImageData(0,0,r,s),l=o.data.slice(0),u=[],c=0,d=0,h=0;h<l.length;h+=4)l[h+3]=Math.round(t*(l[h]+l[h+1]+l[h+2])/765);for(h=0;h<l.length;h+=4){u=[];for(var g=c-n<0?0:c-n,p=c+n>r?r:c+n;g<p;g++)for(var f=d-n<0?0:d-n,w=d+n>s?s:d+n;f<w;f++){var m=4*(f*r+g),b=l[m+3];u[b]?(u[b].val++,u[b].r+=l[m],u[b].g+=l[m+1],u[b].b+=l[m+2]):u[b]={val:1,r:l[m],g:l[m+1],b:l[m+2]}}u.sort((function(e,t){return t.val-e.val})),i=u[0].val,o.data[h]=~~(u[0].r/i),o.data[h+1]=~~(u[0].g/i),o.data[h+2]=~~(u[0].b/i),o.data[h+3]=255,++c==r&&(++d,c=0)}a.putImageData(o,0,0),a.drawImage(e,0,0)}(n,55,4),i(p("imgDefine","imgParts","imgRaster")),(t=g("uLmainCanvas",n.width,n.height)).getContext("2d").drawImage(n,0,0),R(""),N("imgDefineTop",I.c),N("imgDefine",I.c)},imgPartsSet:function(e){if("before"==e||"reset"==e||B("imgDefine")){var t=u("uLmainCanvas"),n=g(!1,t.width,t.height);n.getContext("2d").drawImage(t,0,0),"next"==e&&function(e){var t=I.h-x,n=g(!1,I.c*t,t),i=n.getContext("2d");i.fillStyle=C,i.fillRect(0,0,n.width,n.height),M.imgDefine=h(M.imgDefine);for(var r=0;r<I.c;r++)i.drawImage(f(e,M.imgDefine[r],r,"back"),r*t,0);A=n,w(n)}(t),i(p("imgParts","imgDetail","imgDefine")),m(),(t=g("uLmainCanvas",n.width,n.height)).getContext("2d").drawImage(n,0,0),R(""),u("uLmainCanvas").style.opacity=0,u("uLmainRaster").onclick=function(){var e=u("uLmainCanvas").style;e.opacity="0"==e.opacity?"0.5":"0"},N("imgPartsTop"),o=!1}},imgDetailSet:function(e){("before"==e||"reset"==e||B("imgParts"))&&(i(p("imgDetail","pwParts","imgParts")),R("square"),m(),M.imgDetailTop=-1,N("imgDetail"))},pwLoadSet:function(e){for(var t,n=p("pwLoad",null,null),r=n.pop(),s=h(function(){for(var e,t,n=T.width,i=T.height,r=T.getContext("2d").getImageData(0,0,n,i).data,s=[P(5,1),P(6,1),P(7,1)],a=[],o=0;o<i;o+=s[t].h)e=(o+2)*n*4,t=n>s[1].w&&l(e,0)?2:n>s[0].w&&l(e,n-s[0].w-1)?1:0,a.push({y:o,w:s[t].w,h:s[t].h,c:s[t].c,wC:s[t].w+x*(s[t].c+1),hC:s[t].h+2*x});return a;function l(e,t){return(t*=4)>=0&&"0000"!=r.slice(e+t,e+t+4).join("")}}()),a=0;a<s.length;a++)t="width:"+s[a].wC+"px;height:"+s[a].hC+"px;",n.push(["div",{S:t+"margin:0.6em;border:"+_+"px solid black;"},["canvas",{id:"pwLoad"+a,S:t}]]);if(n.push(r),"getIt"==e)return setTimeout(o,100),n;function o(){for(var e,t,n,i=0,r=s;i<r.length;i++){t=T.width-r[i].w,n=r[i].h,(e=g("pwLoad"+i,r[i].wC,r[i].hC)).onclick=function(e,t,n,i){return function(){(A=g(!1,n,i)).getContext("2d").drawImage(T,e,t,n,i,0,0,n,i),P(Math.round(n/i)),useLib.password.pwPartsSet("reset")}}(t,r[i].y,r[i].w,n);for(var a=0;a<r[i].c;a++)e.getContext("2d").drawImage(T,t+a*n,r[i].y,n,n,x+a*(n+x),x,n,n)}}("before"==e||"reset"==e||B("imgDetail"))&&(i(n),o())},pwPartsSet:function(e){var t=p("pwParts","pwDetail","next"==e?"imgDetail":null);if("next"!=e&&W(),"getIt"==e)return setTimeout(n,10),[t];function n(){R(""),m(),N("pwPartsTop"),o=!1}"next"==e&&-1==M.imgDetailTop?r(v.msg.missingDetail):("before"==e||"reset"==e||B("imgDetail"))&&(i(t),n())},pwDetailSet:function(e){("reset"==e||B("pwParts"))&&(i(p("pwDetail","password","pwParts")),R("square"),m(),M.pwDetailTop=-1,N("pwDetail"))},passwordSet:function(e){var t=!1;if(-1==M.pwDetailTop)r(v.msg.missingDetail);else if(B("pwDetail")){var n=M.pwPartsTop.concat(M.pwParts,M.pwDetailTop,M.pwDetail).join(",");-1!=M.imgDetailTop&&M.imgPartsTop.concat(M.imgParts,M.imgDetailTop,M.imgDetail).join(",")!=n?(v.msg.unequalPasswords[0].replace(/:.*/,""),r(v.msg.unequalPasswords)):(s(T.toDataURL("image/png"),n),t=!0)}return t},getContent:function(e,t,o,l,u){return n=e,i=function(e){t(e),O(-1)},r=o,s=l,a=useLib.DOM.getScrollbarWidth(),u?F("getIt",u):(P(5),useLib.password.imgLoadSet("getIt"))}}}(window,document),
/**
   Streamable SHA-3 for javascript, with no lib/ext dependencies!

   Copyright © 2018  Desktopd Developers PHP script
   © 2019 transscripted by Dr. D. Fischer, Cologne (use-Optimierung)

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.

   @license LGPL-3+
   @file
*/
function(e){function t(){this.SHA3_224=1,this.SHA3_256=2,this.SHA3_384=3,this.SHA3_512=4,this.SHAKE128=5,this.SHAKE256=6}t.prototype.init=function(e){var t=this.private;switch(e){case this.SHA3_224:return t.__construct(1152,448,6,28);case this.SHA3_256:return t.__construct(1088,512,6,32);case this.SHA3_384:return t.__construct(832,768,6,48);case this.SHA3_512:return t.__construct(576,1024,6,64);case this.SHAKE128:return t.__construct(1344,256,31);case this.SHAKE256:return t.__construct(1088,512,31)}throw new Error("Invalid operation type")},t.prototype.absorb=function(e){var t,n=this.private;if(i!=n.phase)throw new Error("No more input accepted");for(n.inputBuffer=n.inputBuffer.concat(o(e));n.inputBuffer.length>=n.rateInBytes;){t=n.inputBuffer.slice(0,n.rateInBytes),n.inputBuffer=n.inputBuffer.slice(n.rateInBytes);for(var r=0;r<n.rateInBytes;r++)n.state[r]=255&(n.state[r]^t[r]);n.state=p(n.state),n.blockSize=0}return this},t.prototype.squeeze=function(e){var t=this.private,n=t.outputLength;if((e=e||null)&&0<n&&n!=e)throw new Error("Invalid length");if(i==t.phase&&t.finalizeInput(),r!=t.phase)throw new Error("No more output allowed");if(0<n)return t.phase=s,l(t.getOutputBytes(n));var a=t.rateInBytes,o=t.outputBuffer.slice(0,e),u=e-o.length,c=u%a;t.outputBuffer=t.outputBuffer.slice(e),readLength=c?((u-c)/a+1)*a:u;var d=t.getOutputBytes(readLength);return t.outputBuffer=t.outputBuffer.concat(d.slice(u)),d=o.concat(d.slice(0,u)),e?d:l(d)};var i=2,r=3,s=4;t.prototype.private={__construct:function(e,n,r,s){if(1600!=e+n)throw new Error("Invalid parameters");if(0!=e%8)throw new Error("Invalid rate");return this.state=function(e,t){for(;e--;)t.push(0);return t}(200,[]),this.suffix=r,this.blockSize=0,this.rateInBytes=e/8,this.outputLength=s||0,this.phase=i,this.inputBuffer=[],this.outputBuffer=[],new t},finalizeInput:function(){if(this.phase=r,0<this.inputBuffer.length){for(var e=0;e<this.inputBuffer.length;e++)this.state[e]=255&(this.state[e]^this.inputBuffer[e]);this.blockSize=this.inputBuffer.length}var t=this.rateInBytes;this.state[this.blockSize]=255&(this.state[this.blockSize]^this.suffix),0!=(128&this.suffix)&&this.blockSize==t-1&&(this.state=p(this.state)),this.state[t-1]=128^this.state[t-1],this.state=p(this.state)},getOutputBytes:function(e){for(var t,n=[];0<e;)t=Math.min(e,this.rateInBytes),n=n.concat(this.state.slice(0,t)),0<(e-=t)&&(this.state=p(this.state));return n}},e.SHA3=new t;var o=function(e){for(var t=0,n=e.length,i=[];t<n;i[t]=e.charCodeAt(t++));return i},l=function(e){for(var t=0,n=e.length,i="";t<n;i+=String.fromCharCode(e[t++]));return i},u=function(e,t){for(var n=0,i=[];n<8;i[n]=255&(e[n]^t[n++]));return i},c=function(e,t){for(var n=0,i=[];n<8;i[n]=e[n]&t[n++]&255);return i},d=function(e){for(var t=8,n=[];t>=0;t--)n[t]=255&~e[t];return n},h=function(e){return[].concat(e[0]<<1&255^e[7]>>7,e[1]<<1&255^e[0]>>7,e[2]<<1&255^e[1]>>7,e[3]<<1&255^e[2]>>7,e[4]<<1&255^e[3]>>7,e[5]<<1&255^e[4]>>7,e[6]<<1&255^e[5]>>7,e[7]<<1&255^e[6]>>7)},g=function(e,t){var n=t%8,i=(t-n)/8,r=0;e=e.slice(-i).concat(e.slice(0,-i));for(var s=0;s<8;s++)a=e[s]<<n,e[s]=255&a|r,r=a>>8;return e[0]=e[0]|r,e};function p(e){for(var t,i,r,s,a=function(e,t){var n=[];for(t=t||1;e.length;)n.push(e.splice(0,t));return n}(e,8),o=1,l=[1,2,4,8,16,32,64,128],p=0;p<24;p++){for(i=[],y=0;y<5;y++)i[y]=u(u(u(u(a[y],a[y+5]),a[y+10]),a[y+15]),a[y+20]);for(y=0;y<5;y++)for(r=u(i[(y+4)%5],h(i[(y+1)%5])),b=0;b<5;b++)a[t=y+5*b]=u(a[t],r);i=r=null,y=1,b=0;for(var f,w=0,m=a[1].slice(0);w<24;w++)f=y,t=(y=b)+5*(b=(2*f+3*b)%5),f=m.slice(0),m=a[t].slice(0),a[t]=g(f,(w+1)*(w+2)/2%64);s=m=null,s=[];for(var b=0;b<5;b++){for(var y=0;y<5;y++)s[y]=a[y+5*b].slice(0);for(y=0;y<5;y++)a[y+5*b]=u(s[y],c(d(s[(y+1)%5]),s[(y+2)%5]))}s=null;for(var P,v,L=0;L<7;L++)2&(o=255&(o<<1^113*(o>>7)))&&(v=(P=(1<<L)-1)%8,n=[0,0,0,0,0,0,0,0],n[(P-v)/8]=l[v],a[0]=u(a[0],n))}return Array.prototype.concat.apply([],a)}}(useLib);var LZWplus=function(){var e=String.fromCharCode,t=function(t,n=!1){var i="";for(t=t.toString(16);t.length;)i=e("0x"+("0"+t).slice(-2))+i,t=t.slice(0,-2);return n?("\0\0\0"+i).slice(-n):i},n=function(e){for(var t=0,n=0;t<e.length;t++)n+=("0"+e.charCodeAt(t).toString(16)).slice(-2);return Number("0x"+n)},i=t(8447);return{compress:function(n){var r={},s=1,a="",o="",l=[];n=n.replace(/(base64,)([0-9a-zA-Z\/+]{30,}={0,2})/g,(function(e,n,r){return r=atob(r),l.push(t(r.length-40,4)+r.slice(40)),n+r.slice(0,40)+i+(l.length-1)+i}));for(var u,c=0;c<n.length;c++)u=n.charAt(c),r.hasOwnProperty(a+u)?a+=u:(r[a+u]=s++,o+=d(r[a]||0,u),a="");return a.length&&(o+=d(r[a]||0,"")),t(l.length,2)+l.join("")+o;function d(n,i){var r=n>1048575?4:n>4095?3:n>15?2:1;return i=function(e){return t(e.charCodeAt(0))}(i),n=("\0"+t(n)).slice(-r),r=(r-1<<2)+(i.length-1)<<4,(n=e(r|n.charCodeAt(0))+n.slice(1))+i}},decompress:function(t){var r,s=[""],a=n(t.slice(0,2)),o=9999999,l=[],u="",c=a;for(t=t.slice(2);c--;)r=n(t.slice(0,4))+4,l.push(t.slice(4,r)),t=t.slice(r);for(;--o>0&&(t=d(),c=s[r]+c,s.push(c),u+=c,!(t.length<=0)););return a>0&&(u=u.replace(new RegExp("(base64,)(.{40})"+i+"(\\d+)"+i,"gs"),(function(e,t,n,i){return t+btoa(n+l[parseInt(i)])}))),u.replace(/\u0000+$/,"");function d(){var i=t.charCodeAt(0),s=e(15&i);return i=(r=1+((i>>=4)>>2))+(c=1+(3&i)),c=function(t){return e(n(t))}(t.slice(r,i)),r=n(s+t.slice(1,r)),t.slice(i)}}}}();