/*****
 *
 *		Automatic library for software ergonomic interaction optimization:
 *		@ usability for complex working systems: autoformating selection controls, 
 *		@ several meta controls with formated input (3-month calendar, time, IBAN,
 *		@ Adress, units, countries etc.), automatic supplement (postalcode, BIC 
 *		@ etc.), cursor steering, expert level and layout steering etc., even for
 *		@ old application systems. Adaptability via configuration file.
 *		@ © Dr. Dirk Fischer, use-Optimierung, Köln/Cologne, 2021.
 *		@ Possibly other copyrights reported at the place. 
 * 
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU Affero General Public License as
 *    published by the Free Software Foundation, either version 3 of the
 *    License, or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 *****/
navigator.language||(navigator.language=navigator.userLanguage);var useLib=function(W,D,U){if(window.useLibConf){var ULC=W.useLibConf,develop="designed and developed by",copyright="© Dr. Dirk Fischer, Cologne",homepage="https://www.use-optimierung.de",useLibVersion="1.12",conf=ULC.conf,wikiSigns=ULC.wikiSigns,wikiEnsemble=ULC.wikiEnsemble,cssNS=ULC.cssNS,htmlSupport=ULC.htmlSupport,JSONexpands=ULC.JSONexpands,langConf=ULC.langConf;conf.designRight="useLib, Cologne",Object.defineProperty(Object.prototype,"watch",{enumerable:!1,configurable:!0,writable:!1,value:function(e,t){var n=this[e],i=n,a=this.__lookupGetter__,r=!!a&&this.__lookupGetter__(e),o=!!a&&this.__lookupSetter__(e);delete this[e]&&Object.defineProperty(this,e,{get:function(){return r?r.call(this):i},set:function(a){return n=i,i=t.call(this,e,n,a),o?o.call(this,i):i},enumerable:!0,configurable:!0})}}),function(){for(var e in langConf)t(langConf[e].dynActions,0),t(langConf[e].dynActions,1);function t(e,t){e[t].split&&(e[t]=e[t].split(","))}}();var shortnChars=(base={g:"\\u00C4\\u00D6\\u00DC\\u00E4\\u00F6\\u00FC\\u00DF",f:"\\u00C0\\u00C2\\u00C6-\\u00CB\\u00CE\\u00CF\\u00D4\\u00D9\\u00DB\\u00E0\\u00E2\\u00E6-\\u00EB\\u00EE\\u00EF\\u00F4\\u00F9\\u00FB\\u0152\\u0153",s:"\\u00A1\\u00AA\\u00BF\\u00C1-\\u00C3\\u00C7-\\u00CA\\u00CC\\u00CD\\u00D1-\\u00D5\\u00DA\\u00E1-\\u00E3\\u00E7\\u00E9\\u00EA\\u00EC\\u00ED-\\u00EF\\u00F1\\u00F3-\\u00F5\\u00FA\\u00FC"},{gg:base.g,ff:base.f,ss:base.s,ww:base.g+base.f+base.s,ee:"\\u00C0-\\u017F",uu:"-A-Za-z0-9\\/\\)\\(\\+._!~:?#$&'*,;=",mm:"\\.A-Za-z0-9!#$%&'*+\\/=?^_`{|}~\\-"}),typeCheck=function(e,t){return Object.prototype.toString.call(t)=="[object "+e+"]"},str2obj=function(e,t,n){return e.split?(t='{"'+e.split(t||" ").join('":1,"')+'":1}',void 0!==n&&(n=$I(n),t=t.replace(/:1/g,(function(e){return":"+n++}))),JSON.parse(t)):e},DOM=function(){var e="ontouchstart"in W||W.DocumentTouch&&D instanceof DocumentTouch,t=function(e,t){return e=e.touches?e.touches[0]:e,(t=t||{}).x=e.pageX,t.y=e.pageY,t},n=function(e){return $I(W["page"+e+"Offset"]||t(D.documentElement)||t(D.body));function t(t){return t?t["scroll"+("Y"==e?"Top":"Left")]:0}},i=-1,a=!0,o=null;function s(e,t){return D.body&&(o||(o=D.createElement("div"),$A(o,"style","position:absolute;left:-9999px;visibility:hidden;display:block;"),D.body.appendChild(o)),o.className=t||"",o.innerHTML=e),o.offsetWidth||0}function l(e){for(var t={x:0,y:0,w:$I(e.offsetWidth),h:$I(e.offsetHeight)};null!=e;t.x+=$I(e.offsetLeft),t.y+=$I(e.offsetTop),e=e.offsetParent||null);return t.left=t.x,t.top=t.y,t.right=t.x+t.w,t.bottom=t.y+t.h,t}function c(e,t,n,i){$S(e).position=i?"fixed":"absolute",!1!==t&&($S(e).left=$I(t)+"px"),!1!==n&&($S(e).top=$I(n)+"px")}function u(e,r,o,s,l,c,u,d,f,g,p){function m(e){var n=t(e),a=i;1&a.dir&&($S(a.e)[a.wS]=max(a.wMin,min(a.wOff+a.w-a.x+n.x,a.wMax))+"px"),2&a.dir&&($S(a.e)[a.hS]=max(a.hMin,min(a.hOff+a.h-a.y+n.y,a.hMax))+"px")}i={e:r,w:$I($GS(r,s)),h:$I($GS(r,l)),dir:o||3,wS:s,hS:l,wMin:c||200,hMin:u||200,wMax:d||$I(n("X")+W.innerWidth-20)-r.offsetLeft,hMax:f||$I(n("Y")+W.innerHeight-20)-r.offsetTop,wOff:p||0,hOff:p||0},i=t(e,i),$E(D,"MU",(function(){a=!0,$E(D,"MM",m,1)})),$E(D,"MM",m)}function d(){W.scrollTo(0,0)}return{isTouch:e,textWidth:s,getRect:l,getCoord:t,coordInRect:function(e,n,i){var a=t(e),r=n.getBoundingClientRect();return i=i||0,a.x>r.left-i&&a.x<r.right+i&&a.y>r.top-i&&a.y<r.bottom+i},setPos:c,setControledPos:function(e,t){var n,i,a=!1;e.style.transform="none",e=typeCheck("String",e)?$(e):e,t&&t.getBoundingClientRect?(function(e,t){n=t.left>W.innerWidth/2?t.left-25-e.offsetWidth:t.right+25;i=t.top>W.innerHeight/2?t.top-19-e.offsetHeight:t.bottom+19}(e,t=t.target?{left:t.pageX,top:t.pageY,right:t.pageX+25,bottom:t.pageY+19}:l(t)),n=min(max(0,n),$I(W.innerWidth)-t.w),i=min(max(0,i),$I(W.innerHeight)-t.h)):(a=!0,n=max(0,$I((W.innerWidth-e.offsetWidth)/2)),i=max(0,$I(W.innerHeight/20)),$CN.contains(e,cssNS.form)&&(e=e.firstChild)),c(e,n,i,a)},sizeStart:function(e,t,n,i,r,o,s){a=!1,u(e,t||e.currentTarget.parentNode,n,"width","height",i,r)},dragStart:function(e,t,n,i,r,o,s,l,c){t=t||e.currentTarget.parentNode,$S(t).transform="none",a=!1,u(e,t,n,"left","top",i||50-t.offsetWidth,r||-10,o,s,0,c)},dragStop:a,scrollIntoView:function(e,t,n){setTimeout((function(){var t=/MSIE|Trident|(^((?!chrome|android|crios|fxios).)*safari)/i.test(navigator.userAgent);e==D.body?(n="top"==n?0:"bottom"==n?D.body.scrollHeight:$I(n),t?D.body.scrollTo(0,n):D.body.scrollTo({top:n,left:0,behavior:"smooth"})):e&&e.scrollIntoView(t?"bottom"!=n||!!n||r.top<0:{behavior:"smooth",block:1==n||"top"==n?"start":"bottom"==n?"end":-1==n?"center":"nearest"})}),$I(1e3*(t||0)))},scrollStop:function(e){$E(W,"scroll",d,!e)},getScrollbarWidth:function(){s("a"),o.style.overflow="scroll";var e=o.offsetWidth-o.clientWidth;return o.style.overflow="auto",e},redraw:function(e){var t=e.style.display;e.style.display="none",t?e.style.display=t:e.style.removeProperty("display")},insertBefore:function(e,t){return e&&t&&(t=e.parentNode.insertBefore(t,e)),t},insertAfter:function(e,t){return e&&t&&(t=e.nextSibling?e.parentNode.insertBefore(t,e.nextSibling):e.parentNode.appendChild(t)),t},removeNode:function(e){if(e&&e.parentNode){for(var t=e.cloneNode(!1),n=0,i=$Q(e,"[name]");n<i.length;n++)i[n].form&&formDef[i[n].form.name]&&delete formDef[i[n].form.name][i[n].name];e.parentNode.replaceChild(t,e),t.parentNode.removeChild(t),e=null}},replaceNode:function(e,t){return e&&e.parentNode&&t&&(t=e.parentNode.replaceChild(t,e)),t}}}(),$=function(e){return!(!typeCheck("String",e)||!e.trim().length)&&D.getElementById(e)},$S=function(e){return e&&e.style?e.style:{}},$T=function(e,t,n){return e=(e=typeCheck("String",e)?$(e):e)&&e.getElementsByTagName?e.getElementsByTagName(t):[],n&&e.length?e[0]:n?null:e},$Q=function(e,t,n){return(e=typeCheck("String",e)?$(e):e)&&e.querySelector&&t&&t.length?e["querySelector"+(n?"":"All")](t):n?null:[]},$A=function(e,t,n){return t=attrList[t]||t,e&&t&&e.getAttribute?t="innerHTML"==t?e.innerHTML=n:-1===n?e.removeAttribute(t):"string"==typeof n?e.setAttribute(t,n):"string"==typeof(e=e.getAttribute(t))&&(/value|data/.test(t)||e.length?e:!!/selected|checked|disabled/.test(t)&&t):null},$P=function(e,t){for(t=t&&t>0?t:1;t--&&e;)e=e.parentNode;return e},$I=function(e){return parseInt(e,10)||0},$D=function(){var e=function(t){if(t&&(typeCheck("Date",t)||!isNaN(t)))return new Date(t);if(!t||!t.length)return(t=new Date).setHours(0),t.setMinutes(0),t.setSeconds(0),t;if(typeCheck("String",t)){if(!((t=t.match(/\d+/g))&&t.length>2))return console.warn("useLib: wrong Date string "+t.join("-")+" (set to today)!"),e();4==t[2].length?t.reverse():2==t[0].length&&(t[0]=$I(t[0])+2e3,t[0]-=t[0]>e.y()+conf.smallYearFuture?100:0)}return typeCheck("Array",t)?new Date($I(t[0]),$I(t[1])-1,$I(t[2]),0,0,0):void 0};function t(t){return(t=e(t)).setTime(t.getTime()+864e5*(3-(t.getDay()+6)%7)),t}return e.y=function(t){return e(t).getFullYear()},e.m=function(t){return e(t).getMonth()+1},e.d=function(t){return e(t).getDate()},e.add=function(t,n,i){return(t=e(t)).setHours(0),t.setMinutes(0),t.setSeconds(1),t=t["set"+(n="y"==n?"FullYear":"m"==n?"Month":"Date")](t["get"+n]()+i)-1e3,e(t)},e.toTime=function(t,n){return t=e(t),zeroInt(t.getHours(),2)+":"+zeroInt(t.getMinutes(),2)+(n?":"+zeroInt(t.getSeconds(),2):"")},e.toISO=function(t){return typeCheck("String",t)?t=t.split(/\.|\//g).reverse().join("-"):(t=e(t),t=e.y(t)+"-"+zeroInt(e.m(t),2)+"-"+zeroInt(e.d(t),2)),t},e.timestamp=function(t){var n=lang.timestamp;return t=e(t),n.replace("YYYY",t.getFullYear()).replace("MM",zeroInt(t.getMonth()+1,2)).replace("DD",zeroInt(t.getDate(),2)).replace("HH",zeroInt(t.getHours(),2)).replace("mm",zeroInt(t.getMinutes(),2)).replace("SS",zeroInt(t.getSeconds(),2))},e.dayName=function(t){return t=e(t).getDay(),isNaN(t)?"":Object.keys(lang.dayNames)[t||7]},e.monthName=function(t){return(t=e(t))?lang.months[e.m(t)-1]:""},e.checkLeapYear=function(e){return 1===new Date($I(e),1,29).getMonth()},e.getWeekday=function(t,n){return t=e(t),e.add(t,"d",n-t.getDay())},e.checkWeek53=function(t){var n=new Date($I(t),0,1).getDay();return 4==n||3==n&&e.checkLeapYear(t)},e.getWeekDate=function(n,i){return!((n=$I(n))<1||n>53||53==n&&!e.checkWeek53(i))&&e.add(e.getWeekday(t([$I(i),1,4]),1),"d",7*(n-1))},e.getWeekNo=function(n){var i=t(e(n)),a=t([e.y(i),1,4]);return Math.floor(1.5+(i.getTime()-a.getTime())/864e5/7)},e.daysInMonth=function(t){return t=e(t),new Date(e.y(t),e.m(t),0,0,0,0).getDate()},e}(),$E=function(e,t,n,i){"touchmove"==(t=attrList[t]?attrList[t].slice(2):t)&&(D.ontouchstart=i?null:function(e){e.preventDefault()}),e&&t&&n&&e[(i?"remove":"add")+"EventListener"](t,n,!1)},$GS=function(e,t){var n=e&&getComputedStyle(e,null)?getComputedStyle(e,null).getPropertyValue(t):0,i=(n+"").slice(-2);return"px"==i||"pt"==i?Math.round(parseFloat(n))+i:n},$LS=function(){var e,t=+new Date;n.fake=!0;try{return localStorage.setItem(t,t),e=localStorage.getItem(t)==t,localStorage.removeItem(t),e?function(e,t,n){var i=n?sessionStorage:localStorage;if(null==t)return!(!(t=i.getItem(e))||!t.length)&&JSON.parse(t);if(-1===t)i.removeItem(e);else try{return i.setItem(e,JSON.stringify(t))}catch(t){return dialog.setMsg("error",msgReplace("localStorage",e),0,3500),!1}}:n}catch(e){return n}function n(e,t){var n=W.name.length?JSON.parse(decodeURIComponent(W.name)):{};if(void 0===t)return n[e]||!1;-1===t?delete n[e]:n[e]=t,W.name=encodeURIComponent(JSON.stringify(n))}}(),$CN={contains:function(e,t){return!!(e&&t&&e.classList)&&e.classList.contains(t)},add:function(e,t){return!!(e&&t&&e.classList)&&e.classList.add(t)},remove:function(e,t){return!!(e&&t&&e.classList)&&e.classList.remove(t)},toggle:function(e,t){return!!(e&&t&&e.classList)&&e.classList.toggle(t)},replace:function(e,t,n){return!!(e&&n&&e.classList)&&e.classList.replace(t,n)}},$CE=function(e){var t=e.length,n=null;if(t>=1){n=function(e,t){var n,i=(typeCheck("String",e)?D.createElement(e):e)||null;if(i&&t)for(var a in t)!1!==(n=t[a])&&null!=n&&$A(i,a,n+"");return i}(e[0],e[1]);for(var i=2;i<t;i++)typeCheck("String",e[i])?n.appendChild(D.createTextNode(e[i])):e[i]&&e[i].length&&n.appendChild($CE(e[i]))}return n},attrList={IH:"innerHTML",CN:"class",S:"style",T:"title",LD:"longdesc",MC:"onclick",M2:"ondblclick",MD:DOM.isTouch?"ontouchstart":"onmousedown",MU:DOM.isTouch?"ontouchend":"onmouseup",MM:DOM.isTouch?"ontouchmove":"onmousemove",MO:"onmouseover",MT:"onmouseout",KD:"onkeydown",KU:"onkeyup",OF:"onfocus",OB:"onblur",OC:"onchange",classname:"class"},extern={},checkDesign=function(e,t,n){var i=-1;e||e.sheet?function a(){try{e.sheet.cssRules&&t(function(t){for(var i,a=/@import\s*(url\()?\s*("|')([^\2]*?)\2\s*\)?;/gi,r="",o="",s=!1,l=!1,c=0;c<t.length;c++)o+=t[c].cssText,(i=t[c].style)&&(r+=t[c].selectorText+(i.content||"")+(i.backgroundImage||"")+u("marginLeft",1)+u("marginRight",1)+u("marginTop",1)+u("marginBottom",1)+u("paddingLeft",1)+u("paddingRight",1)+u("paddingTop",1)+u("paddingBottom",1)+u("top",1)+u("left",1)+u("height",1)+u("width",1)+u("borderRadius",1)+u("position",0)+u("fontSize",0)+u("color",0)+u("borderColor",0)+u("backgroundColor",0)+"\n");n&&DOM.removeNode(e);if(r=(r=r.replace(/(#useLibDesigner::?before")(\/\/[a-zA-Z0-9-_]+)"/,(function(e,t,n){return l=JSON.parse(atob(n.slice(2))),""}))).replace(/\s*calc\([^\)]+?\)\s*/g,"calc()"),!!l)if(l.version!=conf.designVersion)s="hint";else if(d(o))s="error";else{if(n&&-1!=n)return n.checksum=getCheckSum(r),n;(l.domain&&l.domain.length&&-1==location.hostname.indexOf(l.domain)||$I(l.checksum)!=getCheckSum(r))&&(s="error")}if(s)return dialog.setMsg(s,"hint"==s?"designVersion":"designAuth",0,6500),-1==n&&l;return l;function u(e,t){return i[e]?e+(t?i[e]:""):""}function d(e){var t=/\[\s*value\s*(|^|\$|~|\*|\|)=/g.test(e);return t||e.replace(a,(function(e,n,i,a){return/useLib.css$/i.test(a)||/^data:/i.test(a)||(t=!0),e})),t}}(e.sheet.cssRules))}catch(e){i++<25?setTimeout(a,125):t(!1)}}():t(!1)},setDesign=function(e,t){function n(){!0===activeDesignLink.sheet.disabled&&(DOM.removeNode($("uLdraggedDesign")),activeDesignLink.sheet.disabled=!1)}checkDesign(e,(function(i){i?function(t){var i=$(cssNS.copyright);i.firstChild.href="mailto:"+t.email+"?subject=Your Design: "+t.en,i.firstChild.innerHTML=t.copyright==conf.designRight?develop:"© desidned by "+t.copyright,e==activeDesignLink&&(useLibData.design=$(cssNS.designer).selectedIndex,store(),n())}(i):e==$("uLstandSheet")?e.innerHTML=t:!1===t?(useLib.call.setDesign(0),n()):0!=t&&useLib.call.setDesign(t)}),!1)},getCheckSum=function(e){for(var t=0,n=e.length,i=0,a=0;t<n;){do{a+=i+=e.charCodeAt(t++)}while(t<n&&t%20);i=(255&i)+(i>>8),a=(255&a)+(a>>8)}return(a=(255&a)+(a>>8))<<8|(i=(255&i)+(i>>8))},hasNet="localhost"===location.hostname||"127.0.0.1"===location.hostname||navigator.onLine,msgReplace=function(e,t,n,i){var a=lang[e].slice(0);return a[$I(n)]=a[$I(n)].replace(/%%/,t),["span",{}].concat(getStruct.header(a,i||1))},filename2Msg=function(e,t){var n=t.indexOf("?");return n>0&&(t=t.slice(0,n)),msgReplace(e,t.slice(t.lastIndexOf("/")+1).replace(/\.txt\.css$/i,".txt"))},decodeJson=function(e){return e=useLib.security&&"//"!=e.slice(0,2)?useLib.security.decodeJson(e):function(e){try{return JSON.parse(e)}catch(e){return{code:400,msg:"accessError"}}}(atob(e.slice(2)))},getJsonCss=function(e,t){for(var n=e.sheet?e.sheet.cssRules:[],i=0;i<n.length;i++)if(new RegExp("#"+t+"::?before","i").test(n[i].selectorText||""))return decodeJson(n[i].style.content.slice(1,-1));return n.length?-1:-2},getHeadElement=function(e,t,n,i,a,r=!0){var o=e.getElementById(n);return DOM.removeNode(o),o=e.createElement(t),$A(o,"id",n),"meta"!=t&&($A(o,"type","text/"+("script"==t?"javascript":"css")),$A(o,"charset","utf-8"),$A(o,"crossorigin","anonymous")),"meta"==t?(o.name=i,o.content=a):("link"==t||"style"==t?($A(o,"rel","stylesheet"),i&&$A(o,"href",i)):i&&$A(o,"src",i),a&&(o.innerHTML=a)),r&&e.head.appendChild(o),o},loadJSONCSS=(callStore={},check="uLaccess.json.css",setScript=function(e,t,n){var i,a=/\.js$/.test(e),r=(e.indexOf("/")<0?conf.cssPath:"")+e,o=!1;return a||e===check||(o=dialog.setMsg("hint",useLib.security&&e.indexOf(useLib.security.apiPath)>-1?"encryptedMsg":"loadMsg",0,t||3e3)),(i=getHeadElement(D,a?"script":"link",e,r)).onload=function(){if(a)extern[e]=!0;else{var t=extern[e]=getJsonCss(this,"useLibJson");n||t&&!t.code&&!t.msg||(t.msg?dialog.setMsg(/^20\d/.test(t.code)?"success":"error",lang[t.msg]||t.msg,0,4500):/^40(0|1)/.test(t.code)&&(dialog.setMsg("error",filename2Msg("fileMsg",e),0,3500),extern[e]=-2)),DOM.removeNode(this)}o&&dialog.closeBox($(o)),function(e,t){if(callStore[e]&&-2!=extern[e]){for(var n=0;n<callStore[e].length;n++)callStore[e][n](t);delete callStore[e]}}(e,extern[e])},i.onerror=s,setTimeout((function(){-1==extern[e]?e==check?(hasNet=!1,s()):!1!==r&&dialog.confirm(filename2Msg("serverMsg",e),(function(a){DOM.removeNode(i),!0===a&&(extern[e]=-4,setScript(e,t,n))}),-8):-4==extern[e]&&s()}),t||6500),i;function s(){DOM.removeNode(i),e==check?extern[e]=-3:(extern[e]=-5,dialog.setMsg("error",filename2Msg("fileMsg",e),0,3500))}},setScript(check),function(e,t,n,i){return!e||!hasNet||extern[e]&&-1!=extern[e]?hasNet||(extern[e]=-3):(t&&(callStore[e]||(callStore[e]=[]),callStore[e].push(t)),extern[e]||(extern[e]=-1,setScript(e,n,i))),-5==extern[e]&&dialog.setMsg("hint","? "+e+" ?",D.activeElement,2500),!(extern[e]<0)&&(extern[e]||!1)}),ajax=function(e,t,n,i,a,r){var o=new XMLHttpRequest,s=String(location.href),l="GET",c=null;if("file:"==s.slice(0,5))dialog.setMsg("error",filename2Msg("fileMsg",s),0,3500);else if(o){/txt/i.test(n)&&-1==e.indexOf("/")&&(e=conf.wikiPath+e);try{/method=[^&]+/.test(e)&&("post"==conf.submitType.toLowerCase()&&(l=e.indexOf("?"),c=e.slice(l+1),e=e.slice(0,l)),l=conf.submitType),o.open(l,encodeURI(e),!a),o.onreadystatechange=function(){4==o.readyState&&(o.status>400||200==o.status&&/#useLibJson:before\s*\{/.test(o.responseText)?(dialog.setMsg("error",filename2Msg("fileMsg",e),0,3500),u()):200==o.status&&(i&&clearTimeout(o._timeout),t("XML"==n?o.responseXML:"JSON"==n?decodeJson(o.responseText):o.responseText)))},c&&o.setRequestHeader("Content-type","application/x-www-form-urlencoded"),o.send(c),a?o._timeout=setTimeout(u,i):(o.timeout=i,o.ontimeout=u)}catch(d){}function u(){o.abort(),o=null,r&&r(e)}i&&(r=r||function(){dialog.confirm(filename2Msg("serverMsg",e),(function(e){!0===e&&ajax.call(arguments)}))})}},dispatchEvent=function(e,t){var n=new Event(t);n?e.dispatchEvent(n):e.fireEvent("on"+t)},escapeUnicode=function(e){return e.replace(/[^\x00-\xff]|[\x80-\xff]/g,(function(e){return"\\u"+("000"+e.charCodeAt(0).toString(16)).substr(-4)}))},unescapeUnicode=function(e){return e.replace(/\\(u|x)([0-9A-Za-z]{4})/g,(function(e,t,n){return String.fromCharCode("0x"+n)}))},uLeval=function(e,t,n,i,a){e=e.replace(/\([^\)]*\);?/,"").split(".");for(var r=0,o=W;r<e.length&&o[e[r]];r++)o=o[e[r]];o&&o.call&&o.call(this,t,n,i,a)},repeat=function(e,t){return Array($I(t)+1).join(e)},compare=function(){var e={"Â|À|Å|Ã|Á":"A","â|à|å|ã|á":"a","Ä":"Ae","ä":"ae","Ç":"C","ç|ć|č":"c","đ":"d","É|Ê|È|Ë":"E","é|ê|è|ë":"e","Ó|Ô|Ò|Õ|Ø":"O","ó|ô|ò|õ":"o","Ö":"Oe","ö":"oe","Š":"S","š":"s","ß":"ss","Ú|Û|Ù":"U","ú|û|ù":"u","Ü":"Ue","ü":"ue","Ý|Ÿ":"Y","ý|ÿ":"y","Ž":"Z","ž":"z"},t="(",n=[],i=function(e){return String(e).replace(t,(function(e){return n[Array.prototype.slice.call(arguments,1).indexOf(e)]}))};for(var a in e)t+=a+")|(",n.push(e[a]);return t=new RegExp(t.slice(0,-2),"g"),function(e,t){return(e=i(e))<(t=i(t))?-1:e>t?1:0}}(),zeroInt=function(e,t,n,i){return t-=String($I(e)).length-1,t=new Array(Math.max(1,t)).join(i||"0"),(n?"":t)+$I(e)+(n?t:"")},delayRemove=function(e,t,n){var i,a;typeCheck("Array",t)||(t=[t,0]),$CN.add(e,t[0]),n=1e3*$I(n||$I($GS(e,"animation-period"))),setTimeout((i=e,a=t,function(){$CN.remove(i,a[0]),$CN.remove(i,a[1])}),n)},hasFocus=!1,firstAct=function(){hasFocus=!0,$E(W,"focus",firstAct,1)},sound=function(e){hasNet&&e&&e.play&&!$CN.contains($(cssNS.sound),cssNS.locked)&&e.play()},setOpenClose=function(e,t,n){t?($CN.add(e,cssNS.show),delayRemove(e,cssNS.open,n||2)):($CN.add(e,cssNS.close),delayRemove(e,[cssNS.close,cssNS.show],n||2))},call={uLinit:function(e,t){this[e]=t}},checkElement=function(e,t){var n="button submit reset image hidden".split(" ");return!("FIELDSET"==e.tagName||"BUTTON"==e.tagName||-1!=n.indexOf(e.type)||(!t||null===e.offsetParent)&&$CN.contains(e,"uL_ignore")||(t?$CN.contains(e,cssNS.covered):$CN.contains($P(e),cssNS.isCover)))},filterElements=function(e,t){var n=[];e="FORM"==e.tagName?e.elements:e;for(var i=0;i<e.length;i++)checkElement(e[i],t)&&n.push(e[i]);return n},getLandmark=function(e){return $Q(D.body,htmlSupport.landmarks[e].selector,1)},getResetEle=function(e){var t=e.value.toString()||"";return t==e.resetValue.toString()&&e.storeValue?e.storeValue:t!=e.resetValue.toString()?e.resetValue:e.value},resetElements=function(e){if(e&&e.currentTarget&&(e.stopPropagation(),e.preventDefault(),e=e.currentTarget),e&&(e=e.htmlFor?[$(e.htmlFor)]:filterElements($Q("legend"==e.tagName?$P(e):e,"input, select, textarea"))),e&&e.length)for(var t=0,n=formDef[e[0].form.name];t<e.length;t++)dialog.removeError(e[t],null),setEleValue(e[t],getResetEle(n[e[t].name]),!0)},optionExtRegEx=/#(\w+)$/,getSelectionAttr=function(e){return"SELECT"==e.tagName?"selected":"checkbox"==e.type||"radio"==e.type?"checked":"value"},getEleValue=function(e,t=!0){var n,i,a=[];if(e&&e.type)if("value"==(n=getSelectionAttr(e)))a.push("file"==e.type?(i=e.files[0]?e.files[0].name:$A(e,"data-ul"))&&i.length?i.replace(/.*?([^\\\/]+)$/,"$1"):"":e.value);else{e=$Q(e.form,(t?"checked"==n?"input":"select":"")+'[name="'+e.name+'"]');for(var r=0;r<e.length;r++)o(e[r])}return a;function o(e){if("SELECT"==e.tagName){e=e.options;for(var t=0;t<e.length;t++)e[t].selected&&a.push(e[t].value)}else!0===e.checked?a.push(e.value):"true"==e.value&&a.push("false")}},setEleValue=function(e,t,n=!1){if(e&&e.type){var i=getSelectionAttr(e);if(t=typeCheck("Array",t)?t[0]?t:[""]:[t||""],"value"==i)"file"!=e.type?($A(e,i,t[0]||""),e.value=t[0]||""):metaReaction.file&&metaReaction.file.setValue(e,t[0]),onchange(e);else{e=n?$Q(e.form,'[name="'+e.name+'"]'):[e],t=t.slice(0);for(var a=0,r=[];e&&a<e.length;a++){if("selected"==(i=getSelectionAttr(e[a])))for(var o=0,s=e[a].options;o<s.length;o++)$CN.contains(s[o],"ownInput")&&r.push(s[o]),l(s[o]);else $CN.contains(e[a],"ownInput")&&r.push(e[a]),l(e[a]),"radio"==e[a].type&&e[a][i]&&(getFormDef(e[a]).activeRadio=e[a]);onchange(e[a])}if(r.length&&t.length)for(a=0;t[a]&&a<r.length;a++)ownInput.set(r[a],t[a])}return t}function l(e){var n=t.indexOf(e.value);n>-1&&t.splice(n,1),$A(e,i,n>-1?i:-1),e[i]=n>-1}},getAllValues=function(e,t,n){n=n||D;var i=formDef[t],a=e,r={},o=[];Array.isArray(a)||(e="[name"+(e&&e.length?'^="'+("]"==e.slice(-1)?e.replace(/\d+\]/,""):e)+'"':"")+"]",a=$Q(n.forms[t]||n.body,"input"+e+",select"+e+",textarea"+e));for(var s,l=0;l<a.length;l++)s=a[l].name,$CN.contains(a[l],"uL_ignore")||!i||!i[s]||i[s].ignore||i[s].hasEmpty||(c=u()).length&&(s=s.replace(/\[\d+\]$/,"[]"),isNaN(r[s])?(r[s]=o.length,o.push({name:s,value:c,task:i[s].task||!1,e:a[l],ex:JSONexpands[i[s].type]||null,uLis:!0})):o[r[s]].value=[].concat(o[r[s]].value,c));var c;for(l=0;l<o.length;l++)c=o[l].value,Array.isArray(c)?(c=c.filter((function(e,t){return c.indexOf(e)==t})),/\[\]$/.test(o[l].name)||(c=c[0])):/\[\]$/.test(o[l].name)&&(c=[c]),o[l].value=c;return o;function u(){return c=a[l].value,"checkbox"==a[l].type||"radio"==a[l].type?"true"!=c||a[l].checked?a[l].checked?c:"":"false":"hidden"==a[l].type||"password"==a[l].type?c:"SELECT"==a[l].tagName?getEleValue(a[l]):c}},getJSONValues=function(e,t,n){n=n||D,t=t||$Q(n,htmlSupport.landmarks.main.selector+" form",1).name;var i,a={},r={},o={};if(n.forms[t]){i=Array.isArray(e)&&e[0].uLis?e:getAllValues(e,t,n);for(var s=0,l={};s<i.length;s++)c(i[s].name.split("."),i[s].value,i[s].e,i[s].ex),i[s].task&&(l[i[s].name]=i[s].task);a.formName=t,a.tasks=l}return a;function c(e,t,n,i){e.length>1&&function(t){(t=$P(t))&&(t=$P(t))&&(t=$A(t.firstChild.firstChild,"data-ul-dynlist"))&&((t=t.split(":"))[1]=t[1].split(".").pop(),wikiEnsemble[t[0]]&&e.indexOf(t[1])>-1&&(t[1]=t[1].replace(/\[\d*\]$/,"[]"),o[t[1]]||(o[t[1]]=t[0])))}(n);for(var s,l,c,u,d=0,f=a;d<e.length;d++)if(l=!1,c=e[d].replace(/\[(\d*)\]$/,(function(t,n){return u=(u=(u=e.slice(0,d+1)).join(".")).replace(/\[\d*\](?!.*\[\d*\])/,"[]"),l=n,"[]"})),d==e.length-1)if(i&&i.active){if(f[c]={},Array.isArray(t)&&(t=t[0]),t=t.match(new RegExp(i.reg)))for(var g=0;g<i.names.length;g++)f[c][i.names[g]]=t[g+1]}else f[c]=t;else(s=o[c])&&(o[c]||(o[c]=s),f[s]||(f[s]={}),f=f[s]),!1!==l?(r[u]||(r[u]=[],f[c]=[]),s=l,(l=r[u].indexOf(l))<0&&(l=r[u].length,r[u].push(s),f[c].push({})),f=f[c][l]):(f[c]||(f[c]={}),f=f[c])}},setJSONValues=function(e,t){t=t?t.name?t:D.forms[t]:e.formName?D.forms[e.formName]||!1:!!D.forms.length&&D.forms[0];var n=!1;if(!1!==t){for(var i in metaReaction.grouper.deleteAllGrouper(t),e.cloud&&($CN.add(t,cssNS.cloud),delete e.cloud),delete e.formName,reInitValues=!0,internChange=!0,$S(t).visibility="hidden",e)if("tasks"==i){if(conf.taskSupport)for(var a in e[i])call.taskstep(labels[$Q(t,'[name="'+a+'"]',1).id],e[i][a])}else"attrDef"==i?r(e[i]):o(i,e[i],!1);$S(t).visibility="visible",reInitValues=!1,internChange=!1,initForm(t),n&&(D.activeElement.blur(),DOM.scrollIntoView(getLandmark("navigation"),0,1))}return n;function r(e){for(var t in e){var n=D.getElementsByName(e[t]);if(n)for(var i in e[t])$A(n[0],i,e[t][i])}}function o(e,i,a){var r=!!formDef[t.name]&&formDef[t.name][e],s=(e.match(/[^\.]+$/)||[""])[0],l=e.slice(0,-s.length);if(a||i!==Object(i)){if(!function(){var e=JSONexpands[s];if(e&&e.active&&typeCheck("String",i)&&(v=i.match(e.reg))){v=v.slice(1);for(var n=0;n<e.names.length;n++)setEleValue($Q(t,'[name="'+l+e.names[n]+'"]',1),[v[n]]);return!0}return!1}()){f=0;for(var c=$Q(t,'[name="'+e+'"]');c&&f<c.length;f++)g(i,c[f],0===f);n=!0}}else{var u=call.dynList?$Q(t,'[data-ul-dynlist^="'+s+":"+l+'"]'):[];if(u.length){for(var d in-1==$A(u[0],"data-ul-dynlist").indexOf("uLmaster")?(u=call.dynList.removeNodes(u),l.length||function(e){for(var t in e)new RegExp("^"+s+"[d+].").test(t)&&delete e[t]}(formDef[t.name])):u=u[0],e=l,i)if(l=e+d,Array.isArray(i[d]))for(var f=0;f<i[d].length;f++)l=l.replace(/\[\d*\]$/,"["+zeroInt(f,5)+"]"),call.dynList.insertNode(u,s,l,0),o(l,i[d][f]);else call.dynList.insertNode(u,s,l,0),o(l,i[d]);l=$P(u),DOM.removeNode(u),l&&call.dynList.action(l,s,"init")}else if(!function(){var n,a=$Q(t,'[name="'+e+'"]',1),s="";if(a){if(ex=JSONexpands[r?r.type:$A(a,"type")]){if(ex.active){(n=ex.reg.replace(/\([^\)]+\)/g,"؀").split("؀")).shift();for(var l=0;l<ex.names.length;l++)s+=i[ex.names[l]]+n.shift()}g([s],a,!0)}else o(e,i,!0);return!0}return!1}())for(var d in i)o(e+"."+d,i[d])}function g(e,t,n){e=Array.isArray(e)?e:[(e||"")+""],"isGrouper"==$A(t,"data-ul-grp")?metaReaction.grouper.setGrouper(t,e,r?r.type:$A(t,"type")):(n&&r&&(r.value=e),setEleValue(t,e,!0))}}},focusTime=!1,setFocus=function(e,t){e&&(e=$CN.contains(e,cssNS.covered)?$(getFormDef(e).first):e,clearTimeout(focusTime),focusTime=setTimeout((function(){lastActive=e,e.focus()}),t||20))},getLabelText=function(e,t){var n="";e=!(!e||!labels[e.id])&&labels[e.id].childNodes;for(var i=0;e&&i<e.length;i++)e[i].tagName&&e[i].tagName.toLowerCase()==conf.mnemonicsMarker||(n+=e[i].textContent);return n=n.trim(),t&&(t=JSON.parse(JSON.stringify(t).replace(/(in|of|von )?%%/g,n.length?'$1 \\"'+n+'\\"':""))),t||n},analyseFilter=function(e,t){var n=e.match(/^(>=|<=|>|<)/);if(t)return!1!==i(e)?function(e,t){return a(i(e),i(t))}:compare;if(n)return e=e.slice(n[0].length).trim(),n=n[0].trim(),(e=i(e))?function(t){return-1==(t=a(i(t)||0,e))&&"<"==n[0]||0===t&&n[1]||1==t&&">"==n[0]}:function(t){return compare(e,t)};'"'==e[0]&&'"'==e.slice(-1)&&(e="^"+e.slice(1,-1)+"$");try{return e=new RegExp(e.replace(/(\w)(,|\.|-)(\w)/g,"$1[\\.,-]$3"),"i"),function(t){return e.test(t)?1:0}}catch(t){return function(t){return e.indexOf(t)>-1}}function i(e){var t=!1;return(t=e.match(/^\d{1,4}\D\d\d?\D\d{1,4}/))?(4==(t=(t=t.split(/[T\/.:,_-]/)).splice(0,3))[2].length&&t.reverse(),t=t.join("-"),e.length&&(t+="T"+e.join(":")),t=new Date(t),t=!isNaN(t.getTime())&&t):(t=e.match(/^\d+([,\.]\d*)?$/))&&isNaN(t=parseFloat(e))&&isNaN(t=parseInt(e))&&(t=!1),t}function a(e,t){return e<t?-1:e>t?1:0}},getStruct={createNodes:$CE,button:function(e,t,n){return[e[3]?"a":"button",{CN:cssNS.button+(n?" "+n:""),type:e==lang.reset?"reset":e==lang.store||e==lang.submit?"submit":"button",value:e[3]||n?null:e[0],href:e[3]?e[3]:null,MC:t},["span",{},["span",{},["span",{},["span",{},["span",{},["span",{},e[0]]]]]]]]},buttonRow:function(e,t,n,i,a,r){return["div",{CN:cssNS.buttonRow},this.button(n||lang.cancel,r||"useLib.call.closeForm(this.form)"),this.button(t||lang.reset,a||null),this.button(e||lang.store,i||null)]},doubleButton:function(e,t){return["div",{CN:cssNS.doublebutton},this.button(e,"",cssNS.top),this.button([["b",{},"-"]],t+"(-1)",cssNS.left),this.button([["b",{},"+"]],t+"(1)",cssNS.right)]},radioCheck:function(e,t,n,i,a,r,o,s,l,c){return["div",{CN:t||null},["input",{id:i,type:e?"checkbox":"radio",name:a||null,value:r||null,checked:o?"checked":null,disabled:s?"disabled":null,MC:c||null}],["label",{for:i,IH:(l?"<tt>"+l+"</tt>":"")+useLib.WIKI.toHTML(n).slice(3,-4)}]]},getText:function(e,t){return e&&e.length?[useLib.WIKI.open||/\n\n/.test(e)?"div":"span",{CN:t||null,IH:useLib.WIKI.toHTML(e)}]:null},input:function(e,t,n,i){return n.id=e,["div",i?{style:"--ulwidth:"+i}:{},["label",{for:e,CN:t[1]?cssNS.hasInform:null},t[0]],this.getText(t[1],cssNS.inform),this.getText(t[2],cssNS.explain),["textarea"==n.type||"select"==n.type?n.type:"input",n]]},header:function(e,t,n,i){return[["h"+(t||1),{CN:n||null,IH:useLib.WIKI.toHTML(e[0]).replace(/<p>([\s\S]+)<\/p>/,"$1")}],this.getText(e[1],i?null:cssNS.inform),this.getText(e[2],i?null:cssNS.explain)]},container:function(e,t,n){var i=htmlSupport.landmarks[e];return IH=["div",{CN:cssNS.landmark+" "+(i?i.selector.slice(1):e),IH:n?t:useLib.WIKI.toHTML(t)},["div",{CN:cssNS.design,IH:"<span><span><span><span><span></span></span></span></span></span>"}]],$CE(IH)}},minimizer=function(e){return["button",{CN:cssNS.minimizer,MC:"useLib.call.setMinimizer(this)",T:e+" "+lang.minimizer[0]}]},controls={init:function(){var e,t=str2obj(conf.userSupport);this.done||(this.helpTxt=[],(t.sizer||t.explainer||t.designer)&&this.selector(t),t.security&&useLib.security&&this.security(),t.hamburger&&this.hamburger(),t.jumper&&this.jumper(),t.fastfeeder&&this.fastfeeder(),this.section(lang.interaction,2),this.section(lang.help,1,this.helpTxt),this.done=!0,$Q(D.body,"."+cssNS.layout,1)&&(e=DOM.getScrollbarWidth(),$S($(cssNS.selector)).right=e+"px",$S($(cssNS.jumper)).right=e+"px"),t.showhelp&&1==useLibData.show&&(setTimeout((function(){$("uLhelp").click()}),1e3),useLibData.show=0,store()))},selector:function(e){var t=Object.keys(conf.designDefs),n=[],i=[],a=[];if(!$(cssNS.selector)){if($LS.fake&&this.section(msgReplace("localStorage",lang.options[0],0,3),2),e.sizer&&(n=["div",{id:cssNS.sizer,T:lang.sizer[1]},["span",{MC:"useLib.call.resizeFont(-1)"},"◄"],["span",{MC:"useLib.call.resizeFont(1)",CN:cssNS.sizer},lang.sizer[0]+(useLibData.size+1)],["span",{MC:"useLib.call.resizeFont(1)"},"►"]],this.section(lang.sizer,3)),e.explainer&&(i=["div",{T:lang.explainer[1]},["label",{for:cssNS.explainer},lang.explainer[0]],["select",{id:cssNS.explainer,OC:"useLib.call.setExplain()"},["option",{value:cssNS.explainAll},lang.explainAll[0]],["option",{value:cssNS.explainLess},lang.explainLess[0]],["option",{value:cssNS.explainNone},lang.explainNone[0]]]],this.section(lang.explainer,3)),e.designer&&hasNet){var r=$("uLstandSheet");if("STYLE"==r.tagName?(DOM.insertBefore(r,$CE(["link",{title:conf.designDefault,type:"text/css",rel:"stylesheet",href:conf.designDefs[conf.designDefault].path}])),activeDesignLink=r?r.previousSibling:null,DOM.removeNode(r),$A(activeDesignLink,"id","uLstandSheet")):activeDesignLink=r,setDesign(activeDesignLink,useLibData.design),activeDesignLink&&t.length>1&&hasNet){for(var o in t=conf.designDefs,a=["select",{id:cssNS.designer,OC:"useLib.call.setDesign()"}],t)a.push(["option",{value:o,title:t[o].designer||null},t[o][lang.uLlang]||t[o].en||o]);a=["div",{T:lang.designer[1]},["label",{for:cssNS.designer},lang.designer[0]],a],this.section(lang.designer,3)}}function s(e){return e=e.currentTarget,useLibData[e.id]=$CN.toggle(e,cssNS.locked)?1:0,store(),!1}this.section(lang.options,2,this.helpTxt),this.section(lang.minimizer,2),D.body.appendChild($CE(["div",{id:cssNS.selector,CN:cssNS.noUserSelect},["div",{},["h1",{},lang.options[0]],n,i,a,["div",{CN:cssNS.help},["button",{id:"uLhelp",CN:cssNS.help,T:lang.help[0]}],["button",{id:"uLmsghold",CN:cssNS.msghold+(useLibData.msghold?" "+cssNS.locked:""),T:lang.msghold[0]}],["button",{id:"uLsound",CN:cssNS.sound+(useLibData.sound?" "+cssNS.locked:""),T:lang.sound[0]}],["button",{id:"uLseminar",CN:cssNS.seminar+(useLibData.seminar?" "+cssNS.locked:""),T:lang.seminar[0]}],e.security?["span",{id:cssNS.secDragg,CN:cssNS.locked,T:lang.security[0]}]:null],["div",{id:cssNS.copyright},["a",{href:homepage,target:"_blank"},develop],["a",{href:homepage,target:"_blank"},copyright]]],minimizer(lang.options[0])])),$E($("uLhelp"),"MC",(function(){controls.showHelpTxt()})),$E($("uLmsghold"),"MC",s),$E($("uLsound"),"MC",s),$E($("uLseminar"),"MC",(function(e){s(e),controls.showSeminar($CN.contains(e.currentTarget,cssNS.locked))}))}call.uLinit("resizeFont",(function(e){D.body.style.fontSize;var t=$(cssNS.sizer).firstChild.nextSibling;e=(e+=useLibData.size)<0?sizeList.length-1:e>=sizeList.length?0:e,useLibData.size=e,t.innerHTML=t.innerHTML.replace(/\d$/,useLibData.size+1),D.body.style.fontSize=sizeList[useLibData.size],store(),DOM.redraw(D.body),(t=D.activeElement)&&DOM.scrollIntoView(t)})),call.uLinit("setExplain",(function(e){var t=$(cssNS.explainer);t&&($CN.remove(D.body,t.options[useLibData.explain].value),useLibData.explain=t.selectedIndex=e||t.selectedIndex,setTimeout((function(){t.selectedIndex!=useLibData.explain&&useLib.call.setExplain(t.selectedIndex)}),1e3),$CN.add(D.body,t.options[t.selectedIndex].value),store(),DOM.redraw(D.body),0===useLibData.explain?DOM.scrollIntoView(D.body,0,0):setFocus(lastActive))})),call.uLinit("setDesign",(function(e){var t=$(cssNS.designer);t&&(t.selectedIndex=isNaN(e)?t.selectedIndex:e,activeDesignLink.href=conf.designDefs[t.options[t.selectedIndex].value].path,setDesign(activeDesignLink,useLibData.design),DOM.redraw(D.body),setFocus(lastActive))})),call.drop.init($(cssNS.selector)),useLib.call.resizeFont(0),useLib.call.setExplain(useLibData.explain),useLib.call.setDesign(useLibData.design),controls.showSeminar(useLibData.seminar)},hamburger:function(){var e=$Q(D.body,"."+cssNS.layout,1);DOM.insertBefore(e,$CE(["button",{id:cssNS.hamburger,T:lang.hamburger[0]}])),e=$(cssNS.hamburger),$E(e,"MC",(function(){return useLibData.hamburger=$CN.toggle(D.body,cssNS.hiddenNavi)?1:0,store(),!1})),e&&useLibData.hamburger&&e.click()},showSeminar:function(e){var t,n="",i=-1,a=0;function r(t){e?DOM.removeNode($(t)):D.body.appendChild($CE(["div",{id:t},["div",{}]]))}function o(e,t){var r=e.keyCode,o=e.shiftKey&&16!=r&&(e.key.length>1||e.altKey||e.ctrlKey||e.metaKey),s=e.metaKey&&224!=r,l=e.ctrlKey&&17!=r,c=e.altKey&&18!=r&&e.key.length>1,u=$(cssNS.keyStroke);r={8:"⌫",9:"⇥",13:"⏎",19:"⏸",27:"⎋",32:"␣",33:"⇞",34:"⇟",35:"⇘",36:"⇖",45:"↪",46:"⌦",38:"▲",40:"▼",37:"◄",39:"►"}[e.keyCode]||(e.key.length<3?e.key:""),u&&r.length&&(r=(o?"^":"")+(c?"⌥":"")+(l?"⎈":"")+(s?"⌘":"")+r+(e.key.length>2||32==e.keyCode?"<div>"+(o?"Shift ":"")+(c?"Alt ":"")+(l?"Ctrl ":"")+(s?"Cmd ":"")+(32==e.keyCode?"Space":e.key)+"</div>":""),n==r?a++:a=0,n=r,u.innerHTML=(D.activeElement&&"password"==D.activeElement.type?"•":r)+(a<2?"":"<span>"+a+"</span>"),clearTimeout(i),i=setTimeout((function(){setOpenClose(u,!1,1.7),n=""}),1500),$CN.add(u,cssNS.show))}$E(W,"MM",(function(e){var t=$(cssNS.headLight);t&&(e=DOM.getCoord(e),DOM.setPos(t.firstChild,e.x-W.pageXOffset-80,e.y-W.pageYOffset-80))}),e),$E(W,"KD",o,e),r(cssNS.headLight),r(cssNS.keyStroke),$E($(cssNS.keyStroke),"MD",(function(e){DOM.dragStart(e,this,3,0,0,W.innerWidth-50,W.innerHeight-50)})),i<0&&(t=Event.prototype.stopPropagation,Event.prototype.stopPropagation=function(){return this.currentTarget==W||"keydown"!=this.type||useLibData.seminar||o(this,"from"),t.apply(this)})},security:function(){useLib.security.dragsecure($(cssNS.secDragg))},jumper:function(){$(cssNS.jumper)||(call.uLinit("setTop",(function(e){DOM.scrollIntoView(lastLinkPosition||getLandmark("main"),e||0,1),lastLinkPosition=!1})),this.section(lang.jumper,2),D.body.appendChild($CE(["div",{id:cssNS.jumper,CN:cssNS.noUserSelect,MC:"useLib.call.setTop();",T:lang.jumper[0]},["button",{CN:cssNS.jumper}]])))},fastfeeder:function(){if(!$(cssNS.fastfeeder)){call.uLinit("pasteFastfeeder",(function(e){setTimeout((function(){e.currentTarget.value=e.currentTarget.value.trim().replace(/\\n */gm,"\n")}),0)})),call.uLinit("doFastfeeder",(function(e){var n=e.currentTarget,i=!1;return(i=13==e.keyCode)?n.value=t(n.value,!1,!1,n):(i=27==e.keyCode)?n.value=t(n.value,!0,e.shiftKey,n):(i=e.ctrlKey&&17!=e.keyCode)?n.value=a(n,"\\c"+String.fromCharCode(e.keyCode)+" "):(i=e.altKey&&18!=e.keyCode)?n.value=a(n,"\\a"+String.fromCharCode(e.keyCode)+" "):(i=9==e.keyCode)&&(n.value=a(n,e.shiftKey?" \\ST ":" \\T ")),!i;function a(e,t){return e.value.slice(0,e.selectionStart)+t+e.value.slice(e.selectionEnd)}}));var e=getStruct.input("doFastfeeder",lang.fastfeeder,{});e[2][1].IH="<kbd>F2</kbd> ",e[3][1].CN+=" "+cssNS.bottom,e.splice(-2),call.uLinit("setFastfeeder",(function(){var e=!$CN.contains($(cssNS.fastfeeder),cssNS.minimized);e=e?1:0,e+=$(cssNS.fastLabel).checked?2:0,useLibData.feeder=e,store()})),D.body.appendChild($CE(["div",{id:cssNS.fastfeeder,CN:useLibData.feeder?null:cssNS.minimized},e,getStruct.radioCheck(!0,cssNS.fastLabel,lang.fastLabel[0],cssNS.fastLabel,null,null,useLibData.feeder>1,null,null,"useLib.call.setFastfeeder()"),["div",{},["textarea",{id:"doFastfeeder",KD:"return useLib.call.doFastfeeder( event )",onpaste:"useLib.call.pasteFastfeeder( event )",ondrop:"useLib.call.pasteFastfeeder( event )",rows:conf.fastFeederRows,"aria-label":lang.fastLabel[1]}]],minimizer(lang.fastfeeder[0])])),this.section(lang.fastfeeder,2)}function t(e,t,n,i){var a=!1,r=!1,o="";e=e.replace(/\\/g,"\\").replace(/:\[[^\]]+\]/g,"").replace(/\*s(\r\n|[\n\v\f\r\x85\u2028\u2029])/gm,"\n").replace(/\s*(\\s?t)/gi,"$1").trim().split(/\n+/gm);for(var s=0;s<e.length;s++)o+="\n"+l(e[s]);return r?setTimeout((function(){i.focus(),i.select()}),100):o=o.replace(/\s+/gm," ").replace(/\n(\s*\n)+/gm,"\n"),o=o.trim(),cover.keyMsg($("doFastfeeder"),!r&&!t&&o.length||o==e?"Error":"Success"),o;function l(e){var i,o,s={message:f,sound:f,help:f,seminar:f,submit:g,reset:g,clear:g,close:g,dump:function(){var e="";t=!0,p({ident:"#1",add:0});for(var n,i=0;i<a.length;i++)e+=l((n=Object.values(mnemonics).indexOf(a[i].id))>-1?Object.keys(mnemonics)[n]:"#"+(i+1));return e},export:function(){var e=location.pathname.match(/([^\/]+)\.html/);return call.saveAs(e?e[1]+".json":"",JSON.stringify(getJSONValues(),null,"\t")),""},wikibase:function(){p({ident:"#1",add:0});for(var e=wikiSigns,t=e.block+"form"+r(a[0].form,"name","action"),n="",i=0;i<a.length;i++)t+=o(a[i]);return t+"\n"+e.blockEnd;function r(t,n){for(var i,a="",r=2;r<arguments.length;r++)(i=$A(t,arguments[r]))!=n&&(a+=" "+arguments[r]+'="'+i+'"');return a.length?"\t"+e.interface+a+" "+e.interface+"\n":"\n"}function o(t){var i=getSelectionAttr(t),a=getFormDef(t),o=getLabelText(t),s="";if("value"==i)s+=e.header+" "+o+" "+r(t,o,"name")+e.define+(a.type||"text")+"\n\n";else if("checked"==i)s+=(i="radio"==t.type?e.bullet:e.number)+" "+o+" "+r(t,o,"name","value");else{s+=e.header+" "+o+r(t,"name"),t=$T(t,"option"),i="multiSelect"==a.type?e.table:e.indent;for(var l=0;l<t.length;l++)s+=i+" "+t[l].text+r(t[l],t[l].text,"value")}return i!=n&&(s="\n"+s),n=i,s}}},c=!!e.length&&e.match(/[^\s]+/)[0],u="";if(c&&s[o=c.toLowerCase()])r=!0,u=s[o](o);else if(c)if((i=function(){var e=/\\(s?t)/gi,t=!1;(t=n(c,!1))||(t=n(c.replace(e,""),c))||(t=i(c));return t;function n(e,t){return!!mnemonics[e]&&(before=e,t?i(t):{ident:e,add:0})}function i(t){var n=0;return{ident:t=t.replace(/^\+/,"#1+").replace(e,(function(e,t){return"st"==t?"-1":"+1"})).replace(/(\+|-)\d+/g,(function(e){return n+=$I(e),""})),add:n}}}())&&(o=p(i)))if(e=e.slice(c.length).trim(),t||e.length){i=function(e,t,n){var i=getSelectionAttr(e),a=[];if(t.e=o,"value"==i)return t.v=n,[t];n=n.replace(/(-?\d+)?\s*(>|<)\s*(-?\d+)/g,(function(e,t,n,i){var a=("<"==n?"-":"+")+(t||"");n="<"==n?" -":" ",(t=Math.abs($I(t)))>(i=Math.abs($I(i)))&&(t=[i,i=t][0]);for(var r=t;r<i;a+=n+ ++r);return a})).split(/\s+/);for(var r=0;r<n.length;r++)n[r]=$I(n[r])||n[r];if("selected"==i)return t.v=n,[t];for(r=0;r<n.length;r++)a.push({ident:t.ident,add:t.add+max(0,Math.abs($I(n[r]))-1)}),a[r].e=p(a[r]),a[r].v=n[r]<0||"-"==n[r]?"-":"+",a[r].e&&"checked"==getSelectionAttr(a[r].e)||a[r].pop();return a}(o,i,e);for(var d=0;d<i.length;d++)u=m(i[d].e,i[d].v),(t||u.length)&&(o=i[d].add,u=i[d].ident+(o?o<0?o:"+"+o:"")+"\t"+u+"\n")}else setFocus(o);else u=e;return u;function f(e){return $("message"==e?"uLmsghold":"uL"+e).click(),""}function g(e){return p({ident:"#1",add:0}),a.length?("clear"!=e&&dialog.layer.length?"close"==e?useLib.call.modalClose(a[0].form):(e=$Q(a[0].form,"[type="+e+"]"))&&e.length&&e[0].click():useLib.call[e+"Form"](a[0].form),""):e}function p(e){var t=$(mnemonics[e.ident]);return!t||e.add?(a||(a=!!(a=(a=!!dialog.layer.length&&dialog.layer.slice(-1))?$T($(a[0]),"form",1):D.forms[0])&&Array.prototype.slice.call(filterElements(a))),t=(t?a.indexOf(t):$I(e.ident.slice(1))-1)+e.add,!(!a||t<0||t>=a.length)&&a[t]):t}function m(e,i){var a,r=getSelectionAttr(e),o=getFormDef(e),s="";if(DOM.scrollIntoView($P(e),0,-1),t)if(i=n?getResetEle(o):o.value,"value"==r)s+=($CN.contains(e,cssNS.covered)?cover.getLocal(o.type,i[0]):i[0])+d(e);else if("checked"==r)s+=(i.indexOf(e.value)>-1?"+":"-")+d(e);else{e=$T(e,"option");for(var l=0;l<e.length;l++)i.indexOf(e[l].value)>-1&&(s+=l+1+d(e[l]))}else if(e.disabled)s=i;else if(i.length){if(delayRemove($P(e),cssNS.focused,3),"value"==r)"-"==i?e[r]="":$CN.contains(e,cssNS.covered)?("country"==o.type||"COUNTRY"!=Object.keys(o.subs)[0]||2!=$(o.first).value.length||/^[a-z]{2,2}/i.test(i)||(i=$(o.first).value+i),$(o.first).focus(),doEvent.setInput($(o.first),e.id,i,!0),$("doFastfeeder").focus(),cover.errorList.length&&(s=i)):!o.regexp||o.regexp.test(i)?e[r]=i:s=i;else if("checked"==r)e[r]="-"!=i;else{a=$T(e,"option"),i=i.filter((function(e,t){return i[t]=$I(e),i[t]})).sort((function(e,t){return e-t}));for(var c,u=0;u<i.length;u++)a[c=Math.abs(i[u])-1]&&a[c].text&&!a[c].disabled&&(a[c][r]=i[u]>0,$A(a[c],r,i[u]>0?r:-1),i[u]="");s=i.join(" ").trim(),onchange(e,null)}setTimeout((function(){$("doFastfeeder").focus()}),500)}else setFocus(e);return s;function d(e){var t=" ";return $(cssNS.fastLabel).checked&&(t=" :["+("OPTION"==e.tagName?e.text:getLabelText(e))+"] "),t}}}}},showHelpTxt:function(){var e="helpTxtuL__modal__";$(e)||(dialog.setModal("helpTxt","hint","draggable closable sizable",["div",{id:cssNS.helpTxt,CN:cssNS.content}].concat(this.helpTxt)),initFold($(e)),$T($(e),"h2",1).click())},section:function(e,t,n){var i=e[2]?2:1,a="span"==e[0]?e.slice(2):getStruct.header(e,t,2==t?cssNS.fold:null,!0);n&&(a[i]=a[i].concat(n)),a=[a[0],["div",{},a[1],a[2]]],this.helpTxt=n?a:this.helpTxt.concat(a)},helpTxt:[]},initId=function(){D.body.innerHTML.replace(/\sid="uL_(\d+)/g,(function(e,t){(t=$I(t))>counter&&(counter=t)})),counter++},ensureId=function(e){return e.id||(e.id="uL_"+counter++),e.id},counter=5,min=Math.min,max=Math.max,sizeList="37.5% 50% 62.5% 75% 87.5% 100% 112.5%".split(" "),useLibData=$LS("useLibData"),store=function(){$LS("useLibData",useLibData)},activeDesignLink=!1,getHTMLTag=function(e,t,n,i=!1){return"<"+e+" "+(t||"")+("link"!=e&&"script"!=e?">":' type="text/'+("script"==e?'javascript"':'css" charset="utf-8" ')+(i?("link"==e?' rel="Stylesheet" href="':' src="')+i+'">':">"))+(n||"")+("meta"!=e&&"link"!=e?"</"+e+">":"")},openPopup=function(e,t,n,i){var a=W.open("","_blank",n||"dependent=yes,scrollbars=yes,resizable=yes");return a&&(dialog.setMsg("hint","popUp",0,6500),a.document.write("<!DOCTYPE HTML>"+getHTMLTag("html",'lang="'+conf.lang+'"',getHTMLTag("head","",getHTMLTag("meta",'language="'+conf.lang+'"')+getHTMLTag("meta",'http-equiv="content-'+"type"+'" content="'+"text/html; charset=utf-8"+'"')+getHTMLTag("meta",'name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=no"')+e)+getHTMLTag("body",i?'class="'+i+'"':"",t))),a.document.close()),a},analyseICAL=function(e={},t=""){return t.replace(/BEGIN:VEVENT([\s\S]+?)END:VEVENT/gim,(function(t,n){var i,a,r="";return n.replace(/DT(START|END).*?:(\d{4,4})(\d\d)(\d\d)T(\d\d)(\d\d)/gim,(function(e,t,n,o,s,l,c){return $I(l)+$I(c)>0&&(r+=(r.length?"-":"")+l+":"+c),s=$D(n+"-"+o+"-"+s+"T00:00:00Z"),"START"==t?i=s:a=s,""})),(n=n.match(/SUMMARY:([^\n\r]*)/i))&&(n=n[1])&&n.length&&(r.length&&(n+=" ("+r+")"),e[n]={begin:i,end:a}),""})),e},callStore,check,setScript,base,wS,mask,attrReg,checkSec,attr,l;this.WIKI=(wS=wikiSigns,mask=function(e){return e.replace(/([\*\+\-\|\/\\\(\)\{\}\[\]])/g,"\\$1")},attrReg=function(e,t,n){return e=mask(e),new RegExp(e+(t||"")+"(.*?[^\\\\])"+(n||e),"g")},checkSec=new RegExp("\n["+mask([wS.engine,wS.header,wS.number,wS.indent,wS.define,wS.table,wS.block,wS.explain,wS.inform].join(""))+"]","m"),attr=[[attrReg(wS.engine,"",wS.engineEnd),""],[attrReg(wS.bold),"<strong>$1</strong>"],[attrReg(wS.italic),"<em>$1</em>"],[attrReg(wS.under),"<u>$1</u>"],[attrReg(wS.strike),'<span class="'+cssNS.strike+'">$1</span>'],[attrReg(wS.quote),"<q>$1</q>"],[attrReg(wS.sup),"<sup>$1</sup>"],[attrReg(wS.sub),"<sub>$1</sub>"],[attrReg(wS.kbd),"<kbd>$1</kbd>"],[attrReg(wS.typ,"([^s]+)"),function(e,t,n){return'<span class="'+cssNS[t]+'">'+n+"</span>"}],[new RegExp(mask(wS.link)+"(.*?)"+mask(wS.linkEnd),"g"),function(e,t){var n=t.match(/^extern /),i="<a ";return n&&(t=t.slice(n[0].length),i+='class="'+cssNS.extern+'" target="_blank" '),n=-1==(n=t.indexOf(" "))?t.length:n,i+'href="'+t.slice(0,n)+'">'+t.slice(n)+"</a>"}],[new RegExp("(^|\n)"+mask(wS.bullet),"g"),"•"]],{mask:mask,regs:{findEngine:function(){return new RegExp(mask(wS.engine)+"\\s*([^\\s=\\}\\n]+)\\s*(=)?\\s*([\\s\\S]*?)"+mask(wS.engineEnd),"img")}},clean:function(e){return e.replace(/\r/gm,"").replace(/\/\*[\s\S]*?\*\//gm,"")},toHTML:function(e){checkSec.test(e)&&!useLib.WIKI.open&&console.warn('useLib hint: to parse a given string it would be nessesary to load the WIKI-Part!\n"'+e+'"');for(var t=0;t<attr.length;t++)e=e.replace(attr[t][0],attr[t][1]);return(e=e.split(/\n\n*/)).length>1?"<p>"+e.join("</p><p>")+"</p>":e[0]}}),DOM.delayRemove=delayRemove,useLibData=useLibData||{size:2,explain:0,design:0,feeder:0,show:1,msghold:0,sound:0,seminar:1,hambuger:DOM.isTouch?1:0},call.uLinit("setMinimizer",(function(e){$CN.toggle($P(e),cssNS.minimized),$P(e).id==cssNS.fastfeeder&&useLib.call.setFastfeeder()})),call.uLinit("saveAs",(function(e,t){if(t.length){var n=D.createElement("a");n.href="data:"==t.slice(0,5)?t:"data:text/plain;charset=utf-8,"+encodeURIComponent(t),n.download=e,D.body.appendChild(n),n.click(),setTimeout((function(){DOM.removeNode(n)}),0)}return!1})),call.uLinit("drop",{init:function(e){W.File&&W.FileReader&&W.FileList&&W.Blob&&($A(e,"ondragover","useLib.call.drop.ondragover(event)"),$A(e,"ondrop","useLib.call.drop.ondrop(event)"),$E(D.body,"dragover",this.onprevent),$E(D.body,"drop",this.onprevent))},onprevent:function(e){return e.preventDefault(),!1},ondragover:function(e){return e.stopPropagation(),e.preventDefault(),e.dataTransfer.dropEffect="copy",!1},ondrop:function(e,t){if(e.stopPropagation(),e.preventDefault(),t||e.dataTransfer.files.length){var n=t||e.dataTransfer.files,i=e.currentTarget,a=$A(i,"accept"),r=!1;a=!!a&&new RegExp(a.replace(/\*/g,"").replace(/,/g,"|")),n.length&&"file"==i.type&&delayRemove($P(i),cssNS.success,2);for(var o,s=0,l=[];n&&s<n.length;s++)!a||a.test(n[s].type)?(o=n[s].type.match(/^(image|text|audio|video)\/(.+)/i)||n[s].type,o=Array.isArray(o)?"text"==o[1]?o[2]:o[1]:o.replace(/application\//i,""),"function"==typeof call.drop[o]&&(l[s]=new FileReader,l[s].onload=function(e,t){return function(e){call.drop[o](e.currentTarget.result,i,t)||dialog.setMsg("error","dataError",i,5e3),!r&&i&&"file"==i.type&&(i.value=t,setFocus(i),r=!0)}}(0,n[s].name),/image|audio|video/.test(o)?l[s].readAsDataURL(n[s]):l[s].readAsText(n[s],"UTF-8"))):dialog.setMsg("error",filename2Msg("fileFormat",n[s].name),0,4e3)}else if(e.dataTransfer.items.length){n=e.dataTransfer.items[0];call.drop[n.type]&&n.getAsString(call.drop[n.type])}},image:function(e,t,n){return!!t.src&&(t.src=e,!0)},json:function(e,t,n){return setJSONValues(JSON.parse(e))},calendar:function(e,t,n){return metaReaction.calendar.addBlocked=analyseICAL({},e),dialog.setMsg("success",filename2Msg("fileImport",n),0,3500),!0},css:function(e,t){if(t=$("uLdraggedDesign"),activeDesignLink)return t||(t=$CE(["style",{id:"uLdraggedDesign",type:"text/css",title:"normal",charset:"utf-8"}]),D.head.appendChild(t)),t&&(activeDesignLink.sheet.disabled=!0,t.innerHTML=e,setDesign(t,!1)),!0;if(t=$("uLstandSheet")){var n=t.innerHTML;return t.innerHTML=e.replace(/@import\s+[^;]+?\/useLib\.css[^;]+;/,""),setDesign(t,n),!0}return!1}}),call.uLinit("dynList",function(){var e=!1,t=function(e){DOM.removeNode($P(e,2))},n=function(e,t){var n=e.cloneNode(!0),i=$Q(n,"div."+cssNS.hasCover);$A(n,"id",-1);for(var a=0;a<i.length;a++)i[a].className="",$CN.remove(i[a].children[1],cssNS.covered),DOM.removeNode(i[a].children[2]);return n.innerHTML=function(e){var n=e.innerHTML,i=new RegExp('("|>|:|\\.)'+(n.match(/id="((\.?[\w-]+(\[\d+\])?)+)_choice"/)||[0,""])[1].replace(/(\]|\[)/g,"\\$1")+'(\\.|\\n*<|"|_)',"g"),a=[],r=0;for(n.replace(/\sid="(uL[\w-]+)_\d+?"/g,(function(e,t){return a.indexOf(t)<0&&a.push(t),e}));r<a.length;n=n.replace(new RegExp("((\\s(for|id|data-ul)=\")|,')"+a[r++],"g"),"$1uL_"+counter++));return n.replace(i,"$1"+t+"$2")}(n),n},a=function(e,t,i,a){DOM.removeNode($("uLclearer"));var r=n(e,i),o=1==a&&$CN.contains($P(e),cssNS.top)?"first":"last",s=$P(e)[o+"ElementChild"];return function(e,t){e=$Q(e,"input[name]"),t=$Q(t,"input[name]");for(var n,i=0;i<e.length;i++)(n=getFormDef(e[i]).type)&&$A(t[i],"type",n)}(e,r),"first"==o?s=s.nextElementSibling:s.previousElementSibling.innerHTML.indexOf(".calcIt(")>-1&&(s=s.previousElementSibling),DOM.insertBefore(s,r),1==a&&(DOM.scrollIntoView(r),DOM.delayRemove(r,cssNS.showActive,4)),r},r=function(e,t){$A($Q(e,"#"+e.id+">div.uLdynfilter",1),"data-ul-count",""+t),$A($Q(e,"#"+e.id+">div.uLdynaction",1),"data-ul-count",""+t)};return{removeNodes:function(e){if(e.length){var i=$P(e[0],2),a=$A(e[0],"data-ul-dynlist"),r=$Q(i,"fieldset>div>[name]",1);r=r.name.slice(0,r.name.lastIndexOf(".")),r=$Q(i,'fieldset>div>[name^="'+r+'"]');for(var o,s=0;s<r.length;s++)(o=getFormDef(r[s]).type)&&$A(r[s],"type",o);this.removeNodes($Q(i,"#"+ensureId(i)+'>fieldset.uLdynlist>legend>[data-ul-dynlist*="'+a.slice(a.indexOf(":"))+'."]')),i=DOM.insertBefore(i,n(i,"uLMaster"));for(s=0;s<e.length;s++)t(e[s]);e=i}return e},insertNode:a,catchRet:function(e,t){13===e.keyCode&&(e.preventDefault(),e.currentTarget.blur(),this.filterOptions(t,"filter"))},filterOptions:function(e,t,n){e=$T($P(e,3),"input",1);var i=$P(e,3),a="showAll"==n?"":e.value.trim(),o=formDef[e.form.name],s=$T($P(e,2),"select",1).value,l="filterInvers"==n||"select"==n,c=("sortup"==n||"sortdown"==n)&&[],u="showAll"==n?0:$I($A($P(e,2),"data-ul-count"));if(s="#"+ensureId(i)+'>fieldset.uLdynlist>div>[name$=".'+s+'"]',!(s=$Q(i,s)))return!1;a=c?analyseFilter(o[s[0].name].value[0],!0):a.length?analyseFilter(a):/showAll|select|invert/.test(n);for(var d,f=0;a&&f<s.length;f++)e=$P(s[f],2),"showAll"==n?e.style.removeProperty("display"):"none"!=e.style.display&&(!0===a?e.firstChild.firstChild.checked="select"==n||!e.firstChild.firstChild.checked:(d="SELECT"==s[f].tagName?s[f].options[s[f].selectedIndex].text:o[s[f].name].value[0],c?c.push({e:e,v:d}):((d=a(d))&&l||!d&&!l)&&("filter"==n||"filterInvers"==n?(e.style.display="none",u++):e.firstChild.firstChild.checked=!0)));if(c){c=c.sort((function(e,t){return"sortup"==n?a(e.v,t.v):-a(e.v,t.v)}));for(f=1;f<c.length;f++)DOM.insertAfter(c[f-1].e,c[f].e)}return r(i,u),!1},scroll:function(t,n){t.preventDefault(),t.stopPropagation(),"dblclick"==t.type?(clearTimeout(e),e=!1,$CN.contains(n,cssNS.dynlist)?n=$Q($P(n,2),"input",1):(n=$P(n,3).lastChild.children,n=$Q(n[n.length-1],"select",1)),DOM.scrollIntoView(n),setTimeout((function(){setFocus(n)}),500)):"click"==t.type&&(e=setTimeout((function(){e&&(n.firstChild.checked=!n.firstChild.checked),e=!1}),400))},action:function(e,n,i,o,s){var l,c=e.currentTarget||!1,u=c?$P(c,2):e,d="#"+ensureId(u)+'>fieldset>legend>input[id$="_choice"]';if(i||(e.stopPropagation(),l=c.options?c.value:c.previousSibling?c.previousSibling.value:"xxx",i=(i=lang.dynActions[0].indexOf(l))>-1?langConf.en.dynActions[0][i]:langConf.en.dynActions[1][lang.dynActions[1].indexOf(l.replace(/\s\(\d+\)/,""))],i+="delete"==i?"List":""),l="add"==i||"delete"==i?$P(c).firstChild.firstChild:"up"==i?$P(c).previousSibling:$Q(u,d+("fold in,fold out,show,invert,clear,resize,init".indexOf(i)>-1?"":":checked")),-1=="delete,add,up".indexOf(i)&&!l.length&&c)d=c.options?c:c.previousSibling,dialog.setMsg("error","dynMinSelect",0,4500),delayRemove(d,cssNS.keyError,1);else{switch(i){case"delete":l=[l];case"confirm":case"deleteList":if(function(e){l.length&&$Q(u,d).length>l.length?e?dialog.confirm("confirmMsg",(function(e){!0===e&&call.dynList.action(u,n,"confirm")})):(d=[],p(t,"values")):(d=c.options?c:c.previousSibling,dialog.setMsg("error","noneLeftError",d,4500),e=!0);return e}("confirm"!=i&&(0===useLibData.explain||c.options)))return!1;break;case"resize":case"getjson":case"export":d=[],p(null,"values");break;case"hide":d=[],p(m,"none");break;case"show":d=[],p(m,"");break;case"fold in":d=[],p(h,"remove");break;case"fold out":d=[],p(h,"add");break;case"invert":d=[],p(v,!1);break;case"clear":d=[],p(v,!0)}switch(i){case"getjson":return getJSONValues(d);case"add":var f=l.id.slice(0,-7),g=f.lastIndexOf(".");f=g>-1?[f.slice(0,g+1),f.slice(g+1)]:["",f],$CN.contains(u,"dynamiclist")?dialog.prompt("dynNameChoise",(function(e){!1!==e&&($Q(u,'[id="'+f[0]+e+'_choice"]',1)?dialog.setMsg("error","doubleName",0,4500):e.length&&(S(a($P(l,2),0,f[0]+e,1)),call.dynList.action(u,n,"resize",f[1],e)))}),"","^[a-zA-Z0-9_-]{3,}$"):(g=f[1].replace(/\d+\]$/,zeroInt(function(e){for(var t=0,n=[];t<e.length;e[t++].id.replace(/\[(\d+)\]_choice$/,(function(e,t){n=Math.max(n,$I(t))})));return n+1}($Q(u,d)),5)+"]"),S(a($P(l,2),0,f[0]+g,1)),this.action(u,n,"resize",f[1],g));break;case"delete":case"deleteList":case"confirm":l[0].checked=!0,(l=u.getAttribute("ondelete"))&&uLeval(l,n,getJSONValues(d)),this.action(u,n,"resize");break;case"up":for(;l&&1!=l.nodeType;)l=l.previousSibling;DOM.insertBefore(l,$P(c)),D.body.scrollBy({left:0,behavior:"smooth",top:DOM.getRect($P(c)).y-DOM.getRect(l).y});break;case"init":case"resize":if($CN[l.length<conf.filterLimit?"add":"remove"]($Q(u,"."+cssNS.dynfilter,1),cssNS.hide),"init"==i)break;case"export":(l=u.getAttribute("export"==i?"onexport":"onresize"))?uLeval(l,n,getJSONValues(d),o||!1,s||!1):"export"==i&&call.saveAs(n+".json",JSON.stringify(getJSONValues(d)).replace(/([\}\]]*\})/g,"$1\n"));break;case"hide":d=d.length+$I($A($Q(u,"div.uLdynfilter",1),"data-ul-count"));case"show":r(u,"hide"===i?d:0)}}return!1;function p(e,t){for(var n=0;n<l.length;n++)"block"!==t&&e!=m&&"none"===$P(l[n],2).style.display||("values"==t?d=d.concat(getAllValues([].slice.call($Q(u.form,'[name^="'+l[n].id.slice(0,-7)+'"]')),u.form.name)):d.push(l[n]),e&&e(l[n],t))}function m(e,t){"none"===t?($P(e,2).style.display=t,e.checked=!1):$P(e,2).style.removeProperty("display")}function h(e,t){$CN[t]($T($P(e,2),"fieldset",1),cssNS.open)}function v(e,t){e.checked=!t&&!e.checked}function S(e){for(var t=0,n=$Q(e,"[name]");t<n.length;t++)initViaHTML(n[t]),initElement(n[t]),dispatchEvent(n[t],"change")}},getCalcValue:function(e){var t=getFormDef(e).type,n=e.name.replace(/\[\d+\](\.\w+)$/g,"[]$1"),i=$P(e,3),a=[];if(t){t=conf.multiCalc[t]||1,n=(e=$Q(i,'[name^="'+n+'"]',1)).name;for(var r=1;r<t;r++)a.push(e.value||""),e=$Q(i,'[name^="'+n+"_"+r+'_"]',1)}return a.push(t&&e?e.value:""),a},getListValues:function(e,t=!1,n=!1){var a=!!e&&e.name.slice(0,e.name.lastIndexOf("[")),r=[];if(t=t?"]."+t:!!e&&e.name.slice(e.name.lastIndexOf("]")),a&&t)for(e=$Q($P(e,3),'fieldset>div>[name^="'+a+'"][name$="'+t+'"]'),i=0;i<e.length;i++)n?e[i].value=n[i]||"":r.push(e[i].value||"");return r},setListValues:this.getListValues,getValue:function(e,t){var n=!!e&&e.name.slice(0,e.name.lastIndexOf(".")+1);return!!(e=n?D.getElementsByName(n+t)[0]:n)&&("checkbox"==e.type||"radio"==e.type?!!e.checked&&e.value:e.value)},setValue:function(e,t,n){var i=!!e&&e.name.slice(0,e.name.lastIndexOf(".")+1);return(e=i?D.getElementsByName(i+t)[0]:i)&&("checkbox"==e.type||"radio"==e.type?e.checked=!!e.value:e.value=n.toString()),e},setParentValue:function(e,t,n){e=$P(e,4);var i=$Q(e,"[name]",1);i&&(t=i.name.slice(0,i.name.lastIndexOf(".")+1)+t,(i=$Q(e,'[name="'+t+'"]',1))&&setTimeout((function(){i.value=n}),0))},setChildValue:function(e,t,n){(e=$Q($P(e,3).lastElementChild,'fieldset>div>[name$="'+t+'"]',1))&&setTimeout((function(){e.value=n}),0)},calcIt:function(e,t,n){var i,a=!!t&&t.name.slice(0,t.name.lastIndexOf("[")),r=r?"]."+r:!!t&&t.name.slice(t.name.lastIndexOf("]")),o=conf.multiCalc[getFormDef(t).type]||1,s=[];if(a&&r){if(t=$Q($P(t,3),'fieldset>div>[name^="'+a+'"][name$="'+r+'"]'),i=n.name.match(/\.(\w+)$/)[1],!t.length)return;if("count"===i)n.value=t.length;else for(var l,c=0;c<o;c++){l=c>0?"_"+c+"_":"";for(var u,d=0,f=(s=0,[]);d<t.length;d++)switch(u=getFormDef(t[d]),g=parseFloat(u["value"+l][0])||0,i){case"min":s=min(s,g);break;case"max":s=max(s,g);break;case"deviation":f.push(g);default:s+=g}if("average"===i)s=(s/t.length).toFixed(2);else if("deviation"===i){s/=t.length;d=0;for(var g=0;d<f.length;d++)g+=(f[d]-s)*(f[d]-s);s=Math.sqrt(g/(f.length-1)).toFixed(2)}else s="number"==u.type?Math.round(s):s.toFixed(2);setTimeout(function(e,t){return function(){e.value=t}}(0==c?n:D.getElementsByName(n.name+l)[0],""+(s||"")),0)}}}}}()),lang=$A($T(D,"html",1),"lang")||navigator.language.slice(0,5).toLowerCase(),lang=(l=lang,conf.country=l.slice(-2).toUpperCase(),l=l.slice(0,2),conf.lang=langConf[l]?l:"en",langConf[conf.lang]),"reversed"in D.createElement("ol")||alert(lang.supportError);var dialog=function(){var e=function(e){return lang[e]?["span",{}].concat(getStruct.header(lang[e],1,0,1)):typeCheck("Array",e)?e:["span",{IH:e.match(/<\/(code|div|span|p|h\d)>/i)?e:useLib.WIKI.toHTML(e)}]},t=function(e){$S(e).width=min(40,max(15,4+e.innerHTML.length/1.41*.45))+"em"},n=function(e){return"uL_"+(lang[e]?e:counter++)},i=function(e,t){var n=-1;if(t||!$CN.contains($("uLmsghold"),cssNS.locked))for(e=!!e&&(e.target||e);e;){if($CN.contains(e,cssNS.modal)||e.id&&e.id.indexOf("listSelect")>-1){(n=e.id.indexOf("uL__modal__"))>-1?(n=e.id.slice(0,n),useLib.call[n]&&useLib.call[n](!1),d(n,0)):DOM.removeNode(e);break}e=$P(e)}},a=function(e,t){if(t){var n={method:"post",action:"javascript:void(0);",noValidate:"noValidate",id:e+cssNS.modal,name:e};for(var i in n)$A(t,i,n[i]);initForm(t)}},r=[],o=[];function s(t,i,a,o,s,l){var c=n(i),f="return useLib.call.callBcks('"+c+"',"+r.length,g="draggable",p=[];return i=["div",{CN:cssNS.content,S:"width:100%;"},e(i)],"prompt"==t?(i=i.concat([["fieldset",{},["div",{S:"width:100%!important;"},["div",{S:"width:95%;"},["input",{id:"uL__prompt__",name:"uL__prompt__",type:"text",autocomplete:"off",value:o||"",pattern:s||null}]]],l?function(e){var t=["fieldset",{CN:cssNS.hidden,S:"width:100%;"}];for(var n in e.ex)t.push(getStruct.radioCheck(0,null,e.ex[n],"","uL__prompt__",n,n==e.active));return["div",{},t]}(l):null]]),p.push(getStruct.button(lang.cancel,f+",false )"),getStruct.button(lang.reset,f+",'"+(o||"")+"')"),getStruct.button(lang.store,f+",'uL__prompt__')")),r.push(a),setTimeout((function(){$("uL__prompt__").focus()}),300)):"confirm"==t?(p.push(getStruct.button(lang.refuse,f+",'refuse' )"),getStruct.button(lang.confirm,f+",'confirm' )")),r.push(a)):(p.push(getStruct.button(["OK"],f+",'confirm' )")),r.push(a||function(){})),f=cssNS.buttonRow,i=["form",{name:"uL__"+t+"__f"},i],o&&"prompt"!=t?o<0?setTimeout((function(){d(c,0)}),-1e3*o):(i.push(["div",{id:"uL__countDown__",CN:cssNS.countdown,IH:$I(o)||7}]),f+=" "+cssNS.disabled,setTimeout((function e(){var t=$("uL__countDown__"),n=(t?$I(t.innerHTML):0)-1;n>=0?(t.innerHTML=String(n),setTimeout(e,1e3)):(DOM.removeNode($("uL__countDown__")),$CN.remove($("uL__button__"),cssNS.disabled))}),1e3)):g+=" closable",i.push(["div",{id:"uL__button__",CN:f}].concat(p)),u(c,t,g,i,null,!0)}function l(t,n,i,a){var r=/^(hint|error|technical|success|server)/i,o="uL__errorList__";if(n=["div",{CN:cssNS.content},e(n)],formDef[a])for(var s=0;s<i.length;s++)n.push(l(i[s],formDef[a]));function l(e,t){for(var n in e)if(t[n]){var i=lang[e[n]]?lang[e[n]]:typeCheck("Array",e[n])?e[n]:[e[n]],a=i[0].match(r);return a=a?a[0]:"error",(i=i.slice(0))[0]=getLabelText($(t[n].id),i[0].replace(r,"").replace(/##(min|max)/g,t[n].$1||"")),(i=getStruct.header(i,2,a)[0])[0]="a",i[1].href="javascript:document.getElementById('"+(t[n].first||t[n].id)+"').focus()",["p",{id:t[n].id+"errorList",CN:cssNS[a]},i]}return null}DOM.removeNode($(o+"uL__modal__")),u(o,t,"draggable closable sizable noShield",n,null,!0)}function c(a,r,o,s){if(a&&r){var l,c=n(r),u=$CN.contains($("uLmsghold"),cssNS.locked),d="useLib.call.modalClose(this,true)";return"error"==(a=a.toLowerCase())&&o&&((l=!$CN.contains(o,"uL_ignore")&&getFormDef(o))&&cover.errorList.add(l,r),o=l?$(l.first):o,cover.keyMsg(o,"Error")),r=getLabelText(o,e(r)),r=$CE(["div",{id:c,CN:cssNS.modal+" "+(cssNS[a]||a),role:"alert",MC:d},["div",{},["div",{CN:cssNS.content},r],u?["a",{href:"javascript:"+d,CN:cssNS.locked},"OK"]:[]]]),t(r),D.body.appendChild(r),setOpenClose(r,1),DOM.setControledPos(r,o||null),r.style.zIndex=300,s&&!u&&setTimeout((function(){i($(c))}),s),c}}function u(n,i,r,o,s,l,c){if(o){var u,f="useLib.call.modal",g=(typeCheck("String",o),-1==r.indexOf("dra")?[]:["div",{CN:cssNS.dragger,MD:f+"Dragger( event )",IH:s&&s.length?"<span>"+s+"</span>":""}]),p=-1==r.indexOf("siz")?[]:["div",{CN:cssNS.sizer,MD:f+"Sizer( event )",T:"sizer"}],m=-1==r.indexOf("clo")?[]:["div",{CN:cssNS.closer,MD:f+"Close( this, false )",T:"closer"}];o=["div",{id:n+"uL__modal__",role:"dialog",CN:cssNS.modal+" "+cssNS[!i||metaReaction[i]?"form":i]},["div",{},m,p,g,["div",{CN:cssNS.scale},e(o)]]],u=D.body.appendChild($CE(o))}return d(n,!0,r.indexOf("noShield")>-1),o&&(initTooltips(u=$Q(u,"."+cssNS.scale,1)),l&&($S(u).width=!0===l?t(u):l),a(n,$T(u,"form",1)),c&&call.uLinit(n,c)),$(n+"uL__modal__")}function d(e,t,n){var i,a=$(e+"uL__modal__");a&&(setOpenClose(a,t),t?(o.push(a.id),n&&$CN.add(a,cssNS.free),DOM.setControledPos(a)):(keyControl=!1,e=D.forms[e]?e:e+cssNS.modal,o.pop(),delete useLib.call[e],delete useLib.formDef[e],setTimeout((i=a,function(){ownInput.active=!1,DOM.removeNode(i)}),2e3),setFocus($(e))))}return call.uLinit("modalDragger",(function(e){var t=$P(e.currentTarget);t=$CN.contains(t,cssNS.dragger)?$P(t):t,DOM.dragStart(e,t)})),call.uLinit("modalSizer",(function(e){DOM.sizeStart(e,$Q($P(e.currentTarget),"."+cssNS.scale,1))})),call.uLinit("modalClose",i),call.uLinit("callBcks",(function(e,t,n){if("confirm"!=n&&"refuse"!=n||!r[t])if(!1!==n){if("uL__prompt__"!=n)return $("uL__prompt__").value=n,!1;var i=$(n).value;i=i.length?i.trim():"";for(var a=0,o=$(n).form[n]||[];i.length&&a<o.length;a++)if(o[a].checked){i+="#"+o[a].value;break}r[t](i)}else r[t](n);else r[t]("confirm"==n);return r.splice(t,1),d(e,0),!1})),{setMsg:c,closeBox:i,setModal:u,closeModal:d,setErrorList:l,setError:function(e,t){$A(e,"aria-invalid","true"),$CN.add($P(e),cssNS.error),DOM.insertAfter(labels[e.id],$CE(["div",{id:e.id+"errorMsg",CN:cssNS.error,role:"alert"}].concat(getStruct.header(getLabelText(e,lang[t])))))},removeError:function(e,t){DOM.removeNode($(e.id+"errorMsg")),$CN.remove($P(e),cssNS.error),t&&delayRemove(t,cssNS.success,1),$A(e,"aria-invalid")&&(t=$(e.id+"errorList"))&&($CN.remove(t,cssNS.error),$CN.add(t,cssNS.success)),$A(e,"aria-invalid","false")},fromFormDef:function(e,t,n,i){n?l(e,t,n,i):c(e,t,null,"success"==msg.type?4500:0)},alert:function(e,t,n){return s("alert",e,t,n)},prompt:function(e,t,n,i,a){return s("prompt",e,t,n,i,a)},confirm:function(e,t,n){return s("confirm",e,t,n)},setEleDiv:function(e,t,n,i){var a=DOM.getRect(e);n=$CE(n),D.body.appendChild(n),n.id=t,$S(n).width=a.w+"px",DOM.setPos(n,a.x,a.y+(i?a.h:0))},layer:o}}(),idCover="uLcover",lastLinkPosition=!1;call.uLinit("submitForm",(function(e,t=!1){var n=$A(e,"data-ul"),i=(n&&$I(n.slice(-3)),e.id.slice(0,-cssNS.modal.length)),a=$A(e,"action"),r=$A(e,"method")||"",o=(a+"").match(/(https?):\/\/([^\/:]+)/i),s="",l={};if(n&&n.length&&metaReaction[n])e=getFormDef($(i)),!1!==metaReaction["calendar"==n?n:e.type].setValue($(i))&&(setFocus($(e.first)),dialog.closeModal(i));else if(r=t||"GET"==r.toUpperCase()?"GET":"POST",o&&"http"==o[1]&&console.warn("useLib hint: unsecure protocol of "+a+"!"),o="file:"==location.protocol||o&&o[2]!=location.hostname,dialog.closeModal("uL__errorList__"),"GET"==r)c({});else if(($A(e,"novalidate")||function(e){var t=filterElements(e),n=0,i={},a="";cover.errorList.length=0;for(var r,o,l=0;l<t.length;l++)(o=formDef[e.name][t[l].name])&&(dialog.removeError(t[l],null),r=getSelectionAttr(t[l]),$CN.contains($P(t[l]),"uL_ignore")?o.ignore=!0:"checked"==r&&$CN.contains(t[l],cssNS.notDone)?(i[t[l].name]||(o.id=t[l].id,cover.errorList.add(o,"choiseError"),dialog.setError(t[l],"choiseError"),i[t[l].name]=!0),$CN.add(t[l],cssNS.error)):"value"==r?c(t[l],o):o.required&&o.required.uLall&&!(s=getEleValue(t[l])).length&&(dialog.setError($(o.id),"requiredError"),cover.errorList.add(o,"requiredError"))),n=cover.errorList.length;cover.errorList.length&&dialog.setErrorList("error","errorMsg",cover.errorList,e.name);return cover.errorList.length=0,!n;function c(e,t){var i,r="",o=t.type.indexOf("password")<0;function s(){return a=r,"password"==t.type&&t.pwQuality<t.min?"qualityError":"password"!=t.type&&a!=r&&"repeatError"}o&&t.subs?(r=cover.getValue(t,t.type,conf.inputIsLocal?"local":"norm",!0),cover.errorList.length==n&&(activeOnChange=!1,e.value=r,activeOnChange=!0)):r=o?String(e.value):t.value[0],cover.errorList.length==n&&(i=(i=!r.length||r.length&&t.hasEmpty)&&t.required?"requiredError":i||!t.regexp||t.regexp.test(r)?!o&&s():"formatError")&&(cover.errorList.add(t,i),dialog.setError($(t.id),i))}}(e))&&(s=getAllValues("",e.name))){if(!s.length&&!/password/i.test(e.name))return dialog.setMsg("hint","noDataMsg",0,4500),!1;if(l=s.length?getJSONValues(s,e.name):"",!conf.taskSupport||!new RegExp(conf.tasksteps[1]).test(JSON.stringify(l.tasks)))return c(l);dialog.confirm("taskCheck",(function(e){!0===e&&c(l)}))}return!1;function c(e){var t="useLib hint: couldn't submit %%, because ".replace("%%",a||"");if(useLib.call[i])return useLib.call[i](e),dialog.closeModal(i),!1;if(conf.testSubmitOnly||conf.dataManagePath&&!a)return conf.testSubmitOnly||console.warn(t+"problem in action path!"),dialog.alert("="+lang.testSubmitOnly[0]+"\n\n"+JSON.stringify(e,null,2)),!1;if(!o&&!n||a.indexOf("javascript:")>-1)return!0;if(n&&"SHA"==n.slice(-3)){if(n=n.slice(0,-3),useLib.security)return useLib.security["CORS"==n?"submitCORS":"submitJSONCSS"](a,u,r,e,"POST",!0),!1;console.warn(t+"useLib.security is missing!")}else e&&(conf.dataManagePath||"JSONCSS"==n)?e="?uL="+encodeURIComponent(escapeUnicode(JSON.stringify({uL_path:a,uL_verb:r,uL_timestamp:Math.floor((new Date).getTime()/1e3),uL_json:e||null})))+"&lg="+conf.lang:e&&(e=function(e){for(var t={},n="",i=0;i<e.length;i++)e[i].tasks&&(t[e[i].name]=e[i].tasks),n+="&"+e[i].name+"="+(e[i].value.join?e[i].value.join("&"+e[i].name+"="):e[i].value);return t=JSON.stringify(t),"?"+encodeURIComponent(escapeUnicode(n.slice(1)+(2==t.length?"":"&uLtask="+t)))}(e));return o||"AJAX"!=n?"JSONCSS"==n?loadJSONCSS(a+(/\.css($|\?)/i.test(a)?"":".css")+e,u,4500):console.warn(t):ajax(conf.dataManagePath?conf.dataManagePath+e:a+e,u,"JSON",2500,!0),!1}function u(e){var t=/^20\d/.test(e.code)?"success":"error";e.msg&&dialog.setMsg(t,lang[e.msg]||e.msg,0,7500),"success"==t&&e.data&&setJSONValues(e.data)}})),call.uLinit("resetForm",(function(e){return"calendar"==$A(e,"data-ul")?metaReaction.calendar.getValue($(e.id.slice(0,-cssNS.modal.length))):resetElements(e),!1})),call.uLinit("closeForm",(function(e){return useLib.call[e.name]&&useLib.call[e.name](!1),dialog.closeModal(e.id.slice(0,-cssNS.modal.length)),!1})),call.uLinit("clearForm",(function(e){var t=formDef[e.name];for(var n in t){t[n].value=t[n].resetValue=[];for(var i,a=$Q(e,'[name="'+n+'"]'),r=0;r<a.length;r++)"selected"==(i=getSelectionAttr(a[r]))?setEleValue(a[r],[]):a[r][i]="value"==i&&"",t[n].defaultValue&&setEleValue(a[r],t[n].defaultValue)}return!1})),call.uLinit("checkWikiLink",(function(e){var t=e.currentTarget,n=($A(t,"href")||"").split("#"),i=!0;function a(){n[1]&&n[1].length&&setTimeout((function(){DOM.scrollIntoView($Q(D,"[name="+n[1]+"]",1),0,1)}),1e3)}function r(e){var t,i=D.getElementById(cssNS.designer),a=openPopup((t="",e=useLib.WIKI.regs.clean(e).replace(useLib.WIKI.regs.findEngine(),(function(e,n,i,a){return i=!!i&&"="==i,(a=a.trim()).length&&(t+="title"==n?"\n<title>"+a+"</title>":"\n"+getHTMLTag("meta",'name="'+n+'" content="'+a+'"')),""})),t+getHTMLTag("link",'id="uLstandSheet" title="normal"',"",conf.designDefs[i?i.options[i.selectedIndex].text:conf.designDefault].path)+getHTMLTag("script",'id="uLuseLibConf"',"",conf.useLibPath+"useLibConf.js")+getHTMLTag("script",'id="uLuseLib"',"",conf.useLibPath+"useLib.min.js")+getHTMLTag("script",'id="uLwiki"',"",conf.useLibPath+"uLwiki.js")+getHTMLTag("script",'id="uLlocal"','useLib.conf.userSupport = "sizer explainer designer";')),'<div class="'+cssNS.layout+" "+cssNS.landmark+'">'+useLib.getContainer("main",e).outerHTML+'<div class="'+cssNS.design+'"><span><span><span><span><span></span></span></span></span></span></div></div>\n');extern[n[0]]=e,n[1]&&a.document&&(a=a.document.getElementsByName(n[1]))&&a[0].focus()}!n[0].length&&n[1]&&n[1].length?(lastLinkPosition=t,a()):(t=$Q(D,'a[href*="'+n[0].replace(/.txt/i,".html")+'"]',1))?(t.click(),a()):(t=n[0].match(/section([\d\.]+)/i))?(t=$("uLmainnavi"+t[1]))?(t.click(),a()):i=!1:/\.txt$/i.test(n[0])&&(-1==n[0].indexOf("/")||n[0].indexOf("wiki")>-1)?extern[n[0]]?extern[n[0]]<0||r(extern[n[0]]):useLib.ajax(n[0],r,"txt",3e3):i=!1,i&&(e.preventDefault(),e.stopPropagation())}));var subValue=function(e,t){return(t=e.getId(t))?$I($(t).value):0},setFree=function(e,t,n){$(e+"free-"+t).innerHTML="<span>"+n+"</span>"},getCurrencySign=function(e){return{EUR:"€",USD:"$",GBP:"£",JPY:"¥"}[e=e.toUpperCase()]||e},patterns={url:/^(https?:\/\/)?(www\.)?[-a-zA-Z0-9@:%_\+.~#?&=]{2,256}\.[a-z]{2,4}\b(\/[-a-zA-Z0-9@:%_\+.~#?&=]*)?$/i,email:/^[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@([a-z0-9]([a-z0-9-]*[a-z0-9])?\.)+[a-z0-9]([a-z0-9-]*[a-z0-9])?$/i},metaReaction={days:{doButton:function(e,t){getFormDef(t).fixed=$CN.toggle(e.currentTarget,cssNS.locked)}},toggle:{doButton:function(e,t){var n=getFormDef(t);n.toggle=$CN.toggle(e.currentTarget,cssNS.locked)?"P":"",n.control&&n.control("toggle",n.toggle)},setValue:function(e,t){var n=e.toggle,i=function(t){return subValue(e,t+"INT")+"."+subValue(e,t+"FIX")}(n);function a(e,t,n){return isNaN(t)?t(e,"P"!=n):"P"==n?e*t:0==t?0:e/t}0==t?i=[0,0]:(1!=t.base&&(i=a(i,t.base,"P"==n?"":"P")),i=a(i,t.convers,n),i=String(i.toFixed(2)).split(".")),e.value_1_=[i.join(".")],n="P"==n?"":"P",$(e.subs[n+"INT"].id).value=i[0],$(e.subs[n+"FIX"].id).value=i[1]},setStatus:function(e){function t(t,n){setStatus($(e.subs[t+"INT"].id),"disabled",n),setStatus($(e.subs[t+"FIX"].id),"disabled",n)}$CN.contains($(e.id),cssNS.disabled)||($CN["P"!=e.toggle?"remove":"add"]($Q($P($(e.first)),"button."+cssNS.toggle,1),cssNS.locked),t("","P"==e.toggle),t("P","P"!=e.toggle),setFocus($(e.subs[e.toggle+"INT"].id)))}},fon:{init:function(e,t){metaReaction.world.init(e,t,conf.defaults.fon),t.world=conf.country,t.getSub(t.first).check.doReaction=metaReaction.world.doReaction(e,t)}},email:{doReaction:function(e,t){return{onblur:function(n,i){i&&!patterns[t.type].test(i)&&dialog.setMsg("error","formatError",e,5500)}}}},title:{init:function(e,t){setEleValue($(t.first),t.value)},setValue:function(e,t){setEleValue($(getFormDef(e).first),t)}},timestamp:{init:function(e,t){function n(){$(t.first).value=$D.timestamp(1e3*e.value)}setDisabled(t,!0),e.value&&""!=e.value||(e.value=~(new Date).getTime()),n(),e.onchange=function(){n()}}}},pwImg,eRepeat,pwStored,pwRepeat,getMin,log2,checkRate,calcRate,getAllUnitList,calcUnit,calcVat,regList,setRegs,defaultIban,lastWorld,ibanRegex,initCover,msgList,setExpand,sL,sShow,multiList,tempType,lastUrl,lastValue,findValue,setValue,getValue,setAllValues;metaReaction.fixpin=metaReaction.days,metaReaction.url=metaReaction.email,metaReaction.clock=function(){var e={setTimeout:function(t,n){setTimeout((function(){t.clockStop||e[n](t,n)}),$I(n)?n:1e3)},0:function(n,i){t(n,new Date),e.setTimeout(n,i)},1:function(e,t){e.alarmTime&&clearTimeout(e.alarmTime),t=$D().getTime()+e[t]-e.startTime,e.alarmTime=setTimeout((function(){n(e)}),t<0?t+864e5:t),$CN.add($(e.subs.PSELECT.id),cssNS.clock)},2:function(n,i){t(n,(new Date).getTime()-n.startTime+n[i]),e.setTimeout(n,i)},3:function(i,a){var r=i.startTime-(new Date).getTime()+i[a];t(i,r),r<=0?n(i):e.setTimeout(i,a)}},t=function(e,t){var n=!!t.getTime;function i(t,n){(t=$(e.subs[t].id))&&(t.value=n)}i("PHOURS",$I(n?t.getHours():t/36e5)),i("PMINUTES",zeroInt(n?t.getMinutes():t/6e4,2)),i("PSECONDS",zeroInt(n?t.getSeconds():t/1e3,2))},n=function(e){DOM.scrollIntoView($(e.first),1.5),function t(n){sound(conf.sounds.alarm),delayRemove($P($(e.first)),cssNS.keyError,1),n>0&&setTimeout((function(){t(--n)}),3e3)}(3)},i=function(e,t){for(var n in e.subs)setStatus($(e.subs[n].id),"disabled",t)};return{init:function(n,a){n=$(a.subs.PSELECT.id),$CN.add($P(n),"uL_ignore"),n.selectedIndex=0,i(a,!0),e[0](a,0),$E(n,"OC",(function(){var e=this,n=e.selectedIndex;a.clockStop=!0,$CN.add(e.nextSibling,cssNS.locked),t(a,a[e.options[n].value]||(2==n||3==n?0:new Date)),D.activeElement.blur()}))},doButton:function(t,n){var a=getFormDef(n),r=$(a.subs.PSELECT.id),o=$CN.toggle(t.currentTarget,cssNS.locked);i(a,!o),a.clockStop=o,r=r.selectedIndex,o?1==r&&($CN.remove($(a.subs.PSELECT.id),cssNS.clock),a.alarmTime&&clearTimeout(a.alarmTime)):0==r?e[0](a,r):4==r?a.clockStop=!0:(a[r]=function(e){return 36e5*$I($(e.subs.PHOURS.id).value)+6e4*$I($(e.subs.PMINUTES.id).value)+1e3*$I($(e.subs.PSECONDS.id).value)}(a),a.startTime=(new Date).getTime(),e[r](a,r))}}}(),metaReaction.password=(pwImg=new Image,eRepeat=!1,pwStored="",pwRepeat="",getMin=function(e){return useLib.security?useLib.security.minPW||80:e.min||80},log2=Math.log2||function(e){return Math.log(e)/Math.LN2},{init:function(e,t){var n,i=cssNS.indicatorBar,a=$(t.id+"free-0");for(var r in t.required&&!/\(min.\s/.test(labels[e.id].innerHTML)&&(labels[e.id].innerHTML+=" (min. "+getMin(t)+"%)"),$A(e,"size",325),a.previousSibling.onclick=function(){var e="";for(var n in t.subs)e+=$(t.subs[n].id).value;return dialog.prompt("viewPassword",(function(e){!1!==e&&t.subs.PASSWORD.check.doReaction.onchange(0,e)}),e,"[\\w\\W]{0,128}"),!1},t.subs)n=$(t.subs[r].id),$A(n,"onmousedown",-1),$A(n,"type","password");if(t.subs[r].check.maxCount=300,"password"==t.type?$CN.contains($(t.id+"free-2"),cssNS.password)||(setFree(t.id,1,"0%"),$(t.id+"free-2").className+=" "+cssNS.password,$P(a,2).appendChild($CE(["span",{CN:i}])),$P(a,2).appendChild($CE(["span",{CN:i+" "+cssNS.password,id:i}]))):(t.regexp=/ident/,eRepeat=t),!conf.puzzlePassword||useLib.password&&(W.URL||W.webkitURL)&&W.CanvasRenderingContext2D){if(useLib.password){var o=$LS("pwImgData");o&&(pwImg.src=o)}}else delete this.getContent,this.doButton=function(){dialog.setMsg("hint","noPuzzlePassword",$(t.id),4500)}},getContent:function(e,t){if(pw=useLib.password)return pw.getContent(getStruct,(function(t){var n=$(e.id+cssNS.modal);n.innerHTML=$CE(["span",{}].concat(t)).innerHTML,initForm(n)}),(function(e,t,n){lang.pwMsg=e,dialog.setMsg(n||"hint","pwMsg",t,4500)}),(function(t,n){var i=metaReaction.password.doReaction(e,getFormDef(e)),a=useLib.security.getPasswordHash(n);$LS("pwImgData",t),pwImg.src=t,i.onchange(!1,n),e.value=a,getFormDef(e).value=[a],dialog.closeModal(e.id,a)}),!!pwImg.src.length&&pwImg)},doReaction:function(e,t){return{onchange:function(n,i){var a="";for(var r in n?n.value=i:a=i,t.subs)n?a+=$(t.subs[r].id).value:($(t.subs[r].id).value=i.slice(0,5),i=i.slice(5));return internChange=!0,"password"==t.type?(pwStored=a,eRepeat.required=!!a.length,function(e){e=function(e){var t=[/[a-z]/g,/[A-Z]/g,/[_\.\*+:#!?%\|@\{\}\[\]\(\);=\“&$\\/,-]/g,/[0-9]/g,/[\u00C0-\u017F]/g],n=e,i=0;if(!e.length)return 0;for(var a=0;a<t.length;a++)n.match(t[a])&&(i+=a<3?26:10,e=e.replace(t[a],""));return e.length&&(i+=10),e=function(e){var t='!"§$%&/()=?qwertzuiop+asdfghjkl#<yxcvbnm,.-1234567890abcdefghijklmnopqrstuvwxyz';return t+=t.split("").reverse().join(""),e=n(e.toLowerCase());function n(e){if(e.length>5)for(var i=0;i<e.length-4;i++)for(var a=0;a<=i;a++)if(t.indexOf(e.slice(i-a,e.length-a))>-1)return n(e.slice(0,Math.max(i-a,0)))+"\t"+n(e.slice(e.length-a));return e}}(e=(e=n).replace(/(.)\1\1+/g,"$1$1")),e=e.replace(/(ABE|ACH|ALL|AND|ARE|AUF|AUS|BEN|BER|BUT|CHE|CHT|DAS|DEN|DER|DIE|EIN|EIT|END|ENT|ERA|ERE|ERS|ESE|EVE|FOR|GEN|HAD|HAT|HEN|HER|HIN|HIS|ICH|IGE|INE|ING|ION|IST|ITH|LIC|LLE|MEN|MIT|NDE|NEN|NGE|NIC|NOT|NTE|OME|OUL|OUR|REN|SCH|SEI|SEN|SHO|SIC|SIE|STE|TED|TEN|TER|THA|THE|THI|TIO|ULD|UND|UNG|VER|WAS|WIT|YOU|AL|AN|AR|AS|AT|AU|BE|CH|DA|DE|DI|EA|ED|EI|EL|EN|ER|ES|GE|HA|HE|HI|HT|IC|IE|IN|IS|IT|LE|LI|ME|ND|NE|NG|NT|ON|OR|OU|RE|SC|SE|SI|ST|TE|TH|TI|TO|UN|VE|WA)/gi,"\t"),Math.min(99,parseInt(80/65*log2(i)*e.length))}(e)||0,t.pwQuality=e,setFree(t.id,1,e+"%"),$(cssNS.indicatorBar).style.width=e+"%",$CN[e>=getMin(t)?"add":"remove"]($(cssNS.indicatorBar),cssNS.success)}(a)):(pwRepeat=a,e.value=pwRepeat==pwStored?"ident":""),t.value=[e.value],internChange=!1,n.value},onblur:function(){if(internChange=!0,"password"==t.type){var n=conf.hashPassword;n&&useLib.security?i(useLib.security.getPasswordHash(pwStored+n)):n?function(e,t){if(!W.crypto||!W.crypto.subtle)return t(e);crypto.subtle.digest("SHA-512",new TextEncoder("utf-8").encode(e)).then((function(e){e=new DataView(e);for(var n=0,i="";n<e.byteLength;i+=String.fromCharCode(e.getUint8(n++)));t(i)}))}(pwStored+n,i):i(pwStored),eRepeat&&pwRepeat.length&&a($(eRepeat.first))}else a(),i(pwRepeat==pwStored?"ident":"");function i(n){e.value=n,t.value=[n]}function a(t){pwStored.length&&pwRepeat!=pwStored&&setTimeout((function(){"password"!=D.activeElement.type&&(cover.keyMsg(e,"Error"),dialog.setMsg("error","repeatError",null,5e3))}),400)}internChange=!1}}}}),metaReaction.passwordrepeat=metaReaction.password,metaReaction.world=function(){var e=!1,t=[],n=function(e){var n=!1;return e=new RegExp("^"+e,"i"),t.some((function(t,i){return e.test(t.v)&&(n=i),!1!==n})),n||0},i=function(t,n){var i=$Q(t.nextSibling,'BUTTON[class^="'+cssNS.world+'"]',1);return i&&e&&(i.title=e[n]||""),i?$P(i):i};function a(t,n,i){var r,o,s,l=getFormDef(t),c=["region","level","language","domain","vehicle","currency","fon"].indexOf(l.type),u=l.data?$I(l.data):conf.worldIndustrialLevel,d="",f=[];if(i=i||loadJSONCSS("uLworld.json.css",(function(e){D.contains(t)&&a(t,n,e)}))){if(s=i[conf.lang]?conf.lang:"en",e=i[s].names,u)for(var g=1;g<=u;g++)for(var p in i[s].names)i.countryData[p][1]==g&&(o=h(p))&&("rotorList"==n?f.push(o):v("level",p,o));else if("rotorList"==n&&"country"==l.type)for(var p in e)f.push(h(p));else for(var m=0;m<i[s].regionOrder.length;m++)(o=h(i[s].regionOrder[m]))&&("rotorList"==n?f.push(o):v("region",i[s].regionOrder[m],o));return"rotorList"==n&&"country"!=l.type&&f.sort((function(e,t){return compare(e.v,t.v)})),"rotorList"==n?f:metaReaction.singleSelect.getContent(t,"singleSelect",f)}return i;function h(t){return!!(c<0||i.countryData[t][c].length)&&{v:"country"==l.type?e[t]:c<0?t:i.countryData[t][c],cc:t}}function v(t,n,a){d!=i.countryData[n]["region"==t?0:1]&&(d=i.countryData[n]["region"==t?0:1],r=i[s][t][d],f.push({type:"group",textContent:r})),a.v.length&&f.push({textContent:e[n],shortCut:c<0?null:("fon"==l.type?"+":"")+a.v,value:a.v+"::"+n})}}return{init:function(e,t,n){var a=i(e,t.world||conf.country);"currency"==t.type&&a?a.previousSibling.innerHTML=getCurrencySign(n):$(t.first).value=n||e.value},getValue:function(e){var t=getFormDef(e),n="input[value"+(t.subs.COUNTRY?"$":"^")+'="'+$(t.first).value+'"]';(n=$Q($(e.id+cssNS.modal),n,1))&&(n.checked=!0),metaReaction.singleSelect.getValue(e)},setValue:function(e){var t,n=getFormDef(e),i=$Q($(e.id+cssNS.modal),"input:checked",1),a=n.world;i&&(t=i.value.split("::"),n.world=t[1],t[1]!=a&&(metaReaction.world.init(e,n,n.subs.COUNTRY?t[1]:t[0]),n.control&&n.control("world",t[0]))),setFocus($(n.first))},getContent:a,doReaction:function(r,o){var s;return{init:function(i,l){l=l||loadJSONCSS("uLworld.json.css",(function(e){D.contains(i)&&s.doReaction.init(i,e)})),s=o.getSub(i.id).check,l&&(e=l[l[conf.lang]?conf.lang:"en"].names,t=a(r,"rotorList"),s.min=0,s.max=t.length-1,s.value=n(i.value))},onrotor:function(n,a,l){return e?(a=(a=$I(s.value+(l>0?-1:1)))>s.max?s.min:a<s.min?s.max:a,s.value=a,o.world=t[a].cc,i(r,o.world),t[a].v):n.value},onchange:function(i,a,r){if(a="country"==o.type?a:a.toUpperCase(),e&&a.length&&!r){var l=new RegExp("^"+a,"i"),c=[];i.value=a,s.value=d;for(var u,d=n(a);d<t.length;d++)if(u=t[d][o.subs.COUNTRY?"cc":"v"],l.test(u)&&(c.push(t[d].v+("country"==o.type?"":"::"+e[t[d].cc])),c.length>15||i.value==u)){c=[];break}c.length&&setListSelect(i.id,c)}return a}}}}}(),metaReaction.country=metaReaction.world,metaReaction.currency=(checkRate=function(e,t,n,i){return(n||i)&&(0==e.rate.convers||e.rate.base*e.rate.convers==1?(dialog.setMsg("hint",0==e.rate.convers?"noRateGiven":"noRateCalc",$(e.id),4500),$(e.subs.PINT.id).value=0,$(e.subs.PFIX.id).value=0,e.toggle="",$(e.subs.PINT.id).title=lang.noRateGiven[1],i=n=!1):t&&($(e.subs.PINT.id).title=lang.noRateCalc[1]+" "+(e.rate.base/e.rate.convers).toFixed(4)+" ("+t.date+" ECB)")),metaReaction.toggle.setStatus(e),i},calcRate=function(e,t){metaReaction.toggle.setValue(t,t.rate.base*t.rate.convers==1?0:t.rate)},{init:function(e,t){var n=(t.data||conf.defaults.currency).toUpperCase();metaReaction.world.init(e,t,n),setFree(t.id,0,getCurrencySign(n)),t.subs.FIX.check.max=t.subs.PFIX.check.max=99,t.toggle="",t.rate={base:1,convers:1},$(t.subs.PINT.id).value="",t.control=function(i,a,r){(r=r||loadJSONCSS("currency.json.css",(function(n){D.contains(e)&&t.control(i,a,n)})))&&("toggle"==i?checkRate(t,r,"P"==a):"world"==i&&r&&("EUR"!=n&&(t.rate.base=1/(r.rates[n]||1)),t.rate.convers="EUR"==a?1:parseFloat(1/r.rates[a]||0),checkRate(t,r,!1,!0)&&calcRate(0,t)))},metaReaction.toggle.setStatus(t)},setValue:metaReaction.world.setValue,doReaction:function(e,t){return{onchange:function(e,n){return e.value=n,calcRate(0,t),n}}}}),metaReaction.unit=(getAllUnitList=function(e,t,n,i){var a,r=[];if(i=i||loadJSONCSS("uLunit.json.css",(function(i){D.contains(e)&&getAllUnitList(e,t,n,i)}))){for(var o in i=i.unitData)a=i[o].header[conf.lang]||i[o].header.en,n=i[o][conf.lang]||i[o].en,r.push({textContent:n+" //("+a+")//",value:o,shortCut:i[o].sign||o});return metaReaction.singleSelect.getContent(e,"singleSelect",r)}return i},calcUnit=function(e,t,n){function i(e){return n[e]?n[e].calc:n[t.unit.name].convers[e].calc}(n=n||loadJSONCSS("uLunit.json.css",(function(n){D.contains(e)&&calcUnit(e,t,n)})))&&t.unit&&(n=n.unitData,metaReaction.toggle.setValue(t,t.unit.base!=t.unit.convers?{base:i(t.unit.base),convers:i(t.unit.convers)}:0))},{init:function(e,t,n,i){(i=i||loadJSONCSS("uLunit.json.css",(function(i){D.contains(e)&&metaReaction.unit.init(e,t,n,i)})))&&(n=n||t.data||conf.defaults.unit,t.subs.FIX.check.max=t.subs.PFIX.check.max=99,t.toggle="",t.unit={name:n,base:n,convers:n},$(t.subs.PINT.id).value="",i&&i.unitData&&setFree(t.id,0,function(e,t,n){var i=$(e.subs.PSELECT.id);if($E(i,"OC",(function(){e.unit.convers=this.options[this.selectedIndex].value,setFocus($(e.subs[e.toggle+"INT"].id)),calcUnit($(e.first),e)})),!n[t])for(var a in t=-1,n){if(-1!==t)break;for(var r in n[a].convers)if(r==e.unit.base){e.unit.name=a,t=r;break}}if(-1!==t)for(var r in a=e.unit.name,(i=i.options).length=0,i[i.length]=o(n[a],a,a==e.unit.base),n[a].convers)i[i.length]=o(n[a].convers[r],r,r==e.unit.base);return-1==t?"":n[t]?n[t].sign||t:n[a].convers[t].sign||t;function o(e,t,n){return typeCheck("Array",e.calc)&&(e.calc=new Function(e.calc[0],e.calc[1])),new Option((e.sign||t)+" : "+(e[conf.lang]||e.en),t,n,n)}}(t,n,i.unitData)),t.control=function(n,i){"toggle"==n?(t.unit.base==t.unit.convers&&(t.toggle="",dialog.setMsg("hint","noUnitCalc",e,4500)),metaReaction.toggle.setStatus(t)):"unit"==n&&(t.unit.convers=i,calcUnit(e,t))},metaReaction.toggle.setStatus(t))},setValue:function(e){var t=getFormDef(e),n=$Q($(e.id+cssNS.modal),"input:checked",1);n&&n.value!=t.unit.name&&(metaReaction.unit.init(e,t,n.value),t.control&&t.control("unit",n.value))},getValue:function(e){var t=$Q($(e.id+cssNS.modal),'input[value^="'+getFormDef(e).unit.name+'"]',1);t&&(t.checked=!0),metaReaction.singleSelect.getValue(e)},getContent:getAllUnitList,doReaction:function(e,t){return{onchange:function(n,i){return n.value=i,calcUnit(e,t),i}}}}),metaReaction.isounits=metaReaction.unit,metaReaction.vat=(calcVat=function(e,t){metaReaction.toggle.setValue(t,t.vat)},{init:function(e,t){var n=$(t.subs.SELECT.id);function i(){var a=n.value;"ownInput"!=a?(a=parseFloat(a.replace(/^[\D]*/,"").replace(/,/,".")),isNaN(a)?(dialog.setMsg("error","vatError",e,4500),t.vat.convers=1):t.vat.convers="net"==t.type?(a+100)/100:(100+a)/a,calcVat($(t.first),t)):setTimeout(i,500)}t.subs.FIX.check.max=t.subs.PFIX.check.max=99,t.toggle="",t.vat={base:1,convers:1},metaReaction.toggle.setStatus(t),t.control=function(){metaReaction.toggle.setStatus(t)},i(),$E(n,"OC",(function(){i(),setFocus($(t.subs[t.toggle+"INT"].id))}))},setValue:function(e,t){var n=getFormDef(e);calcVat($(n.first),n)},doReaction:function(e,t){return{onchange:function(e,n){return e.value=n,calcVat(0,t),n}}}}),metaReaction.net=metaReaction.vat,metaReaction.salesident=(regList={"not europe":[/[A-Z0-9]{0,15}/i,15],BE:[/\d{10,10}/i,10],BG:[/\d{9,10}/i,10],DK:[/\d{8,8}/i,8],DE:[/\d{9,9}/i,9],EE:[/\d{9,9}/i,9],FI:[/\d{8,8}/i,8],FR:[/[0-9A-Z]{2,2}\d{9,9}/i,11],EL:[/\d{9,9}/i,9],IE:[/\d[0-9A-Z]\d{5,5}[A-Z][A-I]/i,9],IT:[/\d{11,11}/i,11],HR:[/\d{11,11}/i,11],LV:[/\d{11,11}/i,11],LT:[/\d{9,9}(\d{3,3})?/i,12],LU:[/\d{8,8}/i,8],MT:[/\d{8,8}/i,8],NL:[/[0-9A-Z\*\+]{10,10}\d{2,2}/i,12],ATU:[/\d{8,8}/i,8],PL:[/\d{10,10}/i,10],PT:[/\d{9,9}/i,9],RO:[/[1-9]\d{5,9}/i,10],SE:[/\d{10,10}01/i,12],SK:[/\d{10,10}/i,10],SI:[/\d{8,8}/i,8],ES:[/[0-9A-Z]\d{7,7}[0-9A-Z]/i,9],CZ:[/\d{8,10}/i,10],HU:[/\d{8,8}/i,8],GB:[/(\d{9,9}(\d{3,3})?)|((GD|HA)\d{3,3})/i,14],CY:[/\d{8,8}[A-Z]/i,9]},setRegs=function(e,t){var n=/A/.test(regList[t][0].source);e.regexp=new RegExp("^"+t+(regList[t][0]+"").slice(1,-2)+"$"),e.subs.PATTERN.check.regexp=regList[t][0],e.subs.PATTERN.check.charRegexp="NL"==t?/[0-9A-Z\*\+]+/gi:n?/[0-9A-Z]+/gi:/[0-9]+/g,e.subs.PATTERN.check.maxCount=regList[t][1],e.subs.PATTERN.check.upper=1,$(e.subs.PATTERN.id).title=(lang.allowedChars["0-9"]+(n?lang.allowedChars["a-z"]:"")+("NL"==t?"*+  ":"")).slice(0,-2)},{init:function(e,t){var n=$(t.subs.SELECT.id),i=Object.keys(regList);$E(n,"OC",(function(){setRegs(t,this.value)})),n.innerHTML="<option>"+i.join("</option><option>")+"</option>",n.value=regList[conf.country]?conf.country:"DE",setRegs(t,n.value)}}),metaReaction.iban=(defaultIban=["c",15,"c",20,/[A-Z]{2}\d\d[A-Z0-9]{10,30}/],lastWorld=!1,ibanRegex=!1,initCover=function(e,t){for(var n in t=t||defaultIban,ibanRegex=new RegExp(t[4]),e.subs)if("IBAN"==n.slice(0,4)){var i=$(e.subs[n].id),a="IBAN"==n?"n":t["IBAN1"==n?0:2],r="IBAN"==n?2:t["IBAN1"==n?1:3];e.subs[n].check.charRegexp=new RegExp("["+("a"==a?" A-Z":"n"==a?" 0-9":" A-Z0-9")+"]+","gi"),e.subs[n].check.maxCount=r,e.subs[n].check.max=repeat("9",r),i.title=(("a"==a||"c"==a?lang.allowedChars["a-z"]:"")+("n"==a||"c"==a?lang.allowedChars["0-9"]:"")).slice(0,-2)}},msgList={},setExpand=function(e,t,n){var i,a=o(".BIC");if(a&&(n=n||function(e,t,n){var i="uLblz."+t.world.toLowerCase()+".json.css";return n=n||loadJSONCSS(i,(function(n){D.contains(e)&&setExpand(e,t,n.banks)})),extern[i]&&-2==extern[i]&&(msgList[c]||(msgList[c]=0),msgList[c]++<3&&dialog.setMsg("hint","noCountrydata",e,4500),n=-1),!(!n||n<0)&&n.banks}(e,t,!1),i=$(t.subs.IBAN1.id).value,n&&(i=n.filter((function(e){return e[0]==i})))&&i[0]&&(a.value=i[0][3],a=o(".institution")))){n=i[0][1]+"(";for(var r=0;r<i.length;r++)n+=i[r][2]+", ";a.value=n.slice(0,-2)+")"}function o(t){var n=D.getElementsByName(e.name.split(".")[0]+t);return!(!n||!n[0])&&n[0]}},{init:function(e,t,n){n=n||loadJSONCSS("uLworld.json.css",(function(n){D.contains(e)&&metaReaction.iban.init(e,t,n)})),t.world=oldWorld=conf.country,metaReaction.world.init(e,t,t.world),t.getSub(t.first).check.doReaction=metaReaction.world.doReaction(e,t),n?(initCover(t,n.countryData[t.world][7]),e.value.length&&doEvent.setInput($(t.subs.IBAN.id),e.id)):initCover(t,!1),t.control=function(e,i){initCover(t,n.countryData[i][7]),setFocus($(t.subs.IBAN.id),200)}},doReaction:function(e,t){var n;return{init:function(e){var i=loadJSONCSS("uLworld.json.css");n=t.getSub(e.id).check,i&&lastWorld!=t.world&&(lastWorld=t.world,initCover(t,i.countryData[t.world][7]))},onblur:function(i,a){var r,o=i.value.trim(),s=l(o).length;function l(e){return e.replace(/\s/g,"")}i.value=ibanRegex==defaultIban[4]||s>=n.maxCount?o:"^000000000000000000000".slice(s-n.maxCount)+o,a?(a=l(a),ibanRegex.test(a)?1!=function(e,t){for(;e.length>10;){var n=e.substring(0,10);e=n%t+e.substring(10)}return e%t}(r=((r=(r=a).toUpperCase()).slice(4)+r.slice(0,4)).replace(/[A-Z]/g,(function(e){return e.charCodeAt(0)-55})),97)?dialog.setMsg("hint","ibanCheck",e,4500,i):setExpand(e,t,!1):dialog.setMsg("error","formatError",e,5500,i)):i.id==t.subs.IBAN1.id&&$(t.subs.IBAN1.id).value.length>5&&setExpand(e,t,!1)}}}}),metaReaction.list=(sL=[],sShow=20,multiList=!1,tempType=!1,lastUrl=!1,lastValue=!1,findValue=function(e,t,n){var i,a,r=!!/\u2006$/.test(t)&&t.slice(0,-1),o=[];if(sL.length){if(r){if(t=e.value=r,n.isSelected==r)return n.value;n.isSelected=r}if(t.length&&(a=new RegExp(useLib.WIKI.mask((t.length<3?"^":"")+t).replace(/\\.|\s|-/g,"(\\\\.| |-)"),"i"),i=sL.filter((function(e,t){return(e=a.test(e))&&o.push(t),e}))).length)if(!r&&i.length<=sShow){for(var s=0;s<o.length;s++)multiList?i[s]=extern[lastUrl].list[o[s]].join("::"):i[s]+=" ";setListSelect(e.id,i)}else setListSelect(e.id,["∑ "+i.length+" > "+sShow]);else setListSelect(e.id,[])}return o[0]||0},{init:function(e,t){t.data&&t.data.length&&$CN.add($P(e),cssNS[-1==t.data.indexOf(".tmp")?"completer":"searcher"])},doReaction:function(e,t){var n;return{init:function(i,a){return t.data&&t.data.length&&(lastUrl!=t.data&&t.data.indexOf(".tmp")>-1&&lastValue&&0!==i.value.indexOf(lastValue)?(tempType=!0,lastValue=!1,delete extern[t.data],DOM.removeNode($(t.data)),t.data=t.data.replace(/&value=[^&]*/,"")+"&value="+i.value):tempType=!1,lastUrl!=t.data&&(lastUrl=t.data),n=t.getSub(i.id).check,a=a||loadJSONCSS(t.data,(function(t){D.contains(e)&&n.doReaction.init(i,t)})),a&&(sL=(multiList=typeCheck("Array",a.list[0]))?a.list.map((function(e){return e[0]})):a.list,sShow=a.show||20,n.min=0,n.max=sL.length-1,n.value=findValue(i,i.value,n),n.charRegexp=!1)),i.value},onrotor:function(e,t,i){return sL?(t=(t=$I(n.value+(i>0?-1:1)))>n.max?n.min:t<n.min?n.max:t,n.value=t,function(e){if(multiList&&extern[lastUrl].idList)for(var t=1,n=extern[lastUrl].list;t<n[0].length;t++)$(extern[lastUrl].idList[t]).value=n[e][t]}(t),sL[t]):e.value},onchange:function(e,t,i){return sL&&t.length&&!i&&(tempType&&0!==t.indexOf(lastValue)?n.doReaction.init(e,!1):n.value=findValue(e,t,n)),e.value}}}}),metaReaction.towns=function(){var e,t={},n=!1,i=function(e,n,a){var r="uLtowns."+e.toLowerCase()+".json.css";if(a=a||loadJSONCSS(r,(function(){D.contains(n)&&i(e,n,a)})),extern[r]&&-2==extern[r])t[e]||(t[e]=0),t[e]++<3&&dialog.setMsg("hint","noCountrydata",n,4500),a=-1;else if(a&&!a.postal){a.postal=Array(a.town.length),a.postal.maxCount=0;for(var o=0;o<a.town.length;o++)a.postal[a.town[o][3]]=o,a.postal.maxCount=max(a.postal.maxCount,a.town[o][1].length)}return a},a=function(e,t,n){var i=e[t].length-1;for(n.length&&(i=e[t].length&&n.length?function n(i,a,o){if(a=min(e[t].length-1,max(0,a)),o>0){var s=compare(r(e,t,a).toLowerCase(),i.toLowerCase());a=n(i,a-(s<0?-o:o),$I(o/2))}return a}(n,i,i):0);compare(r(e,t,i).toLowerCase(),n.toLowerCase())<0;)i++;return i},r=function(e,t,n){return"town"==t?e[t][n][0]:e.town[e[t][n]][1]};return{init:function(e,t){t.world=conf.country,t.doReaction=this.doReaction,t.getSub(t.first).check.doReaction=metaReaction.world.doReaction(e,t),metaReaction.world.init(e,t,t.world),t.normRegexp=!1},doReaction:function(t,o){var s,l,c=!1;return{init:function(e){var n,r=e.value;return s=o.getSub(e.id),l=s.id==o.subs.PATTERN.id?1:0,(c=i(o.world,t))?-1==c?c=!1:(s.check.value=r.length?a(c,l?"postal":"town",r):0,s.check.min=0,s.check.max=c.town.length-1,n=cover.pattern2Char(c.charRegexp[l]),s.check.charRegexp=n.charRegexp,e.title=n.chars,(e=o.subs.PATTERN.check).jump=1,e.minCount=e.maxCount=c.postal.maxCount,e.regexp=e.charRegexp=n.charRegexp):setTimeout((function(){s.check.doReaction.init(e)}),400),r},onrotor:function(t,i,a){var r=s.check;return c?(i=(i=$I(r.value+(l?-a:a>0?-1:1)))>r.max?r.min:i<r.min?r.max:i,r.value=i,function(t,i,a,r){return n=n||$(t.id),clearTimeout(e),$(t.next?t.next:t.before).value=i.town[r][a?0:1],$(t.next?t.id:t.before).title=i.town[r][2],e=setTimeout((function(){n.focus(),n=!1}),250),i.town[r][a]||""}(s,c,l,l?c.postal[i]:i)):t.value},onchange:function(e,t,n){if(c&&t.length&&!n){var i,u=l?"postal":"town",d=a(c,u,t),f=new RegExp("^"+t,"i"),g=[];for(e.value=t,s.check.value=d;d<c.town.length&&f.test(r(c,u,d));){if(i=l?c.postal[d]:d,g.push(c.town[i][1]+" "+c.town[i][0]),g.length>15){g=[];break}d++}setListSelect(o.subs["PATTERN"+(l?"":"1")].id,-1==g.indexOf($(o.subs.PATTERN.id).value+" "+$(o.subs.PATTERN1.id).value)?g:[])}else setListSelect(o.subs.PATTERN.id,[]);return t}}}}}(),metaReaction.period=(setValue=function(e,t,n,i){function a(n,i,a,r){return!!(n=$(e[t].getId(n+(a?"S":""))))&&(n.value!=i&&(activeOnChange=!1,cover.keyMsg(n,"Carry"),n.value=i,activeOnChange=!0,r&&dispatchEvent(n,"blur")),!0)}function r(e,t){a("SECOND",zeroInt(e%60,2),t),a("MINUTE",zeroInt((e/=60)%60,2),t),a("HOUR",zeroInt((e/=60)%24,2),t)}"period"==t?"date"==i?a("DAY",$I(n/864e5)+1,!0):r(new Date(n),!0):"date"==i?function(n,i){e[t].subs.SMALLYEAR&&(n[0]=String(n[0]).slice(2)),a("YEAR",n[0],i),a("MONTH",n[1],i),a("DAY",n[2],i,!0)}($D.toISO(n).split("-"),!1):r(new Date(n),!1)},getValue=function(e,t,n){var i=0;return i="period"==t?"date"==n?(i=a("DAY",!0))>-1&&864e5*(i-1):r(!0):"date"==n?function(n){var i=a("YEAR",n,-1),r=a("MONTH",n,-1),o=a("DAY",n,-1);return e[t].subs.SMALLYEAR&&(i+=2e3,i-=i>$D.y()+conf.smallYearFuture?100:0),i>-1&&r>-1&&o>-1&&$D([i,r,o]).getTime()}(!1):r(!1);function a(n,i,a){var r=e[t].getId(n+(i?"S":""));return r?r&&(r=$(r))&&(r=r.value)?$I(r):a:0}function r(e){return h=a("HOUR",e,-1),m=a("MINUTE",e,-1),s=a("SECOND",e,-1),h>-1&&m>-1&&s>-1&&3600*h+60*m+s}},setAllValues=function(e,t,n,i=!1){var a=t.begin;return r("date"),r("time"),e.value;function r(e){function i(e,i,r){var o="begin"==e&&getValue(a,"begin",r),s=("period"==e||"period"==i)&&getValue(a,"period",r),l="end"==i&&getValue(a,"end",r),c=o&&!1!==s?"end":o&&l?"period":"begin",u=a.calendar.period||{};o=o||!1!==l&&!1!==s&&l-s,l=l||!1!==o&&!1!==s&&o+s,!1===(s=!1!==s?s:!1!==l&&!1!==o&&l-o)&&o&&n&&(c="end",s=(l||o)-o,$I(u.begin-1)>0&&s/864e5<u.begin&&(s=864e5*(u.begin-1)),setValue(a,"period",s,r)),!1!==o&&!1!==l&&!1!==s&&(l&&o&&function(e,i,r,o,s){var l,c,u=!0;return"date"==o?(l=a.period!==t?t:a.period.fixed?a.end:a.begin,c=$(l.getId("DAY")||l.first),u=metaReaction.date.checkLimits(l,c,e,i,n),c=a.period.getSub(a.period.getId("DAYS")),r=$I(r/864e5)+1,(c&&(r<c.check.min||r>c.check.max)||s.end&&(r<s.begin||r>s.end))&&(c=$(c.id),cover.keyMsg(c,"Error"),n&&dialog.setMsg("error","daysPeriod",$(l.id),4500),u=!1),u):e>=0&&r>=0&&i>=0}(o,l,s,r,u)?setValue(a,c,"begin"==c?o:"end"==c?l:s,r):(c=a.begin===t?"begin":a.end===t?"end":"period",setValue(a,c,"begin"==c?getValue(a,"end",r)-getValue(a,"period",r):"period"==c?getValue(a,"end",r)-getValue(a,"begin",r):getValue(a,"begin",r)+getValue(a,"period",r),r)))}a.periodCheck[e]&&(a.end===t?i(a.period.fixed?"period":"begin","end",e):i("begin","period",e))}},{init:function(e,t){var n=t.begin||getFormDef($(t.data))||{};t.begin=n,n.period||(n.period=t,n.period.fixed=!!n.period.fixed,metaReaction.date.setLimits(t,"period")),n.begin&&n.end&&n.end.subs&&!n.periodCheck&&setTimeout(function(e,t){return function(){t.periodCheck={},i(t.begin),i(t.end),i(t.period,!0),setAllValues(e,t.begin,!0)};function i(e,t){var i=e.subs,a=e.type;for(a in i)i[a].check.doReaction=metaReaction.period.doReaction($(e.id),e);t||(n.periodCheck.date=i.DAY?1:0,n.periodCheck.time=i.HOUR||i.MINUTE||i.SECOND?1:0)}}(e,n),250)},doReaction:function(e,t){return{init:function(e){var n=t.begin,i=t==n.begin?"begin":t==n.end&&"end";i&&(n.periodCheck.date&&!subValue(n[i],"DAY")&&setValue(n,i,$D().getTime(),"date"),n.periodCheck.time&&!getValue(n,"begin","time")&&setValue(n,i,function(){var e=new Date;return 3600*e.getHours()+60*e.getMinutes()}(),"time")),setAllValues(e,t,!1)},onchange:function(e,n,i){return i?setAllValues(e,t,!1):n},onblur:function(e,n){var i=t.getSub(e.id).type;i="DAYS"==i||"PDAYS"==i,(n||i)&&setAllValues(e,t,!0,i)}}},setValue:function(e,t){var n=getFormDef(e);setAllValues(e,n,!0)}}),metaReaction.time={init:function(e,t){var n=t;!0===t.end?((n=getFormDef($(t.data))).end=t,t.begin=n):n.begin=t,(t.getId("HOURS")||t.getId("MINUTES"))&&metaReaction.period.init(e,t),n.begin&&n.end&&n.period&&metaReaction.period.init(e,n.period)},getContent:function(e,t){e.id,cssNS.modal;var n=lang.timepicker.split(","),i=function(e,t,n,i){t=t.split(" ");for(var a=0;a<t.length;a++)e.push(getStruct.radioCheck(!1,null,t[a],"uL"+t[a]+n,i,t[a]));return e};return[["fieldset",{}].concat(i([["legend",{},n[0]],["span",{CN:cssNS.linebreak},n[1]]],"01 02 03 04 05 06",0,"uLtimeHOUR"),i([["span",{CN:cssNS.linebreak},n[2]]],"07 08 09 10 11 12",1,"uLtimeHOUR"),i([["span",{CN:cssNS.linebreak},n[3]]],"13 14 15 16 17 18",2,"uLtimeHOUR"),i([["span",{CN:cssNS.linebreak},n[4]]],"19 20 21 22 23 24",3,"uLtimeHOUR")),["div",{CN:cssNS.gap}],["fieldset",{}].concat(i([["legend",{},n[5]]],"00 05 10 15 20 25 30 35 40 45 50 55",4,"uLtimeMINUTE")),useLib.getStruct.buttonRow()]},getValue:function(e){var t=getFormDef(e);function n(n){var i=$(t.subs[n].id).value;$Q($(e.id+cssNS.modal),"[name=uLtime"+n+"]")[i="HOUR"==n?($I(i)||(new Date).getHours())-1:Math.floor($I(i)/5)].checked=!0}n("HOUR"),n("MINUTE"),t.subs.SECOND&&0===(e=$(t.subs.SECOND.id)).value.length&&(e.value="00")},setValue:function(e){function t(t){return($Q($(e.id+cssNS.modal),"[name=uLtime"+t+"]:checked",1)||{}).value||""}cover.setValue(getFormDef(e),"time",t("HOUR")+":"+t("MINUTE"))}},metaReaction.date={init:function(e,t){var n=t;n.begin=t,!0===t.end?((n=getFormDef($(t.data))).end=t,t.begin=n,t.calendar=n.calendar,metaReaction.date.setLimits(t,"end")):(metaReaction.calendar.normCal(t),metaReaction.date.setLimits(t,"begin")),(t.getId("DAYS")||t.getId("HOURS"))&&metaReaction.period.init(e,t),n.begin&&n.end&&n.period&&metaReaction.period.init(e,n.period)},setValue:function(e,t){var n=getFormDef(e);if(n=n.begin||n,activeOnChange=!1,n.period&&t.period&&($(n.getId("DAYS")||n.period.first).value=String(t.period)),!this.checkLimits(n,$(n.first),t.begin,t.end,!0))return!1;cover.setValue(n.begin,"date",t.begin),n.end&&cover.setValue(n.end,"date",t.end),activeOnChange=!0},getValue:function(e){var t=getFormDef(e);return t=t.begin||t,e=cover.getValue(t.begin,"date","norm"),{calendar:t.calendar,begin:e,end:t.end?cover.getValue(t.end,"date","norm"):e}},setLimits:function(e,t){var n,i=e.calendar||e.begin.calendar||{disabled:{},period:{begin:1}};function a(e,t){(n=n.check).min=e||n.min,n.max=t||n.max}"period"==t?(i.period={begin:i.period.begin||1,end:i.period.end||365},(n=e.getSub(e.getId("DAYS")))&&a(i.period.begin,i.period.end)):(e.min=e.min&&"begin"==t?e.min:!(!e.end||!e.end.min)&&e.end.min,e.max=e.max&&"end"==t?e.max:!(!e.begin||!e.begin.max)&&e.end.max,e.min&&(i.disabled.min={begin:$D("100-01-01"),end:$D(e.min)}),e.max&&(i.disabled.max={begin:$D(e.max),end:$D("3100-01-01")}),(n=e.getSub(e.getId("YEAR")))&&(a(e.min,e.max),e.subs.SMALLYEAR&&(n.max-=n.max>2e3?2e3:1900,n.min-=n.min>2e3?2e3:1900))),(e.begin||e).calendar=i},checkLimits:function(e,t,n,i,a){var r=e.calendar||e.begin.calendar;if(r){if(i=i||n,e.subs.WEEK?(n=$D.getWeekDate(n,cover.getYear(e)),i=[n,$D.add(n,"d",1)]):(n=$D(n),i=$D(i)),!o("Disabled"))return!1;o("Blocked")}return!0;function o(e){return!!function(e,t,n,i){for(var a in r[t]){var o,s=!typeCheck("Date",r[t][a].begin)&&Object.keys(langConf.en.dayNames),l=r[t][a].begin,c=r[t][a].end;s&&(l=s.indexOf(l),c=s.indexOf(c));for(var u=n;u<=i;u=$D.add(u,"d",1)){if(!s&&u>=l&&n<=c)return!1;if(s&&(o=(o=u.getDay())||7)>=l&&o<=c)return!1}}return!0}(0,e.toLowerCase(),n,i)||(cover.keyMsg(t,"Disabled"==e?"Error":"Hint"),a&&dialog.setMsg("Disabled"==e?"error":"hint","date"+e,0,4500),!1)}},doReaction:function(e,t){return{onblur:function(e,n){n&&metaReaction.date.checkLimits(t,e,n,n,!0)}}}},metaReaction.week={init:function(e,t){metaReaction.calendar.normCal(t,!1),metaReaction.date.setLimits(t,"week"),setFree(t.id,0,lang.isWeek[0]),subValue(t,"YEAR")||cover.setValue(t,"YEAR",$D.y())},setValue:function(e,t){var n=getFormDef(e);activeOnChange=!1,cover.setValue(n,"WEEK",t.week),cover.setValue(n,"YEAR",$D.y(t.begin)),activeOnChange=!0},getValue:function(e){var t=getFormDef(e),n={calendar:t.calendar},i=subValue(t,"WEEK")||$D.getWeekNo($D()),a=subValue(t,"YEAR");return a=$D.getWeekDate(i,a),n.week=i||-1,n.begin=a?$D.toISO(a):0,n.end=a?$D.toISO($D.add(n.begin,"d",6)):0,n},doReaction:metaReaction.date.doReaction},metaReaction.calendar=function(){var e,t,n=function(e,t,n,i){return e&&($CN[n?"remove":"add"](e,t),i&&i.length&&(n?$A(e,"title",-1):(n=$A(e,"title"),$A(e,"title",(n?n+"\n":"")+i)))),e},i=function(e,t,i,a,r){if(e){e=e<l?l:e,t=t>c?c:t;for(var o;t>=e;t=$D.add(t,"d",-1))o=$("uL-"+$D.toISO(t)),n(o,i||cssNS.selected,a,r)}},a=function(e,t){d.period=e&&t?$I((t-e)/864e5)+1:0,$("uL-days").innerHTML=d.period},r=function(e,t){var n,r=e?e.id?$D(e.id.slice(3)):e:u.a;$CN.contains(e,cssNS.disabled)||("start"==t?u={b:d.begin.length?$D(d.begin):0,e:d.end.length?$D(d.end):0,a:r,click:!0}:u&&((u.click||r.getTime()!=u.a.getTime())&&(d.week?(d.week=$D.getWeekNo(r),n={b:r=$D.getWeekday(r,1),e:$D.add(r,"d",6)},u.a=r):n=u.b&&d.periodmax&&1!=d.periodmax?function(){var e,t=u.b,n=u.e;u.a=r,u.click=!1,t!=n&&r>=t&&r<=n?r-t>n-r?n=$D.add(r,"d",-1):t=$D.add(r,"d",1):r<t?(n>(e=$D.add(r,"d",d.periodmax-1))&&(n=e,cover.keyMsg($("uL-days"),"Hint")),t=r):r>n&&(t<(e=$D.add(r,"d",1-d.periodmax))&&(t=e,cover.keyMsg($("uL-days"),"Hint")),n=r);return{b:t,e:n}}():{b:r,e:r},i(u.b,u.e,!1,!0),i(n.b,n.e),a(n.b,n.e),u.b=n.b,u.e=n.e),"stop"==t&&(d.begin=u.b>u.e?"":$D.toISO(u.b),d.end=u.b>u.e?"":$D.toISO(u.e),u=!1)))},o=conf.calendarMonth,s=$D.toISO(),l=0,c=0,u=!1,d={};function f(e,r){var u=$(t);function f(e){var a=metaReaction.calendar.addBlocked;for(var r in d.calendar[e])o(d.calendar[e][r],r);if("blocked"==e&&a)for(var r in a)o(a[r],r);function o(a,r){typeCheck("Date",a.begin)?i(a.begin,a.end,cssNS[e],!1,r):function(e,i,a,r){var o,s=Object.keys(langConf.en.dayNames),l=Object.keys(lang.dayNames),c=s.indexOf(e);for(i=s.indexOf(i);c>-1&&c<=i;c++){o=$Q($(t),"td[headers="+l[c]+"]");for(var u=0;u<o.length;u++)o[u].innerHTML.length&&n(o[u],cssNS[a],!1,r)}}(a.begin,a.end,e,r)}}d=r||d,(e=e||$D()).setDate(1),s=$D.toISO(e),e=$D.add(e,"m",o<3?0:-1),l=e,c=$D.add($D.add(e,"m",o),"d",-1),u.replaceChild($CE(function(e){var n=t+"year",i=[["th",{id:"uL-mm",CN:cssNS.year,abbr:lang.month[0]},getStruct.input(n,lang.year,{type:"number",id:n,value:$D.y(e),size:4,maxlength:4,KD:"useLib.call.calKeyDown(event,this)",KU:"useLib.call.calKeyUp(this)",OC:"useLib.call.calSetYear(this)"})]],a=[];for(var r in lang.dayNames)i.push(r==lang.isWeek[0]?["th",{id:r,CN:cssNS.week,title:"Standard of ISO 8601 (correct >1976)",abbr:lang.dayNames[r]},r]:["th",{id:r,CN:cssNS.day,abbr:lang.dayNames[r]+" "+lang.isday[0]},r]);for(var s=0;s<o;s++)a=a.concat(c(e,s&&s!=o-1?null:l(!s))),e=$D.add(e,"m",1);return["table",{summary:lang.calTable[0]},["thead",{},["tr",{}].concat(i)],["tbody",{}].concat(a)];function l(e){var t=e?"up":"down";return["button",{CN:cssNS[t],type:"button",T:lang["month"+t],MC:"useLib.call.calSetMonth("+(e?-1:1)+");"}]}function c(e,t){for(var n,i,a,r=$D.daysInMonth(e),o=1-(e.getDay()||7),s=$D.m(e),l=$D.y(e),c=$D.getWeekNo(e),u=Math.ceil((r-o)/7),d=[],f=0;f<u;f++){for(var g in n=0==f?[["td",{headers:"uL-mm",CN:cssNS.month,rowspan:u,IH:lang.months[s-1]+"<br>"+l},t]]:[],c=c>52&&12==s&&!$D.checkWeek53(l)||c>53?1:c,lang.dayNames)i=["td",{headers:g}],g==lang.isWeek[0]?(i[1].CN=cssNS.week+(o<0?" "+cssNS.small:""),i[1].MC="useLib.call.calWeek("+c+","+l+")",i.push(String(c++))):(a=++o>0&&o<=r&&"uL-"+$D.toISO([l,s,o]))&&(i[1].id=a,i[1].MD="useLib.call.calAnalyze( this, 'start')",i[1].MM="useLib.call.calAnalyze( this, 'move')",i.push(String(o))),n.push(i);d.push(["tr",{}].concat(n))}return d}}(e)),u.firstChild),n($("uL-"+$D.toISO()),cssNS.today),f("blocked"),function(e){var t=$D(s),i=$D.y(t);a(i,e),$D.y($D.add(t,"m",o))>i&&a(i+1,e);function a(e,t){for(var i=0,a={};i<t.length;i++,a={})for(var o in-1!=t[i].indexOf("christ")&&(a=r(e)),a)n($("uL-"+o),cssNS.sunday,!1,a[o])}function r(e){var t=function(e){var t=parseInt,n=function(e,t){return Math.abs(e%t)},i=t(e/100),a=15+t((3*i+3)/4)-t((8*i+13)/25),r=2-t((3*i+3)/4),o=n(e,19),s=n(19*o+a,30),l=t(s/29)+(t(s/28)-t(s/29))*t(o/11),c=21+s-l,u=7-n(e+t(e/4)+r,7),d=7-n(c-u,7),f=c+d,g=3;f>31&&(g=4,f-=31);return $D([e,g,f])}(e),n={goodFriday:-2,easterSunday:0,easterMonday:1,theAscension:39,whitSunday:49,whitMonday:50,corpusChristi:60,ashWednesday:-46},i=lang.christHoliday,a=[];for(var r in n)a[$D.toISO($D.add(t,"d",n[r]))]=i[r];for(var r in i.fixHoliday)a[e+"-"+r]=i.fixHoliday[r];return a}}(d.calendar.holidays?d.calendar.holidays.split(","):"christian"),f("disabled"),d.begin?(i($D(d.begin),$D(d.end)),a($D(d.begin),$D(d.end))):a(0,0),$("uL-days").nextSibling.innerHTML=lang.selecteddays[0]+(!d.week&&(e=d.calendar.period)&&(e.begin>1||e.end)?"<br>("+e.begin+(e.end?" - "+e.end:"")+" max.)":"")}function g(n,i){(i=min(max(i,e.subs.YEAR.check.min),e.subs.YEAR.check.max))!=$D.y(s)&&(n.value=i,f($D(i+s.slice(4))),(n=$(t+"year")).focus())}function p(e){return"week"==getFormDef(e).type?"week":"date"}return call.uLinit("calReset",(function(e){d.begin=d.givenBegin,d.end=d.givenEnd,f($D(d.begin))})),call.uLinit("calToSelect",(function(){f($D(d.begin))})),call.uLinit("calToDay",(function(){f()})),call.uLinit("calAddMonth",(function(e){o=max(3,min(12,o+e)),f($D(s))})),call.uLinit("calSetMonth",(function(e){f($D.add(s,"m",e))})),call.uLinit("calSetYear",(function(e){g(e,e.value)})),call.uLinit("calWeek",(function(e,t){e=$D.getWeekDate(e,t),r(e,"start"),r(e,"stop")})),call.uLinit("calAnalyze",r),call.uLinit("calKeyDown",(function(e,t){var n=38==e.keyCode?1:40==e.keyCode?-1:0;n&&g(t,t.value.length?$I(t.value)+n:$D.y())})),call.uLinit("calKeyUp",(function(t){var n=$I(String(t.value).replace(/[^0-9]/g,""));n>e.subs.YEAR.check.min&&g(t,n)})),{getContent:function(n,i){return e=getFormDef(n),t=n.id+"uLcalendarContend",[["div",{CN:cssNS.calendar+" "+cssNS.noUserSelect,MU:"useLib.call.calAnalyze( false, 'stop' )"},["h1",{},lang.datepicker[0]],["span",{CN:cssNS.inform},lang.datepicker[1]],["div",{id:t},["table",{}]],["div",{CN:cssNS.legend},["h1",{},lang.legend[0]],["dl",{},["dt",{CN:cssNS.today},"X"],["dd",{},lang.today[0]],["dt",{CN:cssNS.disabled},"X"],["dd",{},lang.disableddays[0]],["dt",{CN:cssNS.blocked},"X"],["dd",{},lang.blockeddays[0]],["dt",{CN:cssNS.sunday},"X"],["dd",{},lang.holidays[0]],["hr",{}],["dt",{id:"uL-days",CN:cssNS.selected},"0"],["dd",{},lang.selecteddays[0]]],["div",{CN:cssNS.doublebutton},getStruct.button(lang.jumptoday,"useLib.call.calToDay()")],["div",{CN:cssNS.doublebutton},getStruct.button(lang.jumptoselect,"useLib.call.calToSelect()")],getStruct.doubleButton(lang.display,"useLib.call.calAddMonth")]],getStruct.buttonRow()]},getValue:function(e){var t=metaReaction[p(e)].getValue(e),n=getFormDef(e).begin;n&&(n=n.period)&&n.fixed&&(t.periodmax=$I($((n.subs.DAYS||n.subs.PDAYS).id).value)),t.periodmax||(t.periodmax=t.week?7:t.calendar&&t.calendar.period?t.calendar.period.end:n?365:1),t.givenBegin=t.begin,t.givenEnd=t.end,f($D(t.begin),t)},setValue:function(e,t){return metaReaction[p(e)].setValue(e,d)},normCal:function(e,t){var n=e.calendar||!1;function i(t){var n,i;for(var a in t)n=t[a].begin,i=t[a].end,"min"!=n||e.min||(e.min=i),"max"!=i||e.max||(e.max=n),n=$I(n)?$D(n):"min"==n?$D("0100-01-01"):n,i=i?$I(i)?$D(i):"max"==i?$D("3100-01-01"):i:n,t[a].begin=i<n?i:n,t[a].end=n>i?n:i;return t}n&&n.loaded||(e.data&&(n=t||loadJSONCSS(e.data,(function(t){Array.isArray(t)&&(t=t.join("\n")),(t=!!(typeCheck("String",t)&&t.indexOf("BEGIN:VEVENT")>-1)&&analyseICAL({},t))&&D.contains($(e.id))&&metaReaction.calendar.normCal(e,t)})))?(n.blocked=i(n.blocked||{}),n.disabled=i(n.disabled||{}),n.loaded=!0):n={disabled:{},blocked:{},loaded:!e.data||-2==extern[e.data]},n.holidays=n.holidays||"christian",n.period=n.period||{begin:1},e.calendar=n)},addBlocked:!1}}(),metaReaction.singleSelect=function(){function e(e,t){e=$T($P(e),"input");for(var n=0;n<e.length;n++)e[n].disabled||$CN.contains(e[n],"uL_ignore")||(e[n].checked=1===t&&!e[n].checked||0===t&&$A(e[n],"checked"),onchange(e[n],null))}function t(e,t){var i,a=dialog.layer.length?$(String(dialog.layer.slice(-1))):null,r=D.activeElement;if(a&&(r&&a.contains(r)||n(a),r)){if(i="BUTTON"==r.tagName,/uL[\w\._-]+Filter/.test(r.id))if(38==e)setFocus(c("top"));else if(40==e)n(a);else if(e=37==e||8==e?"previous":39==e?"next":0)if($(r)[e+"Sibling"]&&("INPUT"!=r.tagName||r.selectionStart==r.value.length&&"next"==e))setFocus($(r)[e+"Sibling"].firstChild);else{if("INPUT"!=r.tagName||0!=r.selectionEnd||"previous"!=e||!(i=c("top")))return!1;setFocus(i.nextSibling)}else{if("previous"!=e||(i=c("top"))==r)return!1;setFocus(i.nextSibling)}else if(i)setFocus(c(e));else{var o=r.id.match(/(.+?)-(\d+)-(\d+)$/);if(!o)return!1;32==e&&"checkbox"==r.type?r.checked=!r.checked:(o.shift(),o[1]=$I(o[1]),o[2]=$I(o[2]),((r=function(e){if(e){var t=s(o[1],e),n=!1;n=t==o[1]?e<0&&0==o[2]?l(t+e,-10):e>0&&r==l(t,-10)?l(s(o[1],-e),o[2]+e)||l(t+e,0):l(s(o[1],-e),o[2]+e):l(o[1]+e,o[2])||l(o[1]+e,-10)}return n}(37==e||8==e||9==e&&t.shiftKey?-1:39==e||9==e?1:0))||(r=function(e){if(e){var t=o[2]+e,n=!1;(n=l(o[1],t))||(t=s(o[1],-1),e<0?(n=l(s(t-1,-1)+o[1]-t,-10))||(n=c("top")):(n=l(s(o[1],1)+1+o[1]-t,0))||(n=c("bottom")))}return n}(38==e?-1:40==e?1:0)))&&r.focus())}return!0}return!1;function s(e,t){var n,i=l(e,0);if(i)for(i=$P(i,2).offsetLeft;(n=l(e+t,0))&&(n=$P(n,2).offsetLeft)&&(t>0&&n>i||t<0&&n<i);)i=n,e+=t;return e}function l(e,t){var n=$([o[0],e,t&&-10!=t?t:0].join("-"));return n&&-10==t?l(e,$P(n,2).childNodes.length-2):n}function c(e){var t,n=$T(a,"button");return"Filter"==n[0].id.slice(-6)&&"top"==e?$P(n[0]).previousSibling.firstChild:n[0].className==cssNS.invert&&("top"==e?n[0]:"bottom"==e?n[n.length-1]:(t=[].indexOf.call(n,D.activeElement),"Filter"==n[2].id.slice(-6)&&1==t&&39==e||2==t&&(8==e||37==e)?$P(n[2]).previousSibling.firstChild:(t=t<2&&40==e?-2:t>1&&38==e?-1:t)<0?(n=$Q(a,"[type=checkbox]"))[-2==t?0:n.length-1]:n[max(min(t+=8==e||37==e?-1:39==e?1:0,n.length-1),0)]))}}function n(e){setFocus($Q(e,"input:checked",1)||$Q(e,'input[type="radio"]:enabled,input[type="checkbox"]:enabled',1))}return call.uLinit("invertSelect",(function(t){return e(t,1),!1})),call.uLinit("resetSelect",(function(t){e(t,0)})),call.uLinit("clearSelect",(function(t){return e(t,-1),!1})),call.uLinit("filterSelect",(function(e,t){var n=$(e+"Filter"),i=$Q($P(n,3),'[name="'+e+'uL[]"]'),a=n.value.trim();if(a=!(!a.length||"showAll"==t)&&analyseFilter(a),"showAll"==t||a)for(var r,o,s=0;s<i.length;s++)r=$S($P(i[s])),"showAll"==t?r.display="block":(!(o=a(i[s].nextSibling.textContent))&&"filter"==t||o&&"filterInvers"==t)&&(r.display="none");return!1})),{doReaction:function(e,t){return{onrotor:function(t,n,i){return n=(n=$I(e.selectedIndex+i))>e.options.length-1?0:n<0?e.options.length-1:n,activeOnChange=!1,e.selectedIndex=n,n=e.options[n].text,onchange(e,n),activeOnChange=!0,n}}},getContent:function(e,t,n){$A(e,"onfocus")&&dispatchEvent(e,"focus");var i=function(e){var t=u[e];t&&t.c&&(u[e]=Math.ceil(6.9*t.w/t.c+35)/10)},a=function(e){return e.reduce((function(e,t){return e+t}),0)},r="multiSelect"==t,o=getFormDef(e),s=$T(e,"optgroup"),l=-1,c=0,u=[],d=62.5/parseFloat(D.body.style.fontSize);if("dynamicSelect"==t?n=dynamicSelects[$A(e,"data-ul")]:"dynamicExtend"==t&&(n=metaReaction.selfgrouper.getDynamicValues(e)),g(!0),i(l),++l<7||l>14)c="width:auto;";else{l=min(Math.floor((.85*W.innerWidth-32)/a(u)),Math.ceil(l/(l>3?2:1)));for(var f=0;f<u.length;f+=l)c=max(c,a(u.slice(f,f+l)));c="width:"+Math.ceil(c*d)+"em;"}return function(n,i){var a=getLabelText(e),o=lang[r?"multiSelect":"singleSelect"];return[["fieldset",{S:i},r||a.length?["legend",{},r?["button",{CN:cssNS.invert,T:lang.invertSelect[0],MC:"return useLib.call.invertSelect( this.parentNode )"}]:null,r?["button",{CN:cssNS.clear,T:lang.clearSelect[0],MC:"return useLib.call.clearSelect( this.parentNode )"}]:null,["span",{},a]]:null,"listSelect"==t?null:["span",{CN:cssNS.inform,IH:useLib.WIKI.toHTML(o[1])}],o[2]?["span",{CN:cssNS.explain,IH:useLib.WIKI.toHTML(o[2])}]:null,5*n.length>conf.filterLimit?p(e.id):null].concat(n),r?getStruct.buttonRow():null]}(g(!1),c+"min-width:28em;");function g(a){var c,d=[],f="",g=1;if(n)for(var p=0,m="none";p<n.length;p++)"group"==n[p].type?m=n[p].textContent:v(n[p],m);else if(s.length)for(var h=0;h<s.length;h++)for(p=0;p<s[h].children.length;p++)v(s[h].children[p],s[h].label,s[h].style.width);else for(p=0;p<e.children.length;p++)v(e.children[p],"none");return d;function v(n,s,p){a?function(e,n,a){var o=e.textContent.length+(e.shortCut?e.shortCut.length:0);"dynamicSelect"==t&&"checkbox"==e.type&&(r=!0);(n!=f||g++%5==0)&&(o+="none"==n?0:n.length,i(l),n!=f&&(f=n,g=1,n.length&&0),l++,u[l]||(u[l]=a||{c:n.length>5?1:0,w:0}));a||(u[l].c++,u[l].w+=o)}(n,s,!!p&&parseFloat(p)):function(n,i){i==f&&g++%5!=0||(d.push(a(i,"none"!=i&&i==f?cssNS.same:"",u[d.length])),i!=f&&(f=i,g=1));c=d.length-1,d[c].push(getStruct.radioCheck((!n.type||"radio"!=n.type)&&r,(n.textContent.indexOf(conf.beforeOwnInput)>-1?"ownInput ":"")+((n.className||"")+" "+(n.id||"")).trim(),n.textContent||"",e.id+"uL-"+c+"-"+(d[c].length-3),e.id+"uL[]",n.value||n.textContent,o.value&&o.value.indexOf(n.value||n.textContent)>-1,!!n.disabled,n.shortCut||!1,r?"this.focus()":"useLib.call.submitForm(this.form,false)")),c=d[c][d[c].length-1],"listSelect"==t&&(c[1].S="padding-left:0!important;",c[2][1].S="visibility:hidden;");function a(e,t,n){return e="none"==e?" ":e,["div",{CN:t,S:"width:"+n+"em;"},["h2",r?{MC:"useLib.call.invertSelect( this )",M2:"useLib.call.resetSelect( this )",title:e}:{title:e},e]]}c[3][1].title=n.title||n.textContent}(n,s)}}function p(e){return["div",{CN:cssNS.filter},["span",{},["input",{CN:"uL_ignore",type:"text",autocomplete:"off",T:lang.filterButtons[1],id:e+"Filter",S:"width:14em;margin:0 0.3em 0 0;"}]],t("filter",2,!0),t("filterInvers",3),t("showAll",4)];function t(t,n,i){return["div",{CN:cssNS.button,S:"display:inline!important;margin:0!important;padding:0!important;"},["button",{CN:cssNS[t]+(i?" "+cssNS.invertIcon:""),MC:"return useLib.call.filterSelect('"+e+"','"+t+"')",T:lang.filterButtons[n],id:"uL"+e+n+"Filter"},""]]}}},getValue:function(e){n($(e.id+cssNS.modal)),keyControl=t},setValue:function(e,t){if(t=t||function(e){for(var t=$T(e,"input"),n=[],i=0;i<t.length;i++)t[i].checked&&!t[i].disabled&&n.push(t[i].value);return n}($(e.id+cssNS.modal)),"dynamicExtend"==getFormDef(e).type){if(!1===metaReaction.grouper.changeGrouper(e,t[0]))return}else setEleValue(e,t);onchange(e,t)},getText:function(e,t,n){for(var i=0,a=e.options,r=[];i<a.length;i++)!a[i].disabled&&("string"==typeof t&&a[i].value==t||t.indexOf(a[i].value)>-1)&&r.push(a[i].text.replace(/\s/g," "));return r=r.length?r.join(", "):"",n&&($(getFormDef(e).first).value=r),r}}}(),metaReaction.multiSelect=metaReaction.dynamicSelect=metaReaction.dynamicExtend=metaReaction.singleSelect,metaReaction.toggleSelect=function(){function e(e,t,n){var i=e.options.length-1,a=max(0,n?e.selectedIndex==i?i-1:i:e.selectedIndex);n&&(activeOnChange=!1,e.value=e.options[a].value,dispatchEvent(e,"change"),activeOnChange=!0),$(t.first).value=e.options[a].text,$(t.first).nextSibling.title=e.options[e.selectedIndex==i?i-1:i].text,$CN[a==i?"add":"remove"](e.nextSibling,cssNS.active)}return{init:e,doButton:function(t,n){$CN.contains(n,cssNS.disabled)||e(n,getFormDef(n),!0)},setValue:function(t){e(t,getFormDef(t),!1)}}}(),metaReaction.file=function(){var e=!1;function t(t,n){var i=getFormDef(t);n=i.value=null==n?getEleValue(t):[n.trim()],$A(t,"data-ul",n[0].length?n[0]:-1),!n[0].length&&t.value.length&&(e=!0,dispatchEvent(t,"change"),e=!1),(t=$(i.first))&&(t.value=n[0].replace(/.*?([^\\\/]+)$/,"$1"))}return{init:function(n,i){var a=$(i.first);function r(e){var t="_shield_uL__modal__";e?(t=D.body.appendChild($CE(["div",{id:t,role:"dialog",CN:cssNS.modal+" "+cssNS.file},["div",{S:"width: 100vw; height: 100vh; opacity: 0;"}]])))[attrList.MM]=function(){this[attrList.MM]=null,r(!1),setFocus(a)}:(activeOnChange=!0,t=$(t)),setOpenClose(t,e)}$A(n.form,"enctype","multipart/form-data"),n.onclick=function(){activeOnChange=!1,r(!0)},call.drop.init(n),$E(n,"OC",(function(i){e||(t(n),r(!1),setFocus(a),n.files.length&&useLib.call.drop.ondrop(i,n.files))})),$E(a,"OF",useLib.call.coverOnFocus),$E(a,"OB",(function(){setStatus(n,"focused",0)})),$E(a,"KD",(function(e){8!==e.keyCode&&46!==e.keyCode||doEvent.clearInput(getFormDef(n))}))},setValue:t,doButton:function(e,t){t.click()},doReaction:function(e,n){return{onchange:function(n,i){return t(e,i),i}}}}}(),metaReaction.color=function(){var e=!1;function t(e,t){e=e.target||e;var n,i=getFormDef(e);(t=(n=t||e.value,n=String(n||""),(/^#/.test(n)?n.slice(1):n).toLowerCase())).length?(i.value=["#"+t],$(i.subs.HEX.id).value=t,e.value=$S($(i.subs.PASSIVE.id)).backgroundColor="#"+t,$(i.subs.PASSIVE.id).title="rgb( "+parseInt(t.slice(1,3),16)+", "+parseInt(t.slice(3,5),16)+", "+parseInt(t.slice(5,7),16)+" )"):$(i.subs.PASSIVE.id).title="",stopChange=!0,dispatchEvent(e,"change"),stopChange=!1}return{init:function(e,n){$(n.subs.HEX.id)&&($E(e,"input",t),$(n.subs.HEX.id).onkeyup=function(t){var n=t.currentTarget,i=n.value.replace(/[^\(]+\((\d+%?)\s*,\s*(\d+%?)\s*,\s*(\d+%?).*/,(function(e,t,n,i){return r(t)+r(n)+r(i)})).slice(0,6).toLowerCase(),a=n.selectionStart;return/[0-9a-f]{6,6}/i.test(i)&&(n.value=i,n.setSelectionRange(a,a)),useLib.call.coverAfterInput(t,e.id);function r(e){return(1==(e=("%"==e.slice(-1)?Math.floor(2.55*$I(e)):$I(e)).toString(16)).length?"0":"")+e}},t(e))},setValue:t,doButton:function(t,n){e&&$A(e,"type","text"),$A(e=n,"type","color"),e.click()},doReaction:function(e,n){return{onchange:function(n,i){return/[0-9a-f]{6,6}/i.test(i)&&t(e,i),i}}}}}(),metaReaction.grouper=function(){var e=new RegExp("\\s*"+wikiSigns.append+"\\s*"),t=!1;function n(e,t=null){return e=$P(e,2),$Q(t?e:$P(e,2),"[data-ul=selfgrouper]",t)}function i(e,t=1){return $Q(e,'[data-ul-grp="isGrouper"]',t)}function a(e,t=!1){var n=$P(e,1).nextElementSibling;$CN.contains($P(e,1).firstChild,cssNS.same)?(e.form&&delete formDef[e.form.name][e.name],DOM.removeNode($P(e,1))):!t&&$CN.contains(n.firstChild,cssNS.same)?(n=i(n),"SELECT"==e.tagName?o(e,n.value):e.value=n.value,a(n)):(t||"SELECT"==e.tagName&&$A(e,"data-ul"))&&($P(e).style.display="none",e.value="",t||s(e,"updateDynamicSelect"))}function r(e){for(var t=0,n=i(e,null);t<n.length;t++)a(n[t],!0);var r;for(t=0,n=$Q(e,".uL_ignore."+cssNS.grouper);t<n.length;t++)$CN.remove(n[t],"uL_ignore"),r=$A(n[t],"data-ul-def").replace(/\d+$/,"0"),$A(n[t],"data-ul-def",r)}function o(e,t){"select-one"==e.type&&(e.innerHTML='<option value="'+t+'" selected>'+t+"</option>"),$A(e,"value",t),onchange(e,t)}function s(e,t){var r=n(e,1),s=r.value,l={},u=[],d=[],f=[];if(s&&s.trim().length)for(var g=n(e),p=0;p<g.length;p++)if((b=g[p].value.trim()).length){for(var m=i($P(g[p],2),null),h=0,v=[];h<m.length;h++)v.push([m[h].value,m[h]]);v.length>1&&"none"!=v[0][0]?(l[b]=v,l[b].e=g[p]):u.push(b)}if(0!=u.length)if("separateActive"==t){r=$Q($P(r,2),'[data-ul-def^="defGrp:"]',1),f=l[e.value]||[];p=0;for(var S=!0;p<f.length;p++)l[f[p][0]]||(S?(S=!1,o(e,f[p][0])):c(r,"dynamicExtend",f[p][0]))}else if("overviewEntry"==t){for(var b in l)l[b].filter((t=>t[0]==e.value)).length&&f.push(b);dialog.alert("((pre\n\n"+f.join(",\n").replace(/(\[|\]|\",)/g,"$1\n")+"\n))")}else if(f=function(e){if(e)return e.sort((function(e,t){return e[0]>t[0]})).filter((function(e,t,n){return!(t>0&&n[t-1][0]==e[0])||(d.push(n[t-1][1]),!1)}))}(function e(t,n,i){var a=[];t&&t.map((function(t){n[t[0]]&&n[t[0]][0][0].length?(a=[].concat(a,n[t[0]].filter((e=>i.indexOf(e[0])<0)))).length&&(i.push(t[0]),a=e(a,n,i)):a.push(t)}));return a}(l[s],l,[s])),"showGroupers"==t)dialog.alert("((pre\n\n"+JSON.stringify(f.map((e=>e[0]))).replace(/(\[|\]|\",)/g,"$1\n")+"\n))");else if("updateDynamicSelect"==t)!function(){var t=$A(e,"data-ul"),n=a(t);n[1]=n[1].concat(Object.keys(l).map((e=>r(e)))),n[2]=n[2].concat(u.map((e=>r(e)))),dynamicSelects[t]=[].concat(n[0],n[1],n[2]);for(var i=0;i<d.length;i++)cover.keyMsg($(getFormDef(d[i]).first),"Hint",3);function a(e){for(var t,n=0,i=[],a=-1;n<dynamicSelects[e].length;n++)"group"==(t=dynamicSelects[e][n]).type?i[++a]=[t]:0==a&&i[a].push(t);return(!i||i.length<3)&&(i=lang.selfgrouper.slice(0,3).map((function(e){return[{type:"group",textContent:e}]}))),i[0].length<2&&i[0].push({type:"radio",textContent:lang.selfgrouper[3],value:"removeActive"}),i}function r(e){return{type:"radio",textContent:e,value:e}}}();else for(p=0;p<d.length;p++)a(d[p])}function l(e,t=!1,n=""){if("none"==e.style.display)e.style.display=null,e=i(e),t&&$A(e,"type",t);else{var a,r=i(e).cloneNode(!0),s=e.cloneNode(!1);!function(e){e=$Q($P(e),'[data-ul-def^="defGrp:"]',1),$A(e,"data-ul-def",$A(e,"data-ul-def").replace(/(\d+)$/,(function(e,t){return a=$I(t)+1})))}(e),$CN.remove(s,cssNS.hasCover),t&&$A(r,"type",t),a=i(e).name.replace(/\[\d*\]$/,"["+zeroInt(a,5)+"]"),$A(r,"name",a),$A(r,"id",a),s.innerHTML='<label class="'+cssNS.same+'" for="'+a+'">'+repeat("&#x2001;",10)+"</label>"+r.outerHTML,e=i(s=DOM.insertAfter(e,s))}return o(e,n),e}function c(e,t,n){return initViaHTML(e=l($P(e).previousElementSibling,t,n)),initElement(e),e}return call.uLinit("resizeDynamicSelect",(function(e,t,n,r){if(n&&r)setEleValue(f(r),"");else{var o=f(e),l=i($P(o,3),null),c=function(e){for(var t,n=0,i=[],a=-1;n<dynamicSelects[e].length;n++)"group"==(t=dynamicSelects[e][n]).type?a++:a>0&&i.push(t.value);return i}($A(l[0],"data-ul")),u=o.name.slice(o.name.lastIndexOf(".")+1);t=t[e][e+"[]"].map((e=>e[u])),t=c.filter((e=>t.indexOf(e)<0));for(var d=0;d<l.length;d++)t.indexOf(l[d].value)>-1&&a(l[d]);s(l[0],"updateDynamicSelect")}function f(e){return $Q(D,'[name^="'+e+'"][data-ul="selfgrouper"]',1)}})),call.uLinit("updateDynamicSelect",(function(t){t.value=t.value.trim().split(e).join(" "+wikiSigns.append+" ");for(var n=i($P(t,3),null),a=0,r=getFormDef(t).value;a<n.length;a++)r&&r[0].length&&n[a].value==r[0]&&o(n[a],t.value.trim());s(i($P(t,2)),"updateDynamicSelect")})),call.uLinit("showGroupers",(function(e,t){var n=i($P(e,3).previousElementSibling);return"none"!=$P(n,1).style.display?s(n,"showGroupers"):dialog.setMsg("hint",lang.selfgrouper[2],e,3e3),!1})),{init:function(e,i){var a=$Q($P(e).previousElementSibling,"input,select,textarea",1);$CN.contains(e,"uL_ignore")||(a&&/\[\d*\]$/.test(a.name)?($A(a,"data-ul-grp","isGrouper"),$CN.add(e,"uL_ignore"),$A(e,"data-ul-def")||($CN.add(e,cssNS.grouper),$A($P(e),"title",lang.add[0]),$A(e,"data-ul-def","defGrp:"+getFormDef(a).type+":0")),"selfgrouper"==i.type&&(a.innerHTML.indexOf(">none<")>-1&&($P(a).style.display="none"),$A(n(e,1),"onchange","useLib.call.updateDynamicSelect(this);"),function(e){e=$Q($P(e,1),"button."+cssNS.informer,1),$A($P(e,1),"title",lang.show[0]),$A(e,"onclick","return useLib.call.showGroupers(this);")}(e))):console.warn("useLib hint: element (name:"+a.name+") is extend to grouper array the name needs to be ended with '[]'!")),"selfgrouper"==i.type&&(t&&clearTimeout(t),t=setTimeout((function(){t=!1,useLib.call.updateDynamicSelect(n(e,1)),$A($P(e,3),"onresize","useLib.call.resizeDynamicSelect");for(var i,a=0,r=$Q(e,'select[data-ul-grp="isGrouper"]');a<r.length;a++)(i=$A(r[a],"value"))&&($(getFormDef(r[a]).first).value=i)}),333))},doButton:function(e,t){(t=c(t,$A(t,"data-ul-def").slice(7).replace(/:\d+$/,""),"")).nextElementSibling&&t.nextElementSibling.firstChild&&t.nextElementSibling.firstChild.click()},setGrouper:function(e,t,n){for(var i=0;i<t.length;i++)e=l($P(e),n,t[i])},deleteAllGrouper:r,changeGrouper:function(e,t){var n=!1;switch(t){case"separateActive":case"removeDuplicates":case"overviewEntry":s(e,t);break;case"removeActive":a(e);break;case"removeAll":dialog.confirm("confirmMsg",(function(t){!0===t&&(r($P(e,2)),s(e,"updateDynamicSelect"))}));break;default:o(e,t),s(e,"updateDynamicSelect"),n=!0}return n},getDynamicValues:function(e,t){return s(e,"updateDynamicSelect"),dynamicSelects[$A(e,"data-ul")]},disableActive:function(e,t){var i=n(e,1);return(i=$A(i,"value"))&&i&&(i=i.trim()).length&&(t=JSON.parse(JSON.stringify(t)).map((function(e){return e.value&&e.value==i&&(e.disabled="disabled"),e}))),t}}}(),metaReaction.selfgrouper=metaReaction.grouper;var cover=function(){var e=0,n=$D.y()+conf.fullYearFuture,i=$D.y()+conf.smallYearFuture-2e3,a={c:"​",r:"/​/g"},r=function(e,t){var n=subValue(e,"SMALLYEAR");return n?n+(n>i?1900:2e3):(n=subValue(e,"YEAR"),t&&n<e.subs.YEAR.check.min?0:n)},o=function(e,t,n,a){return 0==a&&n<100&&e.subs.YEAR.check.min>999&&(n+=n>i?1900:2e3,t&&x.add(e,"yearError")),n},s=function(e,t,n,i){var a=e.getSub(t.id).check,r=n;if(e.step){var o,s=e.subs.INT||!1,l=e.subs.FIX||!1,c=l&&t.id==l.id;return i&&Math.abs(i)<a.step&&(n+=(i<0?-a.step:a.step)-i),c?n=!i||n<a.min||n>a.max||e.step<=1?n:n+(a.max+1)*(i<0?-1:1):(t.value=n,n=parseFloat(subValue(e,"INT")+(c&&s&&0!=i?s.check.step*(i<0?-1:1):0)+"."+(l?$(l.id).value:0)-(e.stepZeroshift||0)),n=(n=Math.round(n/e.step)*e.step+(e.stepZeroshift||0)).toFixed(l?l.check.maxCount:0).split("."),s&&l&&((o=$((c?s:l).id)).value!=(c?n[0]:n[1])&&D(o,"Hint"),o.value=c?n[0]:n[1]),n=c?n[1]:n[0]),0==i&&n!=r&&D(t,"Hint"),n}return n},l={PASSIVE:{ident:"\\0"},WEEK:{ident:"[1-5][0-3]|0?[1-9]",min:1,max:53,zero:1,jump:1,carry:"YEAR",extra:function(e,t,n){var i=r(e,1),a=53,o="";return i&&(n>52&&!$D.checkWeek53(i)&&(a=52),e.subs.WEEK.check.max=a,o=$D.getWeekDate(n>a?a:n,i),o=h("date",$D.toISO(o))+" > "+h("date",$D.toISO($D.add(o,"d",6)))),t.title=o,n}},DAY:{ident:"[12][0-9]|3[01]|0?[1-9]",min:1,max:31,offer:$D.d(),zero:1,jump:1,carry:"MONTH",extra:function(e,t,n,i){var a={2:28,4:30,6:30,9:30,11:30},o=subValue(e,"MONTH"),s=r(e,1),l=31;return o&&a[o]&&n>a[o]&&(l=2==o?!s||$D.checkLeapYear(s)?29:28:a[o]),e.subs.DAY.check.max=l,n>l&&x.add(e,"dayError"),setFree(e.id,0,s&&o&&n&&n<=l?$D.dayName([s,o,n])+",":""),n}},MONTH:{ident:"1[012]|0?[1-9]",min:1,max:12,offer:$D.m(),zero:1,jump:1,carry:"YEAR"},YEAR:{ident:"(1|2)?\\d{1,3}",min:n-130,max:n,offer:$D.y(),jump:1,extra:o},SMALLYEAR:{ident:"\\d\\d",min:100-i,max:i,offer:$D.y()-2e3,zero:1,jump:1},HOUR:{ident:"1[0-9]|2[0-3]|0?[0-9]",min:0,max:23,offer:9,zero:1,jump:1,carry:"DAY"},MINUTE:{ident:"[0-6]?[0-9]",min:0,max:59,zero:1,jump:1,carry:"HOUR"},SECOND:{ident:"[0-6]{0,1}[0-9]",min:0,max:59,zero:1,jump:1,carry:"MINUTE"},SECONDS:{ident:"0{0,1}[0-6]{0,1}[0-9]",min:0,max:59,zero:1,jump:1,carry:"MINUTES"},MINUTES:{ident:"0{0,1}[0-6]?[0-9]",min:0,max:59,offer:15,zero:1,jump:1,carry:"HOURS"},HOURS:{ident:"0{0,1}[0-9]|1[0-9]|2[0-3]",min:0,max:23,offer:9,zero:1,jump:1,carry:"DAYS"},DAYS:{ident:"[0-9]{0,3}",min:1,max:365,offer:1},PSECONDS:{ident:"(0{0,1}[0-6]{0,1}[0-9])?",min:0,max:59,zero:1,jump:1,carry:"PMINUTES"},PMINUTES:{ident:"(0{0,1}[0-6]?[0-9])?",min:0,max:59,offer:15,zero:1,jump:1,carry:"PHOURS"},PHOURS:{ident:"(0{0,1}[0-9]|1[0-9]|2[0-3])?",min:0,max:23,offer:9,zero:1,jump:1,carry:"PDAYS"},PDAYS:{ident:"([0-9]{0,3})?",min:1,max:365,offer:1},PYEAR:{ident:"(2?\\d{1,3})?",min:n-130,max:n,offer:$D.y(),jump:1,extra:o},INT:{ident:"-?[0-9]",min:-999999,max:999999,extra:s},ZERO:{ident:"([00-9])",min:1,max:999999,zero:1},FIX:{ident:"([0-90]+)",min:0,max:99,zero:-1,carry:"INT",extra:s},PINT:{ident:"(-?[0-9])",min:-999999,max:999999,extra:s},PFIX:{ident:"(([0-90]+))",min:0,max:99,zero:-1,carry:"PINT",extra:s},NUM:{ident:"[0-9]",min:1,max:9999999999},PASSWORD:{ident:".{0,5}",min:0,max:99999,jump:1},IBAN:{ident:"[ IBA-Z0-9]",jump:1,space:1,upper:1},COUNTRY:{ident:"[COA-Z]",jump:1,upper:1},HEX:{ident:"[ABCDEFabcdef0-9]",jump:1,lower:1},UPPER:{ident:"[ UPA-Z]",jump:1,space:1,upper:1},LOWER:{ident:"[ loa-z]",jump:1,space:1,lower:1},UPDIGIT:{ident:"[ UPA-Z0-9]",jump:1,space:1,upper:1},LOWDIGIT:{ident:"[ loa-z0-9]",jump:1,space:1,lower:1}},c=str2obj("carry zero jump space upper lower min max extra offer"),u={singleSelect:["PASSIVE","SingleSelect"],multiSelect:["PASSIVE","MultiSelect"],dynamicSelect:["PASSIVE","DynamicSelect"],dynamicExtend:["PASSIVE","DynamicExtend"],toggleSelect:["PASSIVE","ToggleSelect"],file:["PASSIVE","File"],email:["[mm]","{1,220}","\\@","[mm]","{1,256}"],fon:["\\+|00|\\(\\+\\)","[0-9]","{2,5}","World","((0) |(0)| )?","\\(|\\/|-|\\.|,","[0-9 ]","{1,10}","\\) |\\)|\\/|-|\\.|,","[0-9 ]","{2,10}","-|\\.|,|\\/","NUM","{0,5}"],number:["INT","{1,12}","Annex"],float:["INT","{1,7}","\\.|,|;|:|_","FIX","{1,2}","Annex"],ifloat:["INT","{1,7}","\\.|,|;|:|_","FIX","{1,2}"],pfloat:["PINT","{0,7}","(\\.|,|;|:|_)?","PFIX","{0,2}"],towns:["COUNTRY","{2,2}","World",";|-| |,|\\u2009","[0-9A-Z-]","{0,10}",";|,| |\\u2006","[\\w\\W]","{3,50}"],country:["[ A-Za-z-e-]","{5,46}","World"],list:["[\\w\\W]","{2,80}"],grouper:["Grouper"],selfgrouper:["Grouper","Free1","Informer"],title:["([Ladies and Gentlemen#n|Mrs.#f|Mr.#m|Ms. dr.#f|Mr. dr.#m|Ms. prof.#f|Mr. prof.#m|ownInput])"],clock:["([time|alarm|stop|count|fixit])?","Free0","PHOURS",":|\\.|,|;|-|_","PMINUTES",":|\\.|,|;|-|_","PSECONDS","Free1","Clock"],currency:["ifloat","Free3","Toggle","pfloat","Free5","World"],unit:["ifloat","Free4","Toggle","pfloat","Free0","([mm|mm])?"],isounits:["ifloat","Free4","Toggle","pfloat","Free0","([mm|mm])?","Free1","Unit"],vat:["float",";|#|_|\\u0024\\u2006","(["+lang.ownInputExtend.vat+"])","Free2","Toggle","pfloat","Annex","(\\u0024)?"],net:["float",";|#|_|\\u0024\\u2006","(["+lang.ownInputExtend.vat+"])","Free2","Toggle","pfloat","Annex","(\\u0024)?"],password:["PASSWORD","PASSWORD","PASSWORD","PASSWORD","PASSWORD","Eye","Free0","Free5"].concat(conf.puzzlePassword?["Password","Free0"]:"Free0"),passwordrepeat:["PASSWORD","PASSWORD","PASSWORD","PASSWORD","PASSWORD","Eye","Free0","Free5"].concat(conf.puzzlePassword?["Password","Free0"]:"Free0"),iban:["COUNTRY","{2,2}","World","Free0","IBAN","{2,2}","Free0","IBAN","{4,15}","Free0","IBAN","{5,20}"],salesident:["([not europe|DE])","Free0","[A-Z0-9]","{5,15}"],color:["#","HEX","{6,6}","PASSIVE","{0,6}"],date:["Free5","YEAR","-|\\.|,|;|:|_|\\/","MONTH","-|\\.|,|;|:|_|\\/","DAY","Calendar"],enddate:["date","End"],smalldate:["Free5","SMALLYEAR","-|\\.|,|;|:|_|\\/","MONTH","-|\\.|,|;|:|_|\\/","DAY","Calendar"],endsmalldate:["smalldate","End"],week:["Free3","YEAR","-W|-|\\.|,|;|:|_|\\/","WEEK","Calendar"],time:["HOUR",":|\\.|,|;|-|_","MINUTE","Time"],smalltime:["HOUR",":|\\.|,|;|-|_","MINUTE",":|\\.|,|;|-|_","SECOND","Time"],endtime:["time","End"],endsmalltime:["smalltime","End"],datetime:["date","Free0","T| |\\.|,|:|;|-|_|\\u2004\\u25F7","time"],smalldatetime:["smalldate","T| |\\.|,|:|;|-|_|\\u2004\\u25F7","time"],enddatetime:["datetime","End"],endsmalldatetime:["smalldatetime","End"],daysperiod:["DAYS","Free1","Days"],datedaysperiod:["date","(D|\\.|,|:|;|-|_|\\u2003)?","daysperiod"],timeperiod:["HOURS",":|\\.|,|;|-|_| ","MINUTES","Free1","Days"],smalltimeperiod:["HOURS",":|\\.|,|;|-|_| ","MINUTES",":|\\.|,|;|-|_","SECONDS","Free1","Days"],timedaysperiod:["DAYS","#|\\.|,|:| |;|-|_|\\u2004\\u25F7","HOURS",":|\\.|,|;|-|_| ","MINUTES","Free1","Days"],timeperiodpseudo:["PHOURS",":|\\.|,|;|-|_| ","PMINUTES","Free1","Days"],datedaysperiodpseudo:["date","Free0","(D|\\.|,|:|;|-|_|\\u2003)?","PDAYS","Free1","Days"],weekpseudo:["Free3","PYEAR","-W|-|\\.|,|;|:|_|\\/","WEEK","Calendar"]},d={SingleSelect:"\\uFDD0?",MultiSelect:"\\uFDD1?",Calendar:"\\uFDD2?",World:"\\uFDD3?",File:"\\uFDD4?",Toggle:"\\uFDD5?",Days:"\\uFDD6?",Fixpin:"\\uFDD7?",Clock:"\\uFDD8?",Switch:"\\uFDD9?",Unit:"\\uFDDA?",Password:"\\uFDDB?",ToggleSelect:"\\uFDDC?",Eye:"\\uFDDD?",Time:"\\uFDDE?",DynamicSelect:"\\uFDDF?",DynamicExtend:"\\uFDE0?",Free0:"\\uFDE1?",Free1:"\\uFDE2?",Free2:"\\uFDE3?",Free3:"\\uFDE4?",Free4:"\\uFDE5?",Free5:"\\uFDE6?",Free6:"\\uFDE7?",End:"\\uFDE8?",Grouper:"\\uFDE9?",Informer:"\\uFDEA?",Annex:"\\uFDEB?"},f=function(){var e={};for(var t in l)e[l[t].ident]=t;for(var t in d)e[d[t]]=t;return e}(),g=function(e,t){if(!u[e])return!1;if(!u[e][t]){if(!u[e].regexp){var n=conf.inputIsLocal?"local":"norm",i=a(e,n,!0);u[e].regexp=new RegExp(("(("+i.join("))((")+"))").replace(/\(\((.*?)\)\)/g,(function(e,t){return"(("+(l[t]?l[t].ident:d[t]||t.replace(/ownInput/g,"(.+)"))+"))"})).replace(/\)\)\(\(\{/g,"{")),u[e][n]=p(i)}u[e][t]||(u[e][t]=p(a(e,t)))}return u[e][t];function a(e,t,n=!1){var i="local"===t?lang.localTypes[e]||u[e]:u[e]||!1,r=[];if(i)for(var o=0;o<i.length;o++)u[i[o]]?r=r.concat(a(i[o],t)):r.push(n&&"["==i[o][0]?C(i[o]):i[o]);return r}},p=function(e){for(var t={},n=[],i=0,a=0;a<e.length;a++)r(e[a]);return n;function r(e){if(d[e])n.push({subAddon:e.charAt(0).toLowerCase()+e.slice(1),cN:n[i]&&!n[i].size?n[i].type:""});else{var a=!1,r=e.match(/^(\(?)(\[)?((([^\|]+\|)+[^\|]+)|(.+))\](\)(\?)?)?$/);l[e]||r||"["==e.charAt(0)||(n[i]||(n[i]={type:!1}),(a=e.match(/\{(\d+),(\d+)\}/))?n[i].size={min:$I(a[1]),max:$I(a[2])}:(a=e.replace(/^\((.*)\)\?/,"$1").split("|"),n[i].regexp=new RegExp("("+a.join("|")+")"),n[i].joinStr=a[0].replace(/\\/g,""),a=a.pop(),n.push({sepa:"\\u"==a.slice(0,2)?unescapeUnicode(a):n[i].joinStr,cN:n[i]&&"SELECT"!=n[i].id&&!n[i].size?n[i].type:""}))),a||(i=n.length,r?(e=r[1]?r[3]:r[0],r=(r[8]?"P":"")+(r[1]&&r[4]?"SELECT":"PATTERN")):r=e,n.push({type:e,size:!1,sepa:!1}),t[r]?r+=t[r]++:t[r]=1,n[i].id=r)}}},m=function(e,t,n,i,a){var r=e.getSub(t.id).check;return r.isdigit?(n=$I(n)+i,((n=r.extra(e,t,n,i))<r.min||n>r.max)&&(r.carry&&function(i){if(i){var o=$(i.id),s=o.value,c=l[r.carry].offer;D(o,"Carry"),o.value=""==s&&c?c:m(e,o,$I(s),n<r.min?-1:1,a),r.extra(e,t,r.max)}return!!i}(e.subs[r.carry])?(delayRemove(t,cssNS.keyCarry,1),r.step>1?n+=n<r.min?r.max+1:-r.max-1:n=n<r.min?r.max:r.min):(x.add(e,e.type.indexOf("daysperiod")>-1?"daysPeriod":"rangeError"),n=n<r.min?r.min:r.max)),r.value=n):n=r.extra(e,t,n,i),n=r.zero?zeroInt(n,r.maxCount):String(n),a||(!r.carry&&x.length?D(t,"DAY"==r.type||"YEAR"==r.type?"Hint":"Error"):!r.jump&&e.regexp.test(n)&&(activeOnChange=!1,$(e.id).value=n,activeOnChange=!0),x.length=0),n},h=function(e,t){var n=g(e,"norm"),i=g(e,"local"),a="",r="";if(t.length&&n.length&&JSON.stringify(n)!==JSON.stringify(i)){t=v(!1,e,t);for(var o=0;o<i.length;o++)i[o].id&&t[i[o].id]&&(r+=a+t[i[o].id],a=i[o].joinStr||"")}else r=t;return r},v=function(e,t,n,i,a){var r=n?String(n):"",o=r.length?g(t,i||"norm"):[],s={};if(r.length&&e&&t==e.type&&e.regexp&&!e.regexp.test(r)?r=!1:n=r,e&&"PASSIVE"==e.getSub(e.first).type)s.PASSIVE=n;else if(r&&r.length&&o.length)for(var c=0;c<o.length;c++)if(r=o[c].regexp?n.search(o[c].regexp):-1,o[c].id)if(r>-1)s[o[c].id]=n.slice(0,r),n=n.slice(r+1);else{if(now=r=l[o[c].type],r=n.match("^"+(r?r.ident:o[c].type).replace(/\]$/,"]+")),s[o[c].id]=r?r[0]:n,!r)break;n=n.slice(r[0].length)}else 0===r&&(n=n.replace(o[c].regexp,""));else if(n&&n.length)if(l[t])s[t]=n;else{if(!a)return v(e,t,n+".0",i,!0);console.warn("useLib hint: element (id:"+e.id+") value has wrong format:"+n.slice(0,-2)+"!")}return s},S=function(e,t,n,i){var a,r=v(e,t,n,i);for(t in r)e.subs[t]&&(a=$(e.subs[t].id))&&("SELECT"==t?setEleValue(a,[r[t]]):a.value=m(e,a,r[t],0))},b=function(e){var t=e.subs;return metaReaction[e.type]||metaReaction[t.DAY||t.MONTH?"date":t.HOUR||t.MINUTE||t.SECOND?"time":t.DAYS||t.HOURS||t.MINUTES||t.PDAYS||t.PHOURS||t.PMINUTES?"period":""]||!1},N=function(e,t,n,i){return t=metaReaction[e]?t.replace("%%","coverOpen"):"return false",["span",{CN:cssNS.button},["button",{CN:cssNS[e],T:lang[e+"Select"]?lang[e+"Select"][0]:n||null,MC:t,value:e},i||""]]},C=function(e){for(var t in shortnChars)e=e.replace(t,shortnChars[t]);return e},y=function(e){var t=function(e){var t="",n={};if(!e.length)return lang.allowedChars.xx;for(var i in lang.allowedChars)e=e.replace(new RegExp(i,"gi"),(function(e){return e=e.toLowerCase(),n[e]||(lang.allowedChars[e]&&(t+=lang.allowedChars[e]),n[e]=1),""}));n["a-z"]&&(e=e.replace(/[a-z]/gi,""));n["0-9"]&&(e=e.replace(/[0-9]/gi,""));return e.length?t+unescapeUnicode(e):t.slice(0,-2)||""}(e=function(e){return e.replace(/^\^|\$$/g,"").replace(/([^\\])?\\d/g,"$1[0-9]").replace(/\[(\\w\\W|\\W\\w)\]/g,"").replace(/([^\\])?\\w/g,"$1[a-z0-9_-]").replace(/\s|\\\\s(\*|\+)?/g," ").replace(/([^\\]?)\[(.+?[^\\])\](\{\d*,?\d*\}|(\+|\*)\??)?/gi,"$1$2").replace(/([^\\])?\((.+?)\)\?/g,"$1$2").replace(/\\([^\\])/g,"$1")}(typeCheck("RegExp",e)?e.source:e));return{charRegexp:(e=C(e)).length?new RegExp("["+e+"]+","g"):/.+/,chars:t}},D=function(e,t,n){e.value&&delayRemove(e,cssNS["key"+t],n||1),sound(conf.sounds["input"+t])},x=[];function L(e,t,n){for(var i,a="return useLib.call.%%(event,'"+e.id+"')",r=0,o=0,s=[],d=0;d<t.length;d++)f(t[d],u[n.type][d]);return s.length&&(s=["span",{CN:cssNS.isCover+" "+cssNS[/datetime|time|date/.exec(n.type.replace(/pseudo$/,""))||n.type.replace(/\d+$/,"")]}].concat(s)),s;function f(t,u){if(t.subAddon)"end"==(i=t.subAddon)?n[i]=!0:"annex"==i?(i=$A(e,"data-ul"))&&f(i,""):"free"==i.slice(0,4)?f(i,t.cN||"",e.id+"free-"+o++):s.push(N(i,a));else if(t.sepa)f(t.sepa,t.cN||"");else if(t.type){var d=n.initSub(e.id+idCover+"-"+r++,t.id);l[t.type]||t.size?function(t,i){var r="PASSIVE"==t.type,o=$A(e,"size")||null;s.push([o?"textarea":"input",{type:"text",id:t.id,CN:i||(r?" "+cssNS.noUserSelect:""),rows:o,T:lang[n.type]?lang[n.type][0]:t.chars,disabled:t.check.disabled?"disabled":null,readonly:r?"readonly":null,min:t.check.min||t.check.minCount||null,max:t.check.max||t.check.maxCount||null,inputmode:t.check.isdigit?"numeric":null,name:conf.noscript?t.id:null,pattern:conf.noscript?t.check.charRegexp:DOM.isTouch&&t.check.isdigit?"[0-9]*":null,autocomplete:"off",KD:r?null:a.replace("%%","coverBeforeInput"),KU:r?null:a.replace("%%","coverAfterInput"),MD:r&&"singleSelect"!==n.type?null:a.replace("%%","coverOnMouseDrag"),MC:r?a.replace("%%","coverOpen"):null,OF:r?null:a.replace("%%","coverOnFocus"),OB:r?"useLib.setStatus(this,'focused',false);":a.replace("%%","coverCheckOnBlur")}])}(function(i,a,r){var o,s=i.check,u=b(n);u&&u.doReaction&&(s.doReaction=u.doReaction(e,n));for(var d in c)f(d);s.step=1,s.disabled=s.disabled||e.disabled,("INT"==a||"ZERO"==a||"FIX"==a)&&(o=g()||2,"FIX"==a?(s.min=0,s.max=$I(repeat("9",o))):(s.min=$I(n.min)||0,s.max=min($I(n.max)||$I(repeat("9",r.max||5)),900719925474099)),s.step=p(n.step,o));return s.isdigit="PASSWORD"!=a&&s.max||s.min,s.sepaRegexp=t.regexp,s.minCount=!s.isdigit&&r?r.min:s.min>9?String(s.min).length:1,s.maxCount=!s.isdigit&&r?r.max:max((s.max+"").length,(s.min+"").length),max(5,s.maxCount),function(e,t,n){n&&(n=y(n),e.check.charRegexp=n.charRegexp,e.chars=(lang.inputName[t]?lang.inputName[t]+": ":"")+n.chars)}(i,a,s.isdigit?s.min<0?"-0-9":"0-9":!!t.size&&(l[a]?l[a].ident:a)),i;function f(t){var n=!!l[a]&&l[a][t];!1!==n&&void 0!==n&&(s[t]="function"==typeof n&&"extra"!=t?n(e):n)}function g(){var e=str2obj("step min max value"),t=0;for(var i in e)n[i]&&(t=max(t,a(n[i])));return t;function a(e){return(e=String(e).match(/[\d]*\.([\d]*)/))?e[1].length:0}}function p(e,t){return(e=!!e&&parseFloat(e).toFixed(t))&&1!=e?(n.step=parseFloat(e),n.stepZeroshift=parseFloat(n.value)%n.step,"FIX"==a?(e*=s.max+1,String(e).length>t&&(e=$I(String(e).slice(-t)),s.disabled="disabled"),e):Math.ceil(e)):1}}(d,t.type,t.size),l[i]?i:null):t.id.indexOf("SELECT")>-1&&function(e,t){var n=[];u=u?u.slice(2,-2).split("|"):"",u=!conf.inputIsLocal&&t.length==u.length&&u;for(var i=0;i<t.length;i++)n.push(["option",{CN:"ownInput"==t[i]?"ownInput":null,value:u&&u.length?u[i]:t[i],selected:0==i?"selected":null},t[i].replace(optionExtRegEx,"")]);s.push(["select",{id:e.id,size:1,OB:a.replace("%%","coverCheckOnBlur")}].concat(n))}(d,t.type.split("|"))}function f(e,t,n){n&&(e=$I(e.slice(4)),t+=" "+cssNS.free+e,e=repeat(" ",e)),t=t.trim()+" "+cssNS.sepa,s.push(["span",{CN:t,id:n||null},e.length?["span",{},e]:null])}}}return x.add=function(e,t){var n={};t&&(n[$(e.id).name]=t,this.push(n))},{getContent:function(n,i,a){var r,o=getFormDef(n),s="pattern"==i?function(n){if("(("==n.slice(0,2)&&"))"==n.slice(-2)){for(t in u)if(g(t,"local"),"/"+n+"/"===String(u[t].regexp))return o.type=t,g(t,"local");return o.type="pattern"+e++,u[o.type]={regexp:new RegExp(C(n)),norm:p(n.replace(/\(\((.+?)\)\)/g,(function(e,t){return"(("+(f[t]||f[t.replace(/\{[\d\,]+\}$/,"")]||t)+"))"})).replace(/(\{\d+,\d+\})/g,"))(($1").slice(2,-2).split("))(("))},u[o.type].local=u[o.type].norm,u[o.type].norm}return!1}(a):g(i,"local");return!!(s&&u[o.type]&&(o=function(e){return e.ids=[],e.subs={},e.check={},e.first=null,e.getId=function(e){return!!(e=this.subs[e]||this.subs["P"+e]||this.subs["SMALL"+e])&&e.id},e.getSub=function(e){return!(!e||!e.length)&&(e==this.id?this:!!this.ids[e]&&this.subs[this.ids[e]])},e.initSub=function(e,t){var n=this.ids.shift();return n&&(this.getSub(n).next=e),this.ids.push(e),this.ids[e]=t,this.subs[t]={id:e,type:t,next:!1,before:n||!1,check:{type:t,id:e,regexp:!1,extra:function(e,t,n){return n}}},this.first||(this.first=e),this.last=e,this.subs[t]},e}(o),o.regexp=u[o.type].regexp,(r=L(n,s,o)).length))&&function(){var e,t,i=b(o);$CN.contains($P(n),cssNS.hasCover)||($CN.add($P(n),cssNS.hasCover),$CN.add(n,cssNS.covered),DOM.insertAfter(n,$CE(r)));(t=$(o.first))&&(e="PASSIVE"==o.getSub(t.id).type||o.type.indexOf("Select")>-1);$A(n,"tabindex")>-1&&$A(t,"tabindex",$A(n,"tabindex"));$A(n,"tabindex","-1"),e?t.value="SELECT"==n.tagName?metaReaction.singleSelect.getText(n,o.value,!0):o.value.join(", "):S(o,o.type,o.value[0],conf.inputIsLocal?"local":"norm");i&&i.init&&i.init(n,o);t&&$E(labels[n.id],"MC",(function(){e?t.click():(t.selectionStart=0,t.selectionEnd=n.value.length,t.focus())}));return r.length}()},types:u,setValue:S,getValue:function(e,t,n,r){if(e.type.indexOf("password")>-1)return e.value[0];var o=g(t,n),s=!1,l=!1,c="";if(o.length){for(var u,d=0,f="";d<o.length;d++)o[d].id&&("P"!=o[d].id.charAt(0)||o[d].id.indexOf("PATTERN")>-1)&&(u=$(e.subs[o[d].id].id))?(c+=f+p(),f=o[d].joinStr||""):0==d&&o[d].joinStr&&(f=o[d].joinStr);e.hasEmpty=l}return s?c:"";function p(){var t=o[d].id.indexOf("SELECT")>-1?u.value:function(t){t.length&&(t=m(e,u,t,0,r),0!==compare(t,u.value)&&(u.value=t));return e.getSub(u.id).check.space?t.replace(/\s/g,""):t}(u.value);return t.length?("norm"==n&&"SMALLYEAR"==o[d].type&&(t+=t>i?1900:2e3),s=!0):(l=!0,t=a.c),t}},getLocal:h,getYear:r,checkValue:m,keyMsg:D,errorList:x,listSelect:!1,getTypeRegexp:function(e,t){return e=e.toLowerCase(),!!g(e,t?"local":"norm")&&u[e].regexp},pattern2Char:y,replaceShortn:C}}(),doEvent=(fireChange=function(e){fD&&e&&fD.first==fD.last&&(stopChange=!0,dispatchEvent(e,"change"),stopChange=!1)},init=function(t,n){eC!==t&&t&&(e=$(n),fD=getFormDef(e),eSub=sC=!1,fD.getSub&&(eSub=fD.getSub(t.id))&&(sC=eSub.check,doReaction("init",t))),cP=(eC=t)&&eC.selectionStart?eC.selectionStart:0},doReaction=function(e,t,n,i){return sC.doReaction&&sC.doReaction[e]?sC.doReaction[e](t,n,i):"onchange"==e&&(fireChange(t),n)},setRotor=function(e){var t=String(eC.value),n=sC&&sC.doReaction&&sC.doReaction.onrotor;if(cover.listSelect&&-1==e)$(cover.listSelect).firstChild.focus();else if(eC.type.indexOf("password")<0)return cP=min(t.length-1,cP),n?eC.value=doReaction("onrotor",eC,t,e):sC&&sC.isdigit?(eC.value=t.length?String(function(t,n){return cP+=t<0&&0==cP?1:0,e="YEAR"==sC.type||Math.abs(sC.max-sC.min)<101?e:e*Math.pow(10,n-cP-1),Math.abs(e)>1&&Math.abs(t+e)<Math.abs(t/10)&&(e/=10),t=cover.checkValue(fD,eC,t,e),cP+=t.length-n,t}($I(t),t.length)):cover.checkValue(fD,eC,sC.offer||(e<0?sC.max:sC.min),0),t.length||(cP=max(eC.value.length-1,0))):eC.value=function(t){var n,i=sC&&sC.charList?sC.charList:fD.charList,a=t[cP]||t[0]||"a";return i||(i=r(sC||fD)),n=i.indexOf(a)+e,t[cP]=i[n<0?i.length-1:n>=i.length?0:n],t.join("");function r(e){var t=e.charRegexp==/.+/?conf.charDefault:String(e.charRegexp).slice(2,-4);return t=unescapeUnicode(t).replace(/([a-z0-9])-([a-z0-9])/gi,(function(e,t,n){n=n.charCodeAt(0);for(var i=t.charCodeAt(0)+1;i<=n;i++)t+=String.fromCharCode(i);return t})).split("").sort().filter((function(e,t,n){return n.indexOf(e)==t})),e.charList=t,t}}(t.split("")),eC.value=doReaction("onchange",eC,eC.value,!0),eC.setSelectionRange&&eC.setSelectionRange(cP,cP),!1;return!0},setInput=function(e,t,n,i){init(e,t),n=String(n||e.value).replace(/^\s+/,"");var a=sC.sepaRegexp?n.search(sC.sepaRegexp):-1;if(i=eSub&&eSub.next&&(sC.jump||a>-1)&&(i||!String($(eSub.next).value).length),n=function(t,n,a){if(t.length){var r,o=0;if(n>-1&&(0==n?t=t.slice(1):(a.next=t.slice(n+1)||"",t=t.slice(0,n))),r=t.slice(0),sC.upper?t=t.toUpperCase():sC.lower&&(t=t.toLowerCase()),n=t.slice(0),(t=sC.charRegexp?(t.match(sC.charRegexp)||[""]).join(""):t)!=n&&cover.keyMsg(e,"Hint"),(sC.space?t.replace(/\s/g,"").length:t.length)>sC.maxCount||!a.next&&n.length>sC.maxCount){o=0;for(var s=0,l=sC.maxCount;o<l;s++)n.charAt(s)===t.charAt(o)&&(o++,sC.space&&" "==n.charAt(s)&&l++);(t=sC.zero&&!i&&l-t.length==1&&"0"==t.charAt(0)?t.slice(1):t.slice(0,o)).length&&!a.next&&(a.next=r.slice(s))}a.value=t,a.digit=!!sC.isdigit&&$I(t.replace(/\s/g,""))}return a}(n,a,{value:"",next:!1,digit:0}),n.value.length?n.digit&&n.digit>sC.max&&(n.value=sC.max,cover.keyMsg(e,"Error")):sC.extra(fD,e,"",0),e.options?setEleValue(e,[n.value]):e.value=doReaction("onchange",e,n.value,!1),!1!==n.next){if(!eSub.next||!i&&n.next.length)return cover.keyMsg(e,"Error"),!1;(e=$(eSub.next)).focus(),setInput(e,t,n.next,i)}return!0},clearInput=function(e,t){if(e.subs){for(var n in e.subs)e.subs[n].type.indexOf("SELECT")<0&&($(e.subs[n].id).value="",$A($(e.subs[n].id),"value",""));n=$(e.first),t?n.value=t:((sC=e.getSub(n.id).check)&&(sC.extra(e,n,"",0),doReaction("onchange",n,"",!1)),e.subs.COUNTRY&&($(e.subs.COUNTRY.id).value=e.world||conf.country)),setFocus(n)}},setClearer=function(e,t){var n=$(e),i=(getFormDef(n),$(cssNS.clearer)),a=$(cssNS.grouper);t?(i||(i=$CE(["div",{id:cssNS.clearer}])),DOM.insertBefore(n,i),$A(n,"data-ul-grp")?a||(a=$CE(["div",{id:cssNS.grouper,title:lang.delete}])):(DOM.removeNode(a),a=null),i.onclick=function(){n.value="",dispatchEvent(n,"change"),setClearer(e,!1)},a&&(a.onclick=function(){metaReaction.grouper.changeGrouper(n,"removeActive")},DOM.insertBefore(n,a))):(DOM.removeNode(i),DOM.removeNode(a))},{onKey:{arrow:function(e,t,n){return e.preventDefault(),init(e.currentTarget,t),setRotor(38==n?1:-1)},input:function(e,t){var n,i=e.keyCode;return e.ctrlKey||e.metaKey||!(0==i||8==i||32==i||46==i||i>47&&i<112||i>137)||(t=t||e.currentTarget.id,n=getFormDef($(t)),e.shiftKey&&46==i?$(t).value="":n.subs?n.type.indexOf("password")<0&&n.regexp.test(e.currentTarget.value)?(clearInput(n,e.currentTarget.value),setInput($(n.first),t),i=13):setInput(e.currentTarget,t):function(e){var t=(e.value.match(n.charRegexp)||[""]).join("");t!=e.value?(cover.keyMsg(e,"Hint"),e.value=t):n.max&&n.max<t.length&&(cover.keyMsg(e,"Error"),e.value=t.slice(0,n.max))}(e.currentTarget)),13!==i}},onMouse:function(){var e,t,n,i,a,r,o,s,l,c,u,d,f,g,p={init:function(t){h=t,D.body.appendChild(m),(v=$S(m)).zIndex=$GS(t,"zIndex")+1,e=function(){var e=DOM.getRect(t),n=DOM.textWidth("abcdefghij",cssNS.miniCursor)/10,i=$GS(t,"text-align"),a=e.x+o("left"),r=e.x+e.w-o("right");return v.top=$I(e.y+o("top"))+"px",function(e,t){return max(a,min(r,"left"==i||"start"==i?a+n*cP:"right"==i||"end"==i?r-n*(t-cP):a+(r-a)/2+n*(cP-t/2)))};function o(e){return parseFloat($GS(t,"border-"+e+"-width"))+parseFloat($GS(eC,"padding-"+e))}}(),$CN.add(m,cssNS.show)},set:function(t){t?(t!=h&&this.init(t),v.left=$I(e(cP,t.value.length))+"px"):($CN.remove(m,cssNS.show),h=!1)}},m=$CE(["div",{id:cssNS.miniCursor}]),h=!1,v=!1,S={init:function(){var e="useLib.call.miniKeyboard(event,",t=lang.miniKeyBoard;return $CE(["div",{id:cssNS.miniKeyboard,CN:cssNS.noUserSelect,S:"margin-top:0.3em;"},n(37,"◄",t[0]),n(39,"►",t[1]),n(38,"▲",t[2]),n(40,"▼",t[3]),n(8,"⌫",t[4]),n(45,"↪",t[5]),["div",{CN:cssNS.closer,MD:e+"0)"}]]);function n(t,n,i){return["div",{MD:e+t+",0)",MU:e+"-1)",T:i},["span",{},n]]}},set:function(e,t){function n(e){$P(b).contains(e.target)||S.set(e,!1)}t?(DOM.insertAfter($P(eC),b),$CN.add(b,cssNS.show),$E(D,"focusin",n)):(D.body.appendChild(b),$CN.remove(b,cssNS.show),$E(D,"focusin",n,-1)),p.set(!!t&&eC)}},b=S.init(),N=!1,C=(o=function(){eC.value=doReaction("onrotor",eC,$I(sC.value),g)||cover.checkValue(fD,eC,$I(sC.value),g),eC.value=doReaction("onchange",eC,eC.value,!0),N=setTimeout(o,f)},s=function(e){for(var t=c;t>=0;t--)e?(u[t]=$CE(["div",{CN:cssNS["elastic"+(t==c-2?"Head":t==c?"Center":"Track")]}]),D.body.appendChild(u[t]),t==c&&($S(u[t]).width=a.w+"px",DOM.setPos(u[t],$I(a.x-a.w/2),$I(a.y-u[t].offsetHeight)))):u[t]&&(DOM.removeNode(u[t]),u[t]=null)},l=$I(conf.elasticStep*(DOM.isTouch?1.5:1)),c=7,u=Array(c+1),d=[[0,666],[1,666],[1,333],[1,125],[11,125],[111,125],[1111,125],[11111,125]],f=100,g=1,{init:function(){var e=eC.getBoundingClientRect();function n(e){return e?String(Math.abs($I(e))).length:0}t=eC.id,doReaction("init",eC)||(sC.value=$I(eC.value)),i=max(min(max(n(sC.min),n(sC.max))+2,7),3),(a=DOM.getRect(eC)).ox=a.x-Math.round(e.left),a.oy=a.y-Math.round(e.top),a.x+=a.w/2,a.y+=a.h,W.visualViewport&&(a.x+=W.visualViewport.offsetLeft,a.y+=W.visualViewport.offsetTop),$CN.add(eC,cssNS.elastic),$CN.add(eC,cssNS.noUserSelect),s(!0)},set:function(e){r=DOM.getCoord(e),t!=eC.id&&C.init(r),r.x-=a.x-a.ox,r.y-=a.y-a.oy,function(e){for(var t,n=0,i=c-1;n<i;n++)t=(1-n/i)*max(min(e,l*c),c),DOM.setPos(u[n],$I(a.x+r.x*t-1.25-(W.visualViewport?W.visualViewport.offsetLeft:0)),$I(a.y+r.y*t-u[n].offsetHeight/2-(W.visualViewport?W.visualViewport.offsetTop:0)))}(function(){var e=Math.sqrt(r.x*r.x+r.y*r.y),t=d[e<$I(l/3)?0:min(i,Math.ceil(e/l))];return r.x/=e,r.y/=e,$CN[r.x<0?"add":"remove"](u[c-2],cssNS.minus),g=r.x<0?-t[0]:t[0],f=t[1],N||o(),e}())},stop:function(){clearTimeout(N),t=N=!1,$CN.remove(eC,cssNS.elastic),$CN.remove(eC,cssNS.noUserSelect),s(!1)}});return{drag:function(e,i){return e.preventDefault(),e.stopPropagation(),init(e.currentTarget,i),"PASSIVE"!=sC.type&&(t=!!(sC.isdigit||sC.doReaction&&sC.doReaction.onrotor),n="wait",$E(D.body,"MM",doEvent.onMouse.init),$E(D.body,"MU",doEvent.onMouse.stop),setTimeout((function(){"start"==n&&(n=!1)}),600),!0)},init:function(e){n?DOM.coordInRect(e,eC)||(n=t?"start":"mini"):C.set(e)},stop:function(e){$E(D.body,"MM",doEvent.onMouse.init,-1),$E(D.body,"MU",doEvent.onMouse.stop,-1),n?"wait"!=n?(S.set(e,1),D.activeElement.blur()):(p.set(!1),eC.focus()):C.stop()},miniKey:function(e,t,n){if(e.preventDefault(),-1==t)clearTimeout(N),N=!1;else if(0==t)S.set(e,0),eC.focus();else{var i=eC!=D.activeElement;8==t&&0==cP&&(t=37),8==t||45==t?function(e){var t=String(eC.value).split("");t.splice(cP,e?0:1,e?t[cP]:""),eC.value=t.join(""),cP+=e?1:-1}(45==t):38==t||40==t?setRotor(38==t?1:-1):"SELECT"!=eC.tagName&&function(e){0==cP&&e<0||cP==eC.value.length&&e>0?e<0&&eSub.before||e>0&&eSub.next?(init($(eSub[e<0?"before":"next"]),fD.id),e>0&&(cP=0,eC.setSelectionRange(cP,cP))):(S.set(0,0),setCursorStep(eC,t)):(cP+=e,eC.setSelectionRange(cP,cP))}(39==t?1:-1),i?(eC.blur(),p.set(eC)):p.set(!1),N=setTimeout((function(){doEvent.onMouse.miniKey(e,t,++n)}),n<3?400:100)}},miniOff:function(){S.set(0,0)}}}(),onblur:function(e,t){var n,i=$(t),a=getFormDef(i),r=i.value,o=!1;if(e=e.target,cover.errorList.length=0,e&&e.value.length){for(var s in e.value=cover.checkValue(a,e,e.value,0),a.hasEmpty=!1,a.subs)if(("P"!=s.charAt(0)||s.indexOf("PATTERN")>-1)&&(0===(n=$(a.subs[s].id).value).length||a.subs[s].check.min>0&&a.subs[s].check.zero&&!/[^0]/.test(n))){a.hasEmpty=!0;break}(n=a.getSub(e.id).check).doReaction&&n.doReaction.onblur?n.doReaction.onblur(e,!a.hasEmpty&&o):n.doReaction&&n.doReaction.onchange||fireChange(i)}else $CN.remove(e,cssNS.error);o=cover.getValue(a,a.type,conf.inputIsLocal?"local":"norm"),a.regexp&&!a.regexp.test(o)||dialog.removeError(i,r!=o?e:null),setClearer(t,!1),activeOnChange=!1,i.value=o,activeOnChange=!0,$CN.remove(e,cssNS.focused),setStatus($(t),"focused",!1)},setInput:setInput,clearInput:clearInput,setClearer:setClearer}),cP,e,eC,fD,eSub,sC,fireChange,init,doReaction,setRotor,setInput,clearInput,setClearer;call.uLinit("miniKeyboard",doEvent.onMouse.miniKey),call.uLinit("coverBeforeInput",(function(e,t){var n=e.keyCode,i=!0;return e.ctrlKey||e.metaKey||"TEXTAREA"==e.currentTarget.tagName||(38==n||40==n?i=doEvent.onKey.arrow(e,t||e.currentTarget.id,n):13==n&&(e.stopPropagation(),setCursorStep(e.currentTarget,39,e),i=!1)),i})),call.uLinit("coverAfterInput",doEvent.onKey.input),call.uLinit("coverOnMouseDrag",doEvent.onMouse.drag),call.uLinit("coverOpen",(function(e,t,n){var i=$(t),a="BUTTON"==e.currentTarget.tagName?e.currentTarget.value:getFormDef(i).type,r=metaReaction[a];return r&&!i.disabled&&(doEvent.onMouse.miniOff(),r.doButton?r.doButton(e,$(t)):(n||r.getContent)&&function e(){var o=n||r.getContent(i,a);o&&-1!=o?(typeCheck("Array",o)&&(o=["form",{name:t+cssNS.modal,"data-ul":a,CN:cssNS[a]}].concat(o)),dialog.setModal(t,a,"draggable closable",o,getLabelText(i)),r.getValue&&r.getValue(i,a),setStatus(i,"focused",!0,!0)):setTimeout(e,400)}()),!1})),call.uLinit("coverCheckOnBlur",doEvent.onblur),call.uLinit("coverOnFocus",(function(e,t){t=t||e.currentTarget.id.replace(/uLcover-\d+$/i,""),doEvent.setClearer(t,!0),setStatus($(t),"focused",!0)}));var activeTT=null;call.uLinit("foldLock",(function(e){e.stopPropagation(),$CN.toggle(e.currentTarget,cssNS.locked)})),call.uLinit("tabs",(function(e){for(var t=$P(e,2).children,n=0;n<t.length;n++)if($CN.contains(t[n],cssNS.show)){$CN.remove(t[n],cssNS.show);break}return $CN.add($P(e,1),cssNS.show),!1})),call.uLinit("zoomImage",(function(e){if(e.firstChild.classList.contains(cssNS.sizer))useLib.DOM.removeNode(e.firstChild);else{var t=D.createElement("img");t.src=e.firstChild.src,t.className=cssNS.sizer,t.onload=function(){useLib.DOM.insertBefore(e.firstChild,t)},e.firstChild.watch("src",(function(t,n,i){return e.firstChild.classList.contains(cssNS.sizer)&&setTimeout((function(){e.firstChild.src=i}),10),i}))}}));var dynamicSelects={},formDef=[],getFormDef=function(e,t){if(e&&e.form&&"OPTION"!=e.tagName&&"LABEL"!=e.tagName){var n=formDef[e.form.name];return n&&n[e.name]?n[e.name]:(n||(n=formDef[e.form.name]={}),e.name&&e.name.length||$CN.contains($P(e),cssNS.isCover)?(n[e.name]||(n[e.name]={isInit:{},value:[],resetValue:[],onCalc:!1}),n[e.name]):(console.warn("useLib hint: element (tagName:"+e.tagName+", id:"+e.id+")has no name!"+(t||"")),{}))}return!1},statusAttr=str2obj(conf.statusSupport),valueAttr=function(e){for(var t in e)statusAttr[t]?delete statusAttr[t]:delete e[t];return e}(str2obj("type value resetValue mnemonic")),normAttr=str2obj("min max step data-ul"),mnemonics=[],labels=[],fN="",activeOnChange=!0,strParse=function(e){return"string"==e&&/\{\[/.test(e)?JSON.parse(e):e},pushAttr=function(e,t){return e=e&&""!=e[0]?e:[],typeCheck("String",t)&&-1==e.indexOf(t)&&e.push(t),e},tempStatus={e:null},setStatus=function(e,t,n,i){if(e&&("changed"!=t||!$A(e,"disabled")||"focused"==t&&!internChange)){if(internChange=!0,i&&-1!=i&&tempStatus.e&&t==tempStatus.s&&setStatus(tempStatus.e,tempStatus.s,!1,-1),!0===i&&(tempStatus={e:e,s:t}),n&&"focused"==t&&(lastActive=e),$CN[n?"add":"remove"](e,cssNS[t]||t),labels[e.id]&&$CN[n?"add":"remove"](labels[e.id],cssNS[t]||t),"required"==t)$A(e,t,n&&conf.noscript?"required":-1),$A(e,"aria-"+t,n?"true":"false"),getFormDef(e).required=!!n;else if("disabled"==t){if($CN.contains($P(e),cssNS.hasCover)){var a=getFormDef(e);for(var r in a.subs)$A($(a.subs[r].id),t,n?"disabled":-1)}$A(e,t,n?"disabled":-1)}else"changed"==t&&$CN.contains(e.form,cssNS.cloud)&&$CN[$Q(e.form,"form ."+cssNS.changed,1)?"add":"remove"](e.form,cssNS.changed);internChange=!1}},internChange=!1,reInitValues=!1,onchange=function(e,t){var n=!!(e=e.target||e).form&&formDef[e.form.name];if(n&&!internChange&&(n=n[e.name])){var i,a,r="checked",o='[name="'+e.name+'"]',s="radio"==e.type?"r":"checkbox"==e.type&&"c";if(("select-one"==e.type&&(a=$Q(e.form,"[type=radio]"+o+":checked")).length||"r"==s&&(a=$Q(e.form,"select"+o)).length&&"select-one"==a[0].type)&&(internChange=!0,"r"==s?((o=a[0].selectedIndex)>-1&&$A(a[0].options[o],"selected",-1),$CN.contains(a[0],cssNS.covered)&&($(n.first).value="")):($A(a[0],r,-1),a[0].checked=!1),internChange=!1),t=void 0===t?getEleValue(e):typeCheck("Array",t)?t:[t],reInitValues?(i=!1,valueAttr.resetValue&&(n.resetValue=t)):("c"==s?(i=n.resetValue.indexOf(e.value),i=(r=void 0!==e[r]?e[r]:$A(e,r))?i<0:i>-1):n.resetValue&&(i=0!==compare(t.toString(),n.resetValue.toString())),i&&(/useLib/i.test(t[0])&&!$("uL_useLib")&&(lang.useLib[1]=lang.useLib[1].replace(/%%/,copyright+", Version "+useLibVersion),dialog.setMsg("hint","useLib",0,12e3)),n.storeValue=t.slice(0),s||$A(e,"value",t[0]&&t[0].length?t[0]:-1))),setStatus(e,"changed",i),n.value=t,"r"==s&&(setStatus(n.activeRadio,"changed",0),n.activeRadio=e),e.name&&e.name.length&&!$A(e,"oncalc")&&function(){var t=$P(e,2),n="";$CN.contains(t,cssNS.dynlist)&&(t=$P(t,1));for(var i,a=0,r=$Q(t,"[oncalc]"),o="";a<r.length;a++)(i=$A(r[a],"oncalc")).indexOf("useLib.call.dynList.calcIt")>-1?(o=!/\.count$|_\d_$/.test(r[a].name))&&(o=e.name.match(/\.\w+$/))&&(o=r[a].name.indexOf(o[0]+".")>-1):(n=i.match(/('|")([\w,]+)\1/))&&(n=n[2],o=e.name.match(new RegExp(".("+n.replace(/,/g,"|")+")$"))),o&&setTimeout(s(i.replace(/\([^\)]+\);?/,""),n,e,r[a]),0);function s(e,t,n,i){return function(){uLeval(e,t,n,i)}}}(),!0===activeOnChange&&$CN.contains(e,cssNS.covered)&&n.getSub&&(internChange=!0,t.join(", ").length?"PASSIVE"!=n.type&&cover.setValue(n,n.type,t.join(", "),conf.inputIsLocal?"local":"norm"):doEvent.clearInput(n),(r=metaReaction[n.type])&&r.setValue&&("singleSelect"==n.type||"multiSelect"==n.type||"dynamicSelect"==n.type||"dynamicExtend"==n.type?r.getText(e,t,!0):r.setValue(e,t.length>1?t:t[0])),internChange=!1),$CN.contains(e,cssNS.notDone)){a="radio"==e.type?$Q(e.form,'[name="'+e.name+'"][type="radio"]'):[e];for(var l=0;l<a.length;l++)$CN.remove(a[l],cssNS.notDone),$CN.remove(a[l],cssNS.error)}$A(e,"onchange")&&$CN.contains($P(e),cssNS.hasCover)&&setTimeout(function(e){return function(){try{e.onchange()}catch(e){}}}(e),750)}},initStatusControl=function(e){var t=getSelectionAttr(e);"selected"==t&&(e.watch("selectedIndex",(function(t,n,i){return e.options[i]&&onchange(this,e.options[i].value),i})),t="value"),e.watch(t,(function(t,n,i){return i="file"==e.type&&i.length?n:i,onchange(e,i),i})),e.watch("disabled",(function(t,n,i){return setStatus(e,"disabled",!!i),i})),e.watch("required",(function(t,n,i){return setStatus(e,"required",!!i),i})),$E(e,"radio"==e.type?"MC":"OC",onchange)},initMnemonic=function(e,t){var n=labels[e.id],i=$T(n,conf.mnemonicsMarker),a=!(!t[t.count]||!t[t.count].length)&&t[t.count][0],r='<span style="display:inline-block;width:0;">',o=!1;if(!a){t[t.count]=[];for(var s=0;s<i.length;s++)o=i[s].textContent.trim().replace(/(ctrl|alt|tab)\s*\+/gi,(function(e,t){return"\\"+t.charAt(0)})),t[t.count].push(o),mnemonics[o]=e.id;a=t[t.count][0]}if(a&&a.length>1&&i[0].innerHTML.indexOf(r)<0)for(a=a.split("").join(r+"&#8288;</span>"),i?i[0].innerHTML=a:DOM.insertBefore(n.firstChild,$CE([conf.mnemonicsMarker,{},a]));i.length>1;)DOM.removeNode(i[1])},checkInit=function(e,t){return e.isInit||(e.isInit={}),!e.isInit[t]&&(e.isInit[t]=!0,!0)};if(conf.dataManagePath&&conf.dataManagePath.length)for(var i=0,n,a;i<D.forms.length;i++)n=D.forms[i].name,a=D.forms[i].action,n&&n.length&&a&&a.length&&"#"!=a&&ajax(conf.dataManagePath+"?method=get&formname="+n+"&action="+a,(function(e){setJSONValues(JSON.parse(e))}),"JSON",2500,!0);call.uLinit("taskstep",(function(e,t){var n=conf.tasksteps[0],i=-1;n.map((function(t,n){$CN.contains(e,cssNS[t])&&(i=n)})),i>-1&&($CN.remove(e,cssNS[n[i]]),getFormDef(e).task=!1),(t||i<n.length-1)&&($CN.add(e,cssNS[t||n[i+1]]),getFormDef($($A(e,"for"))).task=t||n[i+1])}));var ownInput=function(){function e(e,t=!1){var n,i="^["+conf.charDefault+"]+$",a=/^\d+(\.\d+)?(cm|mm|in|px|pt|pc|em|ex|ch|vw|vh|%)?$/,r=!1,o=!1,s=!1;if("OPTION"==e.tagName&&(o=e,e="SELECT"==$P(e).tagName?$P(e,1):$P(e,2)),"SELECT"==e.tagName){if(!(o||-1!=e.selectedIndex&&(o=e.options[e.selectedIndex])&&$CN.contains(o,"ownInput")))return!0;n=$A(e.options[0],"value")}else n=$A($Q(e.form,'[name="'+e.name+'"]',1),"value");if(i=n.match(a))s=i[2]||!1,i=a.source.replace(/\([^\+]+\)/,s?"("+s+")":"");else if(!t&&(n=n.match(optionExtRegEx))&&(a=e.name||$P(e,1).previousSibling.name)){for(var l in lang.ownInputExtend)if((r=a.indexOf(l))>-1){r=lang.ownInputExtend[l];break}r=-1!=r&&{ex:r,active:n[1]}}function c(t){var n=conf.beforeOwnInput+lang.ownInput[0];!1===t&&(t=a),t.length&&"ownInput"!=t?(s&&t.indexOf(s)<0&&(t+=s),n=conf.beforeOwnInput+t.replace(optionExtRegEx,"")):t="ownInput",o&&"OPTION"==o.tagName?(o.value=t,o.text=n,dispatchEvent(e,"change")):(labels[e.id].lastChild.data=n,$A(e,"value",t),$A(e,"checked","ownInput"==t?-1:"checked"),e.checked="ownInput"!=t),ownInput.active=!1}a=n=$A(o||e,"value"),"ownInput"==n?n="":(r&&(r.active=n.match(optionExtRegEx)[1]),n=n.replace(optionExtRegEx,"")),t?c(t):(ownInput.active=!0,dialog.prompt("ownInput",c,n,i,r))}return call.uLinit("ownInput",(function(t,n){ownInput.active||(n&&"SELECT"==t.tagName?setTimeout((function(){$CN.contains(t.options[t.selectedIndex],"ownInput")&&e(t,!1)}),2e3):e(t,!1))})),{init:function(e){for(var t=$Q(e,"[value=ownInput],.ownInput"),n=conf.beforeOwnInput,i=0;i<t.length;i++)"OPTION"==t[i].tagName?a(t[i]):r(t[i]);function a(e){e.text.indexOf(n)<0&&(e.text=n+("ownInput"==e.value?lang.ownInput[0]:e.value)),$A($P(e),"OC","useLib.call.ownInput(this,0)"),$A($P(e),"MC","useLib.call.ownInput(this,1)"),$CN.add(e,"ownInput")}function r(e){if(e="INPUT"==e.tagName?e:e.firstChild,labels[e.id]){var t=labels[e.id].lastChild.data;t.indexOf(n)<0?labels[e.id].lastChild.data=n+("ownInput"==e.value?lang.ownInput[0]:e.value):t.indexOf(lang.ownInput[0])<0&&(e.checked=!0,$A(e,"checked","checked"),$A(e,"value",labels[e.id].lastChild.data.replace(n,""))),$A(e,"MC","useLib.call.ownInput(this)")}}},set:e,active:!1}}(),keyStore="",lastActive=!1,keyControl=!1,setCursorStep=function(e,t,n){var i=!/text|password|passwordrepeat|file|search|email|number|date|color|datetime|datetime-local|month|range|search|tel|time|url|week/.test(e.type),a=8==t&&$CN.contains($P(e),cssNS.isCover)&&e!=$P(e).firstChild||37==t?-1:39==t&&1,r=!!e.onclick&&(String(e.onclick).indexOf("coverOpen")>-1?1:-1);if(a&&(i||r||a>0&&e.selectionStart===e.value.length||a<0&&0===e.selectionEnd)){for(var o=filterElements(e.form,!0),s=0;s<o.length&&o[s]!==e;s++);if(o[s]!==e)return!1;"SELECT"==e.tagName&&(e.disabled="disabled",setTimeout((function(){e.disabled=!1,setStatus(e,"focused",0)}),0));do{s+=39==t?1:-1}while(o[s]&&(o[s].disabled||!$P(o[s]).offsetWidth));return o[s]?(setFocus(o[s]),lastActive=o[s],$A($("doFastfeeder"),"aria-label",getFormDef(o[s]).type+":"+getLabelText(o[s])+"="+o[s].value)):$A($("doFastfeeder"),"aria-label",lang.fastLabel[1]),!0}if((i&&"range"!=e.type&&"SELECT"!=e.tagName||e.onclick)&&(38==t||40==t||13==t))return e.click(),lastActive=e,!0;if(!i&&n.shiftKey&&46==t)e.value="";else if(27===t||160==t||192==t)return lastActive=e,e.blur(),!0;return!1};return $E(D,"DOMContentLoaded",(function(){useLib.ownHTML="<!DOCTYPE HTML>\n"+$T(D,"html",1).outerHTML.replace(/<style\s+id="uLsecureStore"[\s\S]+?<\/style>\n/,"").replace(/<link[^>]+uLaccess.json.css"[^>]+>/,""),initUseLib()})),{conf:conf,htmlSupport:htmlSupport,cssNS:cssNS,wikiSigns:wikiSigns,langConf:langConf,patterns:patterns,call:call,calc:{},intern:{},extern:extern,landmarks:htmlSupport.landmarks,DOM:DOM,WIKI:this.WIKI,ajax:ajax,loadJSONCSS:loadJSONCSS,getHTMLTag:getHTMLTag,openPopup:openPopup,setMsg:dialog.setMsg,offMsg:function(e){return dialog.closeBox($(e)),null},alert:dialog.alert,prompt:dialog.prompt,confirm:dialog.confirm,setModal:dialog.setModal,listSelect:function(e,t,n,i,a){var r=ensureId(e);if(e.value||(e.value=""),a&&call.uLinit(r,(function(e){e=e[r+"uL[]"],a("multiSelect"==t?e:e[0])})),Array.isArray(n))for(var o=0;o<n.length;o++)n[o]={textContent:n[o]};return n=metaReaction.singleSelect.getContent(e,t,n),n=["form",{name:r+cssNS.modal,"data-ul":t,CN:cssNS[t]}].concat(n),dialog.setModal(r,!1,"draggable closable",n,i||""),!1},setStatus:setStatus,init:initUseLib,initForm:initForm,manageFormData:manageFormData,formDef:formDef,getFormDef:getFormDef,getStruct:getStruct,getHeadElement:getHeadElement,getContainer:getStruct.container,setContainer:function(e,t){var n,i=getLandmark(e);if(i){n=$T(i,"form");for(var a=0;n&&a<n.length;a++)delete formDef[n[a].name];n=getStruct.container(e,t),i=$P(i).replaceChild(n,i),initBody()}return W},getBanner:function(e,t){var n="";return n=t&&t.text?t.text.replace(WIKI.regs.findEngine(),(function(t,n){return i(e,n)})):"((logo))((copyright "+i(e,"copyright")+"))\n\n="+i(e,"title")+"\n\n=="+i(e,"description"),getStruct.container("banner",n);function i(e,t){return e[t]?e[t]:"copyright"==t&&e.author?"© "+e.author:""}},toggleNavigation:function(e,t){var n=e?e.currentTarget:$("uLmainnavi"+t.replace(/[^a-z0-9-_:\.]/gi,"")),i=getLandmark("navigation"),a=useLib.WIKI.sections,r=!1,o=!e;if((i=i?$Q(i,"."+cssNS.active,1):i)&&$CN.remove(i,cssNS.active),$CN.add(n,cssNS.active),n==i)o=!0;else{(i=n.href.match(/[\/\?]?([\d\.]+)$/))&&(t=i[1]);try{W.opener&&W.opener.preview&&(r=!0)}catch(n){}r?o=W.opener.preview.changeText(t.replace(/uLmainnavi/,""),W):a&&(a=a[0]||a[1])&&a[t]&&(useLib.WIKI.getHeadElements(a,t),dispatchEvent(W,"beforeunload"),manageFormData(!0),setTimeout((function(){useLib.setContainer("main",a[t].htmlWiki),DOM.replaceNode(getLandmark("banner"),useLib.getBanner(a[t],a.banner)),useLib.WIKI.setHeadElements(D,a[t],null),D.body.id=t,initBody(),dispatchEvent(W,"load")}),500),o=!0)}e&&o&&(e.preventDefault(),e.stopPropagation())},getTypePattern:function(e){return String(cover.getTypeRegexp(e)).slice(1,-1)},extend:{},checkDesign:checkDesign,getCheckSum:getCheckSum,extendCoverTypes:function(e,t,n=!1,i=!1){useLib.WIKI.find&&useLib.WIKI.find.type.indexOf(e)<0&&useLib.WIKI.find.type.push(e),htmlSupport.type[e]='[type="'+e+'"]',cssNS[e]=e,cover.types[e]=t,n&&(metaReaction[e]=n),i&&(JSONexpands[e]=i)},extendDynamicSelect:function(e,t){if(e&&t){for(var n=0;n<t.length;n++)t[n].textContent=i(t[n]);dynamicSelects[e]=t}function i(e){return((e=e.textContent)[conf.lang]||e.en||e).trim()}},extendWikiEnsemble:function(e,t,n){this.WIKI.find&&(this.WIKI.find.type.push(e),this.WIKI.find.typeTrans.push(t?t[conf.lang]||t.en:e)),this.wikiEnsemble[e]=n},wikiEnsemble:wikiEnsemble,toTop:function(){W.focus()},sortListAlphanumeric:function(e,t){var n=loadJSONCSS(e,(function(){useLib.sortListAlphanumeric(e,t)}));n&&(t=void 0!==t&&!1!==t&&!isNaN(t)&&t,n=n.list,!1===t?n.sort((function(e,t){return compare(e,t)})):n.sort((function(e,n){return compare(e[t],n[t])})),dialog.alert("=sorted JSON of "+e+"\n\n((pre\n\n"+JSON.stringify(n).replace(!1===t?/(\[|\]|\",)/g:/(\",)/g,"$1\n")+"\n))"))},dynListAct:function(e,t){return call.dynList.action($P($Q(D,'[data-ul-dynlist^="'+e+':"]',1),3),e,t)},setJSONValues:setJSONValues,getJSONValues:getJSONValues,escapeUnicode:escapeUnicode,unescapeUnicode:unescapeUnicode,$:$,$T:$T,$Q:$Q,$I:$I,$D:$D,$A:$A,$E:$E,$GS:$GS,$LS:$LS,$CN:$CN,$CE:$CE,repeat:repeat,compare:compare,str2obj:str2obj,optionExtRegEx:optionExtRegEx,delayRemove:delayRemove}}function setListSelect(e,t){var n=$(e),i=[],a=0;if(lastActive=n,o(),t.length){for(var r=0;r<t.length;r++)t[r]=t[r].split("::"),t[r]=t[r].join(" "),i.push(["a",{href:'javascript:useLib.call.listSelectOnKey("'+e+'","'+t[r]+'")'},t[r]]),t[r].length>t[a].length&&(a=r);cover.listSelect="uLlistSelect",dialog.setEleDiv(n,cover.listSelect,["div",{CN:cssNS.listSelect}].concat(i),1),i=$(cover.listSelect),$S(i).width=(DOM.textWidth(t[a],cssNS.listSelect)+16)/10+"em",$E(i,"KD",(function(e){keyControl=l})),$E(D,"MC",s)}function o(){call.modalClose($("uLlistSelect")),$E(D,"MC",s,-1),cover.listSelect=keyControl=!1,setFocus(n)}function s(e){var t=$(cover.listSelect);t&&t.contains(e.currentTarget)||o()}function l(e,t){var i=D.activeElement;return 9==(e=9==e||27==e?9:13==e||32==e?13:37==e||38==e?-1:39==e||40==e?1:0)?o():!e||t.ctrlKey||t.metaKey||(13==e?i.click():-1!=e||i.previousSibling?i=-1==e?i.previousSibling:i.nextSibling||i:(i=n,o()),setFocus(i)),!0}call.uLinit("listSelectOnKey",(function(e,t){var n=e.indexOf(idCover);n>-1?(e=e.slice(0,n),n=(n=getFormDef($(e))).subs.COUNTRY&&n.subs.COUNTRY.id==n.first?n.subs.COUNTRY.next:n.first,doEvent.setInput($(n),e,t,!0)):$(e).value=t,o()}))}function initTooltips(e){for(var t,n=$Q(e||D,"."+cssNS.inform),i=0;i<n.length;i++)$CN.add(!(!(t=$P(n[i])).previousElementSibling||!/h\d/i.test(t.previousElementSibling.tagName))&&t.previousElementSibling||n[i].previousElementSibling,cssNS.hasInform),$S($P(n[i])).position="relative"}function initFold(e){for(var t,n,i=$CE(["span",{CN:cssNS.locker,MC:"useLib.call.foldLock(event)"}]),a=$Q(e||D.body,"."+cssNS.fold+",."+cssNS.pinfold),r=0;r<a.length;r++){t=$CN.contains(a[r],cssNS.pinfold)?cssNS.pinfold:cssNS.fold,n=$Q($P(a[r]),a[r].tagName);for(var o=0;o<n.length;o++){if($CN.contains(n[o],t)||$CN.add(n[o],t),t==cssNS.pinfold&&!$CN.contains(n[o].lastChild,cssNS.allpins)&&!$CN.contains(n[o].lastChild,cssNS.locker)&&(n[o].appendChild(i.cloneNode(!0)),0==o)){var s=i.cloneNode(!0);s.className=cssNS.allpins,s.title=lang.allpins[0],s.onclick=function(){for(var e=0,t=$CN.contains(this,cssNS.locked)?"remove":"add";e<n.length;e++)$CN[t](n[e].lastChild,cssNS.locked),$CN[t](n[e],cssNS.open),$CN[t](this,cssNS.locked)},n[o].appendChild(s)}0==o&&($CN.add(n[o],cssNS.open),$A(n[o],"aria-expanded","true")),$E(n[o],"MC",function(e){return function(t){t.stopPropagation(),$Q(this,"."+cssNS.locked).length||($CN.contains(this,cssNS.open)?($CN.remove(this,cssNS.open),$A(this,"aria-expanded","false")):(!function(t){for(var n=0;n<e.length;n++)if(e[n]!=t&&$CN.contains(e[n],cssNS.open)&&!$Q(e[n],"."+cssNS.locked).length)return $CN.remove(e[n],cssNS.open),void $A(e[n],"aria-expanded","false")}(this),$CN.add(this,cssNS.open),$A(this,"aria-expanded","true"),DOM.scrollIntoView(this.nextElementSibling,1.7)))}}(n))}}}function initViaHTML(e){if(!formDef[e.form.name]||!formDef[e.form.name][e.name]){var t=getFormDef(e);if(valueAttr.type){if(!(i="SELECT"==e.tagName?e.type:"TEXTAREA"==e.tagName?"textarea":"BUTTON"==e.tagName?"button":$A(e,"type")||e.type)||"text"==i)for(var n in i="text",htmlSupport.type)a("type",n)&&(i=n);!function(n){checkInit(t,"type")&&(t.type=n);htmlSupport.type[n]&&"file"!=n&&"password"!=n?e.type="text":"file"==n&&$A(e.form,"enctype","multipart/form-data")}(i)}for(var i in htmlSupport.status)statusAttr[i]&&a("status",i)&&r(i)}function a(t,n){return!!("function"==typeof htmlSupport[t][n]?htmlSupport[t][n](e):$Q($P(e),htmlSupport[t][n],1))}function r(e){checkInit(t,e)&&(t[e]=!0)}}function fullFormDef(e,t){var n,i,a=getSelectionAttr(e);for(n in t.id=ensureId(e),normAttr)t[n]||((i=$A(e,n))&&"data-ul"==n?(t.data=strParse(i),"isGrouper"==i&&($A(e,n,-1),$A(e,n+"-grp",i))):t[n]=i&&"type"==n?i||e.type:i);return valueAttr[n="mnemonic"]&&checkInit(t,n)&&(t[n]?t[n].count++:t[n]={count:0},initMnemonic(e,t[n])),r("value"),r("defaultValue"),valueAttr[n="resetValue"]&&checkInit(t,n)&&(t[n]=t.value.slice(0)),function(){for(var n in htmlSupport.status)t[n]&&(setStatus(e,n,!0),"required"==n&&"checked"==a&&$CN.add(e,cssNS.notDone))}(),delete t.isInit,t;function r(n){if(valueAttr[n]&&checkInit(t,n)){internChange=!0;var r="value"!=n&&"default"+(a.slice(0,1).toUpperCase()+a.slice(1));if("value"==a)t[n]=pushAttr(t[n],$A(e,n)||"");else if("selected"==a)for(var o=0,s=$T(e,"option");o<s.length;o++)i=$A(s[o],r||a),t[n]=pushAttr(t[n],!1===i?i:s[o].value);else!1!==(i=$A(e,r||a))&&$CN.contains(e,cssNS.notDone)&&onchange(e,null),t[n]=pushAttr(t[n],!1===i?i:e.value);t[n]||(t[n]=[]),setEleValue(e,t[n])}internChange=!1}}function initForm(e){if(conf.doUseLib){internChange=!0;for(var t=0,n=$T(e,"label");t<n.length;t++)a(n[t]);for(t=0,n=$T(e,"legend");t<n.length;t++)r(n[t]);for(t=0,n=filterElements(e);t<n.length;t++)initViaHTML(n[t]),initElement(n[t]);internChange=!1,initOnCalc(e),ownInput.init(e),setRequiredLegend(e),e.noValidate=!0,$E(e,"reset",i),$E(e,"submit",i)}function i(e){var t=e.currentTarget;!$A(t,"data-submit")&&call[e.type+"Form"](t)||(e.preventDefault(),e.stopPropagation()),$A(t,"data-submit","true"),setTimeout((function(){$A(t,"data-submit",-1)}),1e3)}function a(e){var t=$(e.htmlFor);!t&&((t=e.nextSibling)&&t.form||(t=e.previousSibling)&&t.form)&&(e.htmlFor=ensureId(t)),t&&(labels[e.htmlFor]=e,"radio"==t.type||"checkbox"==t.type?$E(e,"MC",(function(){t.focus()})):($E(e,"M2",resetElements),!conf.taskSupport||$CN.contains(t,"noTask")||$CN.contains(e.lastChild,cssNS.task)||e.appendChild($CE(["span",{CN:cssNS.task,MD:"useLib.call.taskstep(this.parentNode)"}]))))}function r(e){$E(e,"M2",resetElements)}}function initElement(e){var t=getFormDef(e);function n(e,t,n){var i=cover.pattern2Char(n);-1==e.title.indexOf(i.chars)&&(e.title+=" "+i.chars),n.length&&(n=("^"!=n[0]?"^(":"")+cover.replaceShortn(n)+("$"!=n.slice(-1)?")$":""),t.regexp=new RegExp(n),t.type="pattern",$E(e,"OB",(function(){e.value.length&&!t.regexp.test(e.value)?(cover.keyMsg(e,"Error"),dialog.setMsg("error","formatError",e,5500)):dialog.removeError(e,e)}))),t.max=t.max||(n.length?function(e){for(e=repeat(e,conf.maxLengthInput);e.length&&!t.regexp.test(e);e=e.slice(1));return e.length||conf.maxLengthInput}((i.charRegexp+"")[2]):conf.maxLengthInput),t.charRegexp=i.charRegexp,i.charRegexp&&"TEXTAREA"!=e.tagName&&($E(e,"KD",useLib.call.coverBeforeInput),$E(e,"KU",useLib.call.coverAfterInput)),$E(e,"OF",useLib.call.coverOnFocus)}checkInit(t,"uLelement")&&(fullFormDef(e,t),"SELECT"==e.tagName?function(e,t){var n,i=t.data?$I($A(e,"max"))?"dynamicExtend":"dynamicSelect":"select-multiple"==e.type||"1"==$A(e,"min")?"multiSelect":($I($A(e,"max"))||e.options.length)>conf.selectLimit&&"singleSelect";t.required&&(!(n=e.options[0])||""!==n.value&&(n.value||n.text)?i||2==e.options.length||(n=D.createElement("option"),a(),e.add(n,0)):i?(e.remove(0),n=null):a());!i&&(t.required&&3==e.options.length||!t.required&&2==e.options.length)&&(i="toggleSelect",-1==e.selectedIndex&&(e.selectedIndex=0),t.value=t.resetValue=getEleValue(e));i?(t.type=i,cover.getContent(e,i),"toggleSelect"==i&&(e=$(e.id+"uLcover-0"))?e.style="width:100%":"dynamic"==i.slice(0,7)&&("dynamicExtend"==i?t.first&&t.value[0]&&($(t.first).value=t.value[0]):dynamicSelects[t.data]||(dynamicSelects[t.data]=[]))):t.type="select";function a(){n.text=lang.requiredSelect[0],n.value="",-1==e.selectedIndex&&(e.selectedIndex=0)}}(e,t):"TEXTAREA"==e.tagName?function(e,t){n(e,t,$A(e,"pattern")||""),t.type="textarea"}(e,t):{radio:1,checkbox:1,button:1}[e.type]||function(e,t){var i;switch(t.type){case"hidden":case"checkbox":case"radio":break;case"icon":$CN.add($P(e),cssNS[t.type]),$CN.add($P(e),e.value),$A($P(e),"title",getLabelText(e)),$E(e,"OC",(function(){$CN.remove($P(e),t.resetValue),$CN.add($P(e),e.value)}));break;case"picture":function a(e){e=e.target||e,$A($P(e),"style",$A($P(e),"style").replace(/--ulpicture:url\([^\)]+\);/,"")+'--ulpicture:url("'+e.value+'");'),e.value=""}$CN.add($P(e),cssNS[t.type]),$A($P(e),"title",getLabelText(e)),a(e),$E(e,"OC",a);break;case"pattern":(i=$A(e,"pattern")||"").length&&!cover.getContent(e,"pattern",i)&&n(e,t,i);break;default:cover.getContent(e,t.type)||"text"!=e.type||n(e,t,"")}}(e,t),initStatusControl(e,t),"DIV"!=$P(e).tagName&&console.warn("useLib hint: parentNode of element: "+e.id+" has no DIV-container!"))}function initOnCalc(e){for(var t,n,i=0,a=$Q(e,"[oncalc]"),r="",o="";i<a.length;i++)t=$P(a[i],2),$CN.contains(t,cssNS.dynlist)&&(t=$P(t,1)),(n=$A(a[i],"oncalc")).indexOf("useLib.call.dynList.calcIt")>-1&&!/_\d_$/.test(a[i].name)?o=a[i].name.match(/(\.\w+)\.([\w-]+)$/)[1]:(r=n.match(/('|")(([\w]+,)*([\w]+))\1/))&&(o=r[4],r=r[2]),(o=$Q(t,'[name$="'+o+'"]',1))&&(uLeval(n,r,o,a[i]),$A(o,"onchange")&&setTimeout(function(e){return function(){try{e.onchange()}catch(e){}}}(o),100))}function initExtend(){var ext;for(var n in useLib.extend)for(var v in ext=eval(n),useLib.extend[n])ext[v]="function"==typeof useLib.extend[n][v]?useLib.extend[n][v]:JSON.parse(JSON.stringify(useLib.extend[n][v]))}function initLandmarks(){var e,t=htmlSupport.landmarks;for(var n in t)(e=!!t[n]&&$Q(D,t[n].selector,1))&&($A(e,"role",n),$CN.contains(e.lastChild,cssNS.design)||(e.innerHTML+='<div class="'+cssNS.design+'"><span><span><span><span><span></span></span></span></span></span></div>'))}function initLinks(e){e=$T(e,"a");for(var t=0;t<e.length;t++)$E(e[t],"click",(function(){delayRemove(this,cssNS.jumper,5)}))}function initTitle(e){var t;e=$Q(e,"[title]");for(var n=0;n<e.length;n++)t=e[n].title,lang[t]&&(lang[t][1]&&DOM.insertBefore(e[n].firstChild,$CE(["span",{CN:cssNS.explain},lang[t][1]])),lang[t][0]&&DOM.insertBefore(e[n].firstChild,$CE(["span",{CN:cssNS.inform},lang[t][0]])),$A(e[n],"title",-1))}function setRequiredLegend(e){var t=formDef[e.name],n=0,i=0;for(var a in t)i++,t[a].required&&n++;$CN.add(e,0==n?"":n==i?cssNS.onlyRequired:n>.7*i?cssNS.manyRequired:cssNS.someRequired)}function bodyKeyControl(e){var t,n=e.keyCode,i=!1;e.ctrlKey||e.metaKey||"doFastfeeder"==e.currentTarget.id?e.metaKey&&67===n&&D.activeElement&&(i=$($A(D.activeElement,"id").replace(/uLcover-\d+$/,"")),(i=$CN.contains(i,cssNS.covered)&&(i=getFormDef(i))?cover.getValue(i,i.type,"local"):i.value)&&i.length&&(e.preventDefault(),navigator.clipboard.writeText(i))):((i=113===n)&&$(cssNS.fastfeeder)?$CN.toggle($(cssNS.fastfeeder),cssNS.minimized)||$("doFastfeeder").focus():13!=n&&27!=n||!(t=String(dialog.layer.slice(-1))).length?keyControl?i=keyControl(n,e):"BODY"==D.activeElement.tagName?32!==n&&1==e.key.length?(keyStore+=e.key,mnemonics[keyStore]&&(n=$(mnemonics[keyStore]))&&(setFocus(n),keyStore="",i=!0)):(lastActive=lastActive||D.forms[0].elements[0])&&(i=8==n||37==n||39==n)&&setFocus(lastActive):D.activeElement&&(keyStore="","A"==D.activeElement.tagName?8!==n&&(i=32===n)&&D.activeElement.click():D.activeElement&&D.activeElement.form&&(i=setCursorStep(D.activeElement,n,e))):(t=t.slice(0,-11),13==n?"radio"==D.activeElement.type||/uL[\w\._-]+Filter/.test(D.activeElement.id)?D.activeElement.click():(t=$Q($(t+cssNS.modal),"button")).length&&t[t.length-1].click():dialog.closeModal(t),i=!0),i&&(e.preventDefault(),e.stopPropagation()))}function manageFormData(e,t="intern"){for(var n,i=useLib[t],a=0;a<D.forms.length;a++)(n=D.forms[a].name)&&n.length?e?i[n]=getJSONValues(null,n):i[n]?setJSONValues(i[n],D.forms[n]):"extern"!=t&&initForm(D.forms[a]):console.warn("useLib hint: form has no name!")}function initBody(){DOM.scrollStop(!0),useLib.beforeUseLib&&useLib.beforeUseLib(),controls.init(),initExtend(),initLandmarks(),initLinks(D.body),initTitle(D.body),initFold(D.body),initTooltips(),conf.dataManagePath||(manageFormData(!1,"extern"),manageFormData(!1)),DOM.scrollStop(!1)}function initUseLib(){for(var e in $CN.add(D.body,cssNS.hasScript),$E(W,"focus",firstAct),conf.sounds)"string"==typeof conf.sounds[e]&&(conf.sounds[e]=new Audio(conf.sounds[e]));conf.doUseLib&&(initId(),$E(W,"KD",bodyKeyControl),$E(W,"paste",(function(e){var t=e.target;$P(t)&&$CN.contains($P(t,2),cssNS.hasCover)&&setTimeout((function(){t.dispatchEvent(new KeyboardEvent("keyup",{key:""}))}),0)})),D.body.id||(D.body.id="useLibKnown"),initBody())}console.warn("useLib: configuration problem: No useLib configuration defined => aborted!")}(window,document);